/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.NodesDropCallback;
import com.alee.extended.tree.NodesTransferable;
import com.alee.extended.tree.TreeDropHandler;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.utils.CollectionUtils;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.TransferHandler;

public class NodesDropHandler<N extends UniqueNode, T extends WebTree<N>, M extends WebTreeModel<N>>
implements TreeDropHandler<N, T, M> {
    @Nullable
    protected ArrayList<DataFlavor> flavors;

    @Override
    @NotNull
    public List<DataFlavor> getSupportedFlavors() {
        if (this.flavors == null) {
            this.flavors = CollectionUtils.asList((Object[])new DataFlavor[]{NodesTransferable.FLAVOR});
        }
        return this.flavors;
    }

    @Override
    public boolean canDrop(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination) {
        boolean canDrop;
        try {
            List nodes = (List)support.getTransferable().getTransferData(NodesTransferable.FLAVOR);
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            canDrop = this.canDrop(support, tree, model, destination, dl.getChildIndex(), nodes);
        }
        catch (Exception ufe) {
            canDrop = false;
        }
        return canDrop;
    }

    protected boolean canDrop(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int dropIndex, @NotNull List<N> nodes) {
        return true;
    }

    @Override
    public boolean prepareDrop(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int index) {
        boolean prepared;
        try {
            List nodes = (List)support.getTransferable().getTransferData(NodesTransferable.FLAVOR);
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            prepared = this.prepareDrop(support, tree, model, destination, dl.getChildIndex(), nodes);
        }
        catch (Exception ufe) {
            prepared = false;
        }
        return prepared;
    }

    protected boolean prepareDrop(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int dropIndex, @NotNull List<N> nodes) {
        return this.canDrop(support, tree, model, destination, dropIndex, nodes);
    }

    @Override
    public void performDrop(@NotNull TransferHandler.TransferSupport support, @NotNull T tree, @NotNull M model, @NotNull N destination, int index, @NotNull NodesDropCallback<N> callback) {
        try {
            List nodes = (List)support.getTransferable().getTransferData(NodesTransferable.FLAVOR);
            callback.dropped(nodes);
            callback.completed();
        }
        catch (Exception e) {
            callback.failed(e);
        }
    }
}

