/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.ExTreeDataProvider;
import com.alee.extended.tree.ExTreeModel;
import com.alee.extended.tree.FilterableNodes;
import com.alee.extended.tree.SortableNodes;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeModel;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.compare.Filter;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WebExTree<N extends UniqueNode>
extends WebTree<N>
implements FilterableNodes<N>,
SortableNodes<N> {
    public static final String DATA_PROVIDER_PROPERTY = "dataProvider";
    public static final String FILTER_PROPERTY = "filter";
    public static final String COMPARATOR_PROPERTY = "comparator";
    @Nullable
    protected Filter<N> filter;
    @Nullable
    protected Comparator<N> comparator;

    public WebExTree() {
        this(StyleId.auto);
    }

    public WebExTree(@Nullable ExTreeDataProvider dataProvider) {
        this(StyleId.auto, dataProvider);
    }

    public WebExTree(@Nullable ExTreeDataProvider dataProvider, @Nullable TreeCellRenderer renderer) {
        this(StyleId.auto, dataProvider, renderer);
    }

    public WebExTree(@Nullable ExTreeDataProvider dataProvider, @Nullable TreeCellEditor editor) {
        this(StyleId.auto, dataProvider, editor);
    }

    public WebExTree(@Nullable ExTreeDataProvider dataProvider, @Nullable TreeCellRenderer renderer, @Nullable TreeCellEditor editor) {
        this(StyleId.auto, dataProvider, renderer, editor);
    }

    public WebExTree(@NotNull StyleId id) {
        this(id, null, null, null);
    }

    public WebExTree(@NotNull StyleId id, @Nullable ExTreeDataProvider dataProvider) {
        this(id, dataProvider, null, null);
    }

    public WebExTree(@NotNull StyleId id, @Nullable ExTreeDataProvider dataProvider, @Nullable TreeCellRenderer renderer) {
        this(id, dataProvider, renderer, null);
    }

    public WebExTree(@NotNull StyleId id, @Nullable ExTreeDataProvider dataProvider, @Nullable TreeCellEditor editor) {
        this(id, dataProvider, null, editor);
    }

    public WebExTree(@NotNull StyleId id, @Nullable ExTreeDataProvider dataProvider, @Nullable TreeCellRenderer renderer, @Nullable TreeCellEditor editor) {
        super(id, dataProvider != null ? new ExTreeModel(dataProvider) : null);
        if (renderer != null) {
            this.setCellRenderer(renderer);
        }
        if (editor != null) {
            this.setEditable(true);
            this.setCellEditor(editor);
        }
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.extree;
    }

    @Override
    @Nullable
    public ExTreeModel<N> getModel() {
        return (ExTreeModel)super.getModel();
    }

    @Override
    public void setModel(@Nullable TreeModel newModel) {
        WebLookAndFeel.checkEventDispatchThread();
        if (newModel instanceof ExTreeModel) {
            ExTreeDataProvider oldDataProvider;
            TreeModel old = this.getModel();
            if (old != null) {
                oldDataProvider = ((ExTreeModel)old).getDataProvider();
                ((ExTreeModel)old).uninstall(this);
            } else {
                oldDataProvider = null;
            }
            ExTreeModel model = (ExTreeModel)newModel;
            model.install(this);
            super.setModel(model);
            this.firePropertyChange(DATA_PROVIDER_PROPERTY, oldDataProvider, model.getDataProvider());
        } else if (newModel != null) {
            throw new NullPointerException("Only ExTreeModel implementations can be used for WebExTree");
        }
    }

    @Nullable
    public ExTreeDataProvider<N> getDataProvider() {
        TreeModel model = this.getModel();
        return model != null ? ((ExTreeModel)model).getDataProvider() : null;
    }

    public void setDataProvider(@NotNull ExTreeDataProvider dataProvider) {
        WebLookAndFeel.checkEventDispatchThread();
        this.setModel(new ExTreeModel(dataProvider));
    }

    @Override
    @Nullable
    public Filter<N> getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(@Nullable Filter<N> filter) {
        WebLookAndFeel.checkEventDispatchThread();
        if (filter != this.getFilter()) {
            Filter<N> old = this.getFilter();
            this.filter = filter;
            this.filter();
            this.firePropertyChange(FILTER_PROPERTY, old, filter);
        }
    }

    @Override
    public void clearFilter() {
        this.setFilter(null);
    }

    @Override
    public void filter() {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).filter();
        }
    }

    @Override
    public void filter(@NotNull N parent) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).filter(parent);
        }
    }

    @Override
    public void filter(@NotNull N parent, boolean recursively) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).filter(parent, recursively);
        }
    }

    @Override
    @Nullable
    public Comparator<N> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(@Nullable Comparator<N> comparator) {
        WebLookAndFeel.checkEventDispatchThread();
        if (comparator != this.getComparator()) {
            Comparator<N> old = this.getComparator();
            this.comparator = comparator;
            this.sort();
            this.firePropertyChange(COMPARATOR_PROPERTY, old, comparator);
        }
    }

    @Override
    public void clearComparator() {
        this.setComparator(null);
    }

    @Override
    public void sort() {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).sort();
        }
    }

    @Override
    public void sort(@NotNull N parent) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).sort(parent);
        }
    }

    @Override
    public void sort(@NotNull N parent, boolean recursively) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).sort(parent, recursively);
        }
    }

    public void filterAndSort() {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).filterAndSort(true);
        }
    }

    public void filterAndSort(@NotNull N parent) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).filterAndSort(parent, false);
        }
    }

    public void filterAndSort(@NotNull N parent, boolean recursively) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).filterAndSort(parent, recursively);
        }
    }

    public void setChildNodes(@NotNull N parent, @NotNull List<N> children) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).setChildNodes(parent, children);
        }
    }

    public void addChildNode(@NotNull N parent, @NotNull N child) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).addChildNode(parent, child);
        }
    }

    public void addChildNodes(@NotNull N parent, @NotNull List<N> children) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).addChildNodes(parent, children);
        }
    }

    public void insertChildNodes(@NotNull List<N> children, @NotNull N parent, int index) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).insertNodesInto(children, parent, index);
        }
    }

    public void insertChildNodes(@NotNull N[] children, @NotNull N parent, int index) {
        TreeModel model = this.getModel();
        if (model != null) {
            model.insertNodesInto((UniqueNode[])children, (UniqueNode)parent, index);
        }
    }

    public void insertChildNode(@NotNull N child, @NotNull N parent, int index) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).insertNodeInto((MutableTreeNode)child, (MutableTreeNode)parent, index);
        }
    }

    public void removeNode(@NotNull String nodeId) {
        N node = this.findNode(nodeId);
        if (node != null) {
            this.removeNode(node);
        }
    }

    public void removeNode(@NotNull N node) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).removeNodeFromParent((MutableTreeNode)node);
        }
    }

    public void removeNodes(@NotNull List<N> nodes) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).removeNodesFromParent(nodes);
        }
    }

    public void removeNodes(@NotNull N[] nodes) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((ExTreeModel)model).removeNodesFromParent(nodes);
        }
    }

    @NotNull
    public N getNode(@NotNull String nodeId) {
        N node = this.findNode(nodeId);
        if (node == null) {
            throw new RuntimeException("Node with identifier is not available: " + nodeId);
        }
        return node;
    }

    @Nullable
    public N findNode(@NotNull String nodeId) {
        TreeModel model = this.getModel();
        return model != null ? (N)((ExTreeModel)model).findNode(nodeId) : null;
    }

    @Override
    public void updateNode(@NotNull String nodeId) {
        this.updateNode(this.findNode(nodeId));
    }

    public void updateNodeStructure(@NotNull String nodeId) {
        this.updateNodeStructure(this.findNode(nodeId));
    }

    public void updateNodeStructure(@Nullable N node) {
        TreeModel model = this.getModel();
        if (model != null) {
            ((WebTreeModel)model).updateNodeStructure(node);
        }
    }

    public void reloadSelectedNodes() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                UniqueNode node = (UniqueNode)this.getNodeForPath(path);
                if (node == null) continue;
                this.performReload(node, path, false);
            }
        }
    }

    @Nullable
    public N reloadNodeUnderPoint(@NotNull Point point) {
        return this.reloadNodeUnderPoint(point.x, point.y);
    }

    @Nullable
    public N reloadNodeUnderPoint(int x, int y) {
        return this.reloadPath(this.getPathForLocation(x, y));
    }

    @Nullable
    public N reloadRootNode() {
        return (N)this.reloadNode((UniqueNode)this.getRootNode());
    }

    @Nullable
    public N reloadNode(@NotNull String nodeId) {
        return this.reloadNode(this.findNode(nodeId));
    }

    @Nullable
    public N reloadNode(@Nullable N node) {
        return this.reloadNode(node, false);
    }

    @Nullable
    public N reloadNode(@Nullable N node, boolean select) {
        TreePath path;
        N reloadedNode = null;
        if (node != null && (path = this.getPathForNode(node)) != null) {
            this.performReload(node, path, select);
            reloadedNode = node;
        }
        return reloadedNode;
    }

    @Nullable
    public N reloadPath(@Nullable TreePath path) {
        return this.reloadPath(path, false);
    }

    @Nullable
    public N reloadPath(@Nullable TreePath path, boolean select) {
        UniqueNode node;
        UniqueNode reloadedNode = null;
        if (path != null && (node = (UniqueNode)this.getNodeForPath(path)) != null) {
            this.performReload(node, path, select);
            reloadedNode = node;
        }
        return (N)reloadedNode;
    }

    protected void performReload(@NotNull N node, @NotNull TreePath path, boolean select) {
        TreeModel model;
        if (select && !this.isPathSelected(path)) {
            this.setSelectionPath(path);
        }
        if (!this.isExpanded(path)) {
            this.expandPath(path);
        }
        if ((model = this.getModel()) != null) {
            ((ExTreeModel)model).reload((TreeNode)node);
        }
    }

    @Override
    public void expandNode(@NotNull String nodeId) {
        this.expandNode(this.findNode(nodeId));
    }

    public void expandPath(@NotNull List<String> pathNodeIds) {
        this.expandPath(pathNodeIds, true, true);
    }

    public void expandPath(@NotNull List<String> pathNodeIds, boolean expandLastNode) {
        this.expandPath(pathNodeIds, expandLastNode, true);
    }

    public void expandPath(@NotNull List<String> pathNodeIds, boolean expandLastNode, boolean selectLastNode) {
        ArrayList ids = CollectionUtils.copy(pathNodeIds);
        for (int initial = 0; initial < ids.size(); ++initial) {
            N initialNode = this.findNode((String)ids.get(initial));
            if (initialNode == null) continue;
            for (int i = 0; i <= initial; ++i) {
                ids.remove(i);
            }
            if (ids.size() <= 0) break;
            this.expandPathImpl(initialNode, ids, expandLastNode, selectLastNode);
            break;
        }
    }

    protected void expandPathImpl(@NotNull N currentNode, @NotNull List<String> leftToExpand, boolean expandLastNode, boolean selectLastNode) {
        if (leftToExpand.size() > 0) {
            this.expandNode(currentNode);
            N nextNode = this.findNode(leftToExpand.get(0));
            leftToExpand.remove(0);
            if (nextNode != null) {
                this.expandPathImpl(nextNode, leftToExpand, expandLastNode, selectLastNode);
            } else {
                this.expandPathEndImpl(currentNode, expandLastNode, selectLastNode);
            }
        } else {
            this.expandPathEndImpl(currentNode, expandLastNode, selectLastNode);
        }
    }

    protected void expandPathEndImpl(@NotNull N lastFoundNode, boolean expandLastNode, boolean selectLastNode) {
        if (selectLastNode) {
            this.setSelectedNode(lastFoundNode);
        }
        if (expandLastNode) {
            this.expandNode(lastFoundNode);
        }
    }
}

