/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.FileTreeDataProvider;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.FileTreeNodeFilter;
import com.alee.extended.tree.FileTreeRootType;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.extended.tree.WebFileTreeCellEditor;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.WebTreeModel;
import com.alee.managers.drag.transfer.FilesTransferHandler;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.compare.Filter;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.LoggerFactory;

public class WebFileTree
extends WebAsyncTree<FileTreeNode> {
    protected boolean filesDropSearchEnabled;
    @Nullable
    protected FilesTransferHandler fileLookupDropHandler = null;
    protected int delayedSelectionId = 0;

    public WebFileTree() {
        this(StyleId.auto, FileTreeRootType.drives);
    }

    public WebFileTree(@NotNull FileTreeRootType rootType) {
        this(StyleId.auto, rootType.getRoots());
    }

    public WebFileTree(@NotNull String rootPath) {
        this(StyleId.auto, new File(rootPath));
    }

    public WebFileTree(File ... rootFiles) {
        this(StyleId.auto, CollectionUtils.asList((Object[])rootFiles));
    }

    public WebFileTree(@NotNull List<File> rootFiles) {
        this(StyleId.auto, rootFiles);
    }

    public WebFileTree(@NotNull StyleId id) {
        this(id, FileTreeRootType.drives);
    }

    public WebFileTree(@NotNull StyleId id, @NotNull FileTreeRootType rootType) {
        this(id, rootType.getRoots());
    }

    public WebFileTree(@NotNull StyleId id, @NotNull String rootPath) {
        this(id, new File(rootPath));
    }

    public WebFileTree(@NotNull StyleId id, File ... rootFiles) {
        this(id, CollectionUtils.asList((Object[])rootFiles));
    }

    public WebFileTree(@NotNull StyleId id, @NotNull List<File> rootFiles) {
        super(id, (AsyncTreeDataProvider)new FileTreeDataProvider(rootFiles), (TreeCellEditor)new WebFileTreeCellEditor());
        this.setEditable(false);
        this.setShowsRootHandles(true);
        this.setRootVisible(CollectionUtils.notEmpty(rootFiles) && rootFiles.size() == 1);
        this.setFilesDropSearchEnabled(true);
    }

    @Nullable
    public FileTreeDataProvider getDataProvider() {
        return (FileTreeDataProvider)super.getDataProvider();
    }

    @Override
    public void setModel(@Nullable TreeModel newModel) {
        boolean async = this.isAsyncLoading();
        this.setAsyncLoading(false);
        super.setModel(newModel);
        this.setAsyncLoading(async);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.filetree;
    }

    @NotNull
    protected FilesTransferHandler getFileLookupDropHandler() {
        if (this.fileLookupDropHandler == null) {
            this.fileLookupDropHandler = new FilesTransferHandler(false, this.filesDropSearchEnabled){

                @Override
                public boolean isDropEnabled() {
                    return WebFileTree.this.filesDropSearchEnabled;
                }

                @Override
                public boolean filesDropped(@NotNull List<File> files) {
                    boolean dropped = false;
                    if (files.size() > 0) {
                        WebFileTree.this.setSelectedFile(files.get(0), true);
                        dropped = true;
                    }
                    return dropped;
                }
            };
        }
        return this.fileLookupDropHandler;
    }

    public boolean isFilesDropSearchEnabled() {
        return this.filesDropSearchEnabled;
    }

    public void setFilesDropSearchEnabled(boolean filesDropSearchEnabled) {
        this.filesDropSearchEnabled = filesDropSearchEnabled;
        TransferHandler transferHandler = this.getTransferHandler();
        if (filesDropSearchEnabled) {
            FilesTransferHandler lookupDropHandler = this.getFileLookupDropHandler();
            if (lookupDropHandler != transferHandler) {
                this.setTransferHandler(lookupDropHandler);
            }
        } else if (transferHandler != null && transferHandler == this.getFileLookupDropHandler()) {
            this.setTransferHandler(null);
        }
    }

    @Nullable
    public Filter<File> getFileFilter() {
        Filter filter = this.getFilter();
        return filter instanceof FileTreeNodeFilter ? ((FileTreeNodeFilter)filter).getFilter() : null;
    }

    public void setFileFilter(@Nullable Filter<File> filter) {
        this.setFilter(filter != null ? new FileTreeNodeFilter(filter) : null);
    }

    public void setRootName(@NotNull String rootName) {
        TreeModel model = this.getModel();
        if (model != null) {
            FileTreeNode rootNode = (FileTreeNode)this.getRootNode();
            rootNode.setTitle(rootName);
            ((WebTreeModel)model).updateNode(rootNode);
        }
    }

    public void setSelectedFile(@Nullable File file) {
        this.setSelectedFile(file, false);
    }

    public void setSelectedFile(@Nullable File file, boolean expand) {
        this.expandToFile(file, true, expand);
    }

    public void expandFile(@Nullable File file) {
        this.expandToFile(file, false, true);
    }

    public void expandToFile(@Nullable File file) {
        this.expandToFile(file, false, false);
    }

    public void expandToFile(@Nullable File file, boolean select) {
        this.expandToFile(file, select, false);
    }

    public void expandToFile(@Nullable File file, boolean select, boolean expand) {
        this.expandToFile(file, select, expand, null);
    }

    public void expandToFile(@Nullable File file, final boolean select, final boolean expand, final @Nullable Runnable finalAction) {
        WebLookAndFeel.checkEventDispatchThread();
        if (file != null) {
            ++this.delayedSelectionId;
            final int selectionId = this.delayedSelectionId;
            final FileTreeNode node = this.getClosestNode(file);
            if (node != null) {
                if (FileUtils.equals((File)node.getFile(), (File)file)) {
                    if (select && selectionId == this.delayedSelectionId) {
                        this.performFileSelection(node, expand);
                    } else {
                        if (expand) {
                            this.expandNode(node);
                        }
                        this.scrollToNode(node);
                    }
                    if (finalAction != null) {
                        finalAction.run();
                    }
                } else {
                    int index;
                    final List path = FileUtils.getFilePath((File)file);
                    for (int i = index = path.indexOf(node.getFile()); i >= 0; --i) {
                        path.remove(i);
                    }
                    this.addAsyncTreeListener(new AsyncTreeAdapter<FileTreeNode>(){
                        private FileTreeNode lastNode;
                        {
                            this.lastNode = node;
                        }

                        @Override
                        public void loadCompleted(@NotNull FileTreeNode parent, @NotNull List<FileTreeNode> children) {
                            if (parent == this.lastNode) {
                                boolean found = false;
                                for (FileTreeNode child : children) {
                                    File childFile = child.getFile();
                                    if (childFile == null || !childFile.equals(path.get(0))) continue;
                                    found = true;
                                    if (path.size() == 1) {
                                        WebFileTree.this.removeAsyncTreeListener(this);
                                        if (select && selectionId == WebFileTree.this.delayedSelectionId) {
                                            WebFileTree.this.performFileSelection(child, expand);
                                        } else {
                                            if (expand) {
                                                WebFileTree.this.expandNode(child);
                                            }
                                            WebFileTree.this.scrollToNode(child);
                                        }
                                        if (finalAction == null) break;
                                        finalAction.run();
                                        break;
                                    }
                                    this.lastNode = child;
                                    path.remove(0);
                                    WebFileTree.this.reloadNode(child);
                                    break;
                                }
                                if (!found) {
                                    WebFileTree.this.removeAsyncTreeListener(this);
                                    if (select && selectionId == WebFileTree.this.delayedSelectionId) {
                                        WebFileTree.this.performFileSelection(parent, false);
                                    } else {
                                        WebFileTree.this.scrollToNode(parent);
                                    }
                                    if (finalAction != null) {
                                        finalAction.run();
                                    }
                                }
                            }
                        }

                        @Override
                        public void loadFailed(@NotNull FileTreeNode parent, @NotNull Throwable cause) {
                            if (parent == this.lastNode) {
                                WebFileTree.this.removeAsyncTreeListener(this);
                                if (select && selectionId == WebFileTree.this.delayedSelectionId) {
                                    WebFileTree.this.performFileSelection(parent, false);
                                } else {
                                    WebFileTree.this.scrollToNode(parent);
                                }
                                if (finalAction != null) {
                                    finalAction.run();
                                }
                            }
                        }
                    });
                    this.reloadNode(node);
                }
            }
        } else if (select) {
            this.clearSelection();
        }
    }

    protected void performFileSelection(@NotNull FileTreeNode node, boolean expand) {
        try {
            TreePath path = node.getTreePath();
            this.setSelectionPath(path);
            if (expand) {
                Rectangle pathBounds;
                if (!this.isExpandSelected()) {
                    this.expandPath(path);
                }
                if ((pathBounds = this.getPathBounds(path)) != null) {
                    Rectangle vr = this.getVisibleRect();
                    Rectangle rect = new Rectangle(vr.x, pathBounds.y, vr.width, vr.height);
                    this.scrollRectToVisible(rect);
                }
            } else {
                this.scrollPathToVisible(path);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(WebFileTree.class).error(e.toString(), (Throwable)e);
        }
    }

    @Nullable
    public File getSelectedFile() {
        FileTreeNode selectedNode = (FileTreeNode)this.getSelectedNode();
        return selectedNode != null ? selectedNode.getFile() : null;
    }

    @NotNull
    public List<File> getSelectedFiles() {
        ArrayList<File> selectedFiles = new ArrayList<File>();
        if (this.getSelectionPaths() != null) {
            for (TreePath path : this.getSelectionPaths()) {
                FileTreeNode node = (FileTreeNode)this.getNodeForPath(path);
                if (node == null) continue;
                selectedFiles.add(node.getFile());
            }
        }
        return selectedFiles;
    }

    public boolean addFile(@NotNull File parent, @NotNull File file) {
        return this.addFiles(parent, file);
    }

    public boolean addFile(@NotNull FileTreeNode parentNode, @NotNull File file) {
        return this.addFiles(parentNode, file);
    }

    public boolean addFiles(@NotNull File parent, File ... files) {
        return this.addFiles(parent, (List<File>)CollectionUtils.asList((Object[])files));
    }

    public boolean addFiles(@NotNull FileTreeNode parentNode, File ... files) {
        return this.addFiles(parentNode, (List<File>)CollectionUtils.asList((Object[])files));
    }

    public boolean addFiles(@NotNull File parent, @NotNull List<File> files) {
        FileTreeNode parentNode = this.getNode(parent);
        return parentNode != null && this.addFiles(parentNode, files);
    }

    public boolean addFiles(@NotNull FileTreeNode parentNode, @NotNull List<File> files) {
        boolean changed = false;
        if (this.hasBeenExpanded(this.getPathForNode(parentNode))) {
            ArrayList<FileTreeNode> childNodes = new ArrayList<FileTreeNode>(files.size());
            for (File file : files) {
                childNodes.add(new FileTreeNode(file));
            }
            this.addChildNodes(parentNode, childNodes);
            changed = true;
        }
        return changed;
    }

    public void removeFile(@NotNull File file) {
        FileTreeNode node = this.getNode(file);
        if (node != null) {
            this.removeNode(node);
        }
    }

    public void removeFiles(File ... files) {
        for (File file : files) {
            this.removeFile(file);
        }
    }

    public void removeFiles(@NotNull List<File> files) {
        for (File file : files) {
            this.removeFile(file);
        }
    }

    public void startEditingFile(final @NotNull File file) {
        FileTreeNode node = this.getNode(file);
        if (node != null) {
            this.startEditingNode(node);
        } else {
            this.expandToFile(file, false, false, new Runnable(){

                @Override
                public void run() {
                    FileTreeNode node = WebFileTree.this.getNode(file);
                    if (node != null) {
                        WebFileTree.this.startEditingNode(node);
                    }
                }
            });
        }
    }

    @NotNull
    public List<File> getFileChildren(@NotNull FileTreeNode node) {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            files.add(((FileTreeNode)node.getChildAt(i)).getFile());
        }
        return files;
    }

    @Nullable
    public FileTreeNode getNode(@NotNull File file) {
        FileTreeNode node = this.getClosestNode(file);
        return node != null && FileUtils.equals((File)file, (File)node.getFile()) ? node : null;
    }

    @Nullable
    public FileTreeNode getClosestNode(@NotNull File file) {
        TreeModel model = this.getModel();
        return model != null ? this.getClosestNode((FileTreeNode)((AsyncTreeModel)model).getRoot(), FileUtils.getFilePath((File)file)) : null;
    }

    @Nullable
    protected FileTreeNode getClosestNode(@NotNull FileTreeNode node, @NotNull List<File> path) {
        FileTreeNode closestNode = null;
        boolean finished = false;
        File file = node.getFile();
        if (file != null && path.contains(file)) {
            int index;
            for (int i = index = path.indexOf(file); i >= 0; --i) {
                path.remove(i);
            }
            closestNode = this.getDeepestPathNode(node, path);
            finished = true;
        }
        if (!finished) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                FileTreeNode found = this.getClosestNode((FileTreeNode)node.getChildAt(i), path);
                if (found == null) continue;
                closestNode = found;
                break;
            }
        }
        return closestNode;
    }

    @NotNull
    protected FileTreeNode getDeepestPathNode(@NotNull FileTreeNode pathNode, @NotNull List<File> path) {
        FileTreeNode deepestPathNode = pathNode;
        if (path.size() > 0) {
            for (int i = 0; i < pathNode.getChildCount(); ++i) {
                FileTreeNode child = (FileTreeNode)pathNode.getChildAt(i);
                File childFile = child.getFile();
                if (childFile == null || !childFile.equals(path.get(0))) continue;
                path.remove(0);
                deepestPathNode = this.getDeepestPathNode(child, path);
                break;
            }
        }
        return deepestPathNode;
    }

    public void reloadChildrenSync(@NotNull File folder) {
        this.reloadChildrenSync(folder, false);
    }

    public void reloadChildrenSync(@NotNull File folder, boolean select) {
        FileTreeNode node = this.getNode(folder);
        if (node != null) {
            this.reloadNodeSync(node, select);
        }
    }

    public void reloadChildren(@NotNull File folder) {
        this.reloadChildren(folder, false);
    }

    public void reloadChildren(@NotNull File folder, boolean select) {
        FileTreeNode node = this.getNode(folder);
        if (node != null) {
            this.reloadNode(node, select);
        }
    }
}

