/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.api.jdk.Function;
import com.alee.extended.WebContainer;
import com.alee.extended.behavior.ComponentResizeBehavior;
import com.alee.extended.window.Popup;
import com.alee.extended.window.PopupListener;
import com.alee.extended.window.PopupMethods;
import com.alee.extended.window.PopupMethodsImpl;
import com.alee.extended.window.WPopupUI;
import com.alee.extended.window.WebPopupWindow;
import com.alee.extended.window.WindowFollowBehavior;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.window.WindowMethods;
import com.alee.laf.window.WindowMethodsImpl;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.EmptyComponent;
import com.alee.utils.swing.WebTimer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import javax.swing.JWindow;

public class WebPopup<T extends WebPopup<T>>
extends WebContainer<T, WPopupUI>
implements Popup,
PopupMethods,
WindowMethods<WebPopupWindow> {
    protected boolean closeOnOuterAction = true;
    protected boolean closeOnFocusLoss = false;
    protected boolean draggable = false;
    protected boolean resizable = false;
    protected boolean followInvoker = false;
    protected boolean alwaysOnTop = false;
    protected float opacity = 1.0f;
    protected boolean animate = ProprietaryUtils.isWindowTransparencyAllowed();
    protected float fadeStepSize = 0.1f;
    protected float visibilityProgress = 0.0f;
    protected boolean displaying = false;
    protected boolean hiding = false;
    protected WebTimer showAnimator = null;
    protected WebTimer hideAnimator = null;
    protected WebPopupWindow window;
    protected Component invoker;
    protected Window invokerWindow;
    protected transient WeakReference<Component> defaultFocus;
    protected transient AWTEventListener mouseListener;
    protected transient GlobalFocusListener focusListener;
    protected transient ComponentResizeBehavior resizeBehavior;
    protected transient WindowFollowBehavior followBehavior;
    protected transient boolean changingOpacity = false;

    public WebPopup() {
        this(StyleId.auto);
    }

    public WebPopup(Component component) {
        this(StyleId.auto, component);
    }

    public WebPopup(LayoutManager layout, Component ... components) {
        this(StyleId.auto, layout, components);
    }

    public WebPopup(StyleId styleId) {
        this(styleId, null);
    }

    public WebPopup(StyleId styleId, Component component) {
        this(styleId, new BorderLayout(), component);
    }

    public WebPopup(StyleId styleId, LayoutManager layout, Component ... components) {
        this.setFocusCycleRoot(true);
        this.setLayout(layout);
        this.updateUI();
        this.setStyleId(styleId);
        this.add(components);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.popup;
    }

    public boolean isCloseOnOuterAction() {
        return this.closeOnOuterAction;
    }

    public void setCloseOnOuterAction(boolean close) {
        this.closeOnOuterAction = close;
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean closeOnFocusLoss) {
        this.closeOnFocusLoss = closeOnFocusLoss;
        if (this.window != null) {
            this.window.setCloseOnFocusLoss(closeOnFocusLoss);
        }
    }

    public JWindow getWindow() {
        return this.window;
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public Window getInvokerWindow() {
        return this.invokerWindow;
    }

    public float getVisibilityProgress() {
        return this.visibilityProgress;
    }

    public boolean isDisplaying() {
        return this.displaying;
    }

    public boolean isHiding() {
        return this.hiding;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        if (this.draggable != draggable) {
            this.draggable = draggable;
            this.updateResizeBehavior();
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        if (this.resizable != resizable) {
            this.resizable = resizable;
            this.updateResizeBehavior();
        }
    }

    protected void updateResizeBehavior() {
        if (this.isDraggable() || this.isResizable()) {
            if (this.resizeBehavior == null) {
                this.installResizeBehavior();
            }
        } else {
            this.uninstallResizeBehavior();
        }
    }

    protected void installResizeBehavior() {
        this.resizeBehavior = new ComponentResizeBehavior((Component)this, new ResizeDirections(6));
        this.resizeBehavior.install();
    }

    protected void uninstallResizeBehavior() {
        this.resizeBehavior.uninstall();
        this.resizeBehavior = null;
    }

    public boolean isFollowInvoker() {
        return this.followInvoker;
    }

    public void setFollowInvoker(boolean followInvoker) {
        if (this.followInvoker != followInvoker) {
            this.followInvoker = followInvoker;
            if (followInvoker) {
                if (this.followBehavior == null && this.window != null && this.invokerWindow != null) {
                    this.installFollowBehavior();
                }
            } else if (this.followBehavior != null && this.window != null && this.invokerWindow != null) {
                this.uninstallFollowBehavior();
            }
        }
    }

    protected void installFollowBehavior() {
        this.followBehavior = new WindowFollowBehavior(this.window, this.invokerWindow);
        this.followBehavior.install();
    }

    protected void uninstallFollowBehavior() {
        this.followBehavior.uninstall();
        this.followBehavior = null;
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.alwaysOnTop = alwaysOnTop;
        if (this.window != null) {
            this.window.setAlwaysOnTop(alwaysOnTop);
        }
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public float getFadeStepSize() {
        return this.fadeStepSize;
    }

    public void setFadeStepSize(float fadeStepSize) {
        this.fadeStepSize = fadeStepSize;
    }

    public Component getDefaultFocus() {
        return this.defaultFocus != null ? (Component)this.defaultFocus.get() : null;
    }

    public void setDefaultFocus(Component defaultFocus) {
        this.defaultFocus = new WeakReference<Component>(defaultFocus);
    }

    public WebPopup showPopup(Component invoker, Point location) {
        return this.showPopup(invoker, location.x, location.y);
    }

    public WebPopup showPopup(Component invoker, int x, int y) {
        this.showPopupImpl(invoker, x, y);
        return this;
    }

    protected void showPopupImpl(Component invoker, int x, int y) {
        WebLookAndFeel.checkEventDispatchThread();
        if (!this.displaying && (this.window == null || this.hiding)) {
            if (this.window != null) {
                if (this.hideAnimator != null) {
                    this.hideAnimator.stop();
                    this.hideAnimator = null;
                }
                this.window.dispose();
                this.hiding = false;
            }
            this.displaying = true;
            this.invoker = invoker;
            this.invokerWindow = CoreSwingUtils.getWindowAncestor((Component)invoker);
            this.visibilityProgress = this.animate ? 0.0f : 1.0f;
            this.window = this.createWindow(x, y);
            this.firePopupWillBeOpened();
            this.mouseListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    MouseEvent e;
                    if (WebPopup.this.isCloseOnOuterAction() && (e = (MouseEvent)event).getID() == 501) {
                        Component component = e.getComponent();
                        if (WebPopup.this.window != null && WebPopup.this.window != component && !WebPopup.this.window.isAncestorOf(component)) {
                            WebPopup.this.hidePopup();
                        }
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this.mouseListener, 16L);
            this.focusListener = new GlobalFocusListener(){

                @Override
                public void focusChanged(@Nullable Component oldFocus, @Nullable Component newFocus) {
                    if (WebPopup.this.isCloseOnOuterAction() && newFocus == null) {
                        WebPopup.this.hidePopup();
                    }
                }
            };
            FocusManager.registerGlobalFocusListener(this, this.focusListener);
            this.window.setVisible(true);
            Component defaultFocus = this.getDefaultFocus();
            if (defaultFocus != null && this.isAncestorOf(defaultFocus) && defaultFocus.isShowing()) {
                defaultFocus.requestFocus();
            } else {
                Component nextFocus = SwingUtils.findFocusableComponent(this);
                if (nextFocus != null && nextFocus.isShowing()) {
                    nextFocus.requestFocus();
                } else {
                    this.window.requestFocus();
                }
            }
            if (this.animate) {
                this.showAnimator = WebTimer.repeat((long)SwingUtils.frameRateDelay(48), (long)0L, (boolean)true, (ActionListener)new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (WebPopup.this.visibilityProgress < 1.0f) {
                            WebPopup.this.visibilityProgress = Math.min(WebPopup.this.visibilityProgress + WebPopup.this.fadeStepSize, 1.0f);
                            WebPopup.this.setWindowOpacity(WebPopup.this.visibilityProgress);
                        } else {
                            WebPopup.this.showAnimator.stop();
                            WebPopup.this.showAnimator = null;
                            WebPopup.this.displaying = false;
                        }
                        WebPopup.this.showAnimationStepPerformed();
                    }
                });
            }
            if (this.followInvoker && this.invokerWindow != null) {
                this.installFollowBehavior();
            }
            if (!this.animate) {
                this.displaying = false;
            }
            this.firePopupOpened();
        }
    }

    protected WebPopupWindow createWindow(int x, int y) {
        WebPopupWindow window = new WebPopupWindow(this.invokerWindow);
        window.setContentPane(this);
        if (this.invokerWindow != null) {
            Rectangle bos = CoreSwingUtils.getBoundsOnScreen((Component)this.invoker, (boolean)false);
            window.setLocation(bos.x + x, bos.y + y);
        } else {
            window.setLocation(x, y);
        }
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(@NotNull WindowEvent e) {
                WebPopup.this.completePopupHide();
            }
        });
        window.pack();
        window.setCloseOnFocusLoss(this.isCloseOnFocusLoss());
        window.setAlwaysOnTop(this.isAlwaysOnTop());
        this.updateOpaque(window);
        this.updateOpacity(window);
        return window;
    }

    public WebPopup hidePopup() {
        this.hidePopupImpl();
        return this;
    }

    protected void hidePopupImpl() {
        WebLookAndFeel.checkEventDispatchThread();
        if (!this.hiding && this.window != null && this.window.isShowing()) {
            this.hiding = true;
            if (this.displaying) {
                if (this.showAnimator != null) {
                    this.showAnimator.stop();
                }
                this.displaying = false;
            }
            float f = this.visibilityProgress = this.animate ? 1.0f : 0.0f;
            if (this.animate) {
                this.hideAnimator = WebTimer.repeat((long)SwingUtils.frameRateDelay(48), (long)0L, (boolean)true, (ActionListener)new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (WebPopup.this.visibilityProgress > 0.0f) {
                            WebPopup.this.visibilityProgress = Math.max(WebPopup.this.visibilityProgress - WebPopup.this.fadeStepSize, 0.0f);
                            WebPopup.this.setWindowOpacity(WebPopup.this.visibilityProgress);
                        } else {
                            WebPopup.this.window.dispose();
                            WebPopup.this.hideAnimator.stop();
                            WebPopup.this.hideAnimator = null;
                            WebPopup.this.hiding = false;
                        }
                        WebPopup.this.hideAnimationStepPerformed();
                    }
                });
            } else {
                this.window.dispose();
                this.hiding = false;
            }
        }
    }

    protected void completePopupHide() {
        if (this.window != null) {
            this.firePopupWillBeClosed();
            this.window.setContentPane(new EmptyComponent());
            if (this.followInvoker && this.invokerWindow != null) {
                this.uninstallFollowBehavior();
            }
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.mouseListener);
            this.mouseListener = null;
            FocusManager.unregisterGlobalFocusListener(this, this.focusListener);
            this.focusListener = null;
            this.invokerWindow = null;
            this.invoker = null;
            this.window.dispose();
            this.window = null;
            this.firePopupClosed();
        }
    }

    protected void showAnimationStepPerformed() {
    }

    protected void hideAnimationStepPerformed() {
    }

    @Override
    public void addPopupListener(PopupListener listener) {
        this.listenerList.add(PopupListener.class, listener);
    }

    @Override
    public void removePopupListener(PopupListener listener) {
        this.listenerList.remove(PopupListener.class, listener);
    }

    @Override
    public PopupListener beforePopupOpen(Runnable action) {
        return PopupMethodsImpl.beforePopupOpen(this, action);
    }

    @Override
    public PopupListener onPopupOpen(Runnable action) {
        return PopupMethodsImpl.onPopupOpen(this, action);
    }

    @Override
    public PopupListener beforePopupClose(Runnable action) {
        return PopupMethodsImpl.beforePopupClose(this, action);
    }

    @Override
    public PopupListener onPopupClose(Runnable action) {
        return PopupMethodsImpl.onPopupClose(this, action);
    }

    public void firePopupWillBeOpened() {
        for (PopupListener listener : (PopupListener[])this.listenerList.getListeners(PopupListener.class)) {
            listener.popupWillBeOpened();
        }
    }

    public void firePopupOpened() {
        for (PopupListener listener : (PopupListener[])this.listenerList.getListeners(PopupListener.class)) {
            listener.popupOpened();
        }
    }

    public void firePopupWillBeClosed() {
        for (PopupListener listener : (PopupListener[])this.listenerList.getListeners(PopupListener.class)) {
            listener.popupWillBeClosed();
        }
    }

    public void firePopupClosed() {
        for (PopupListener listener : (PopupListener[])this.listenerList.getListeners(PopupListener.class)) {
            listener.popupClosed();
        }
    }

    public WebPopupWindow pack() {
        if (this.window != null) {
            this.window.pack();
        }
        return this.window;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        if (!this.changingOpacity) {
            this.changingOpacity = true;
            super.setOpaque(isOpaque);
            this.setWindowOpaque(isOpaque);
            this.changingOpacity = false;
        }
    }

    @Override
    public boolean isWindowOpaque() {
        return this.isOpaque();
    }

    @Override
    public WebPopupWindow setWindowOpaque(boolean opaque) {
        return this.updateOpaque(this.window);
    }

    protected WebPopupWindow updateOpaque(WebPopupWindow window) {
        if (window != null) {
            WindowMethodsImpl.setWindowOpaque(window, this.isOpaque());
        }
        return window;
    }

    @Override
    public float getWindowOpacity() {
        return this.opacity;
    }

    @Override
    public WebPopupWindow setWindowOpacity(float opacity) {
        this.opacity = opacity;
        return this.updateOpacity(this.window);
    }

    protected WebPopupWindow updateOpacity(WebPopupWindow window) {
        if (window != null) {
            WindowMethodsImpl.setWindowOpacity(window, this.opacity * this.visibilityProgress);
        }
        return window;
    }

    @Override
    public WebPopupWindow center() {
        return (WebPopupWindow)WindowMethodsImpl.center(this.window);
    }

    @Override
    public WebPopupWindow center(Component relativeTo) {
        return (WebPopupWindow)WindowMethodsImpl.center(this.window, relativeTo);
    }

    @Override
    public WebPopupWindow center(int width, int height) {
        return (WebPopupWindow)WindowMethodsImpl.center(this.window, width, height);
    }

    @Override
    public WebPopupWindow center(Component relativeTo, int width, int height) {
        return (WebPopupWindow)WindowMethodsImpl.center(this.window, relativeTo, width, height);
    }

    @Override
    public WebPopupWindow packToWidth(int width) {
        return (WebPopupWindow)WindowMethodsImpl.packToWidth(this.window, width);
    }

    @Override
    public WebPopupWindow packToHeight(int height) {
        return (WebPopupWindow)WindowMethodsImpl.packToHeight(this.window, height);
    }

    @Override
    public WPopupUI getUI() {
        return (WPopupUI)this.ui;
    }

    public void setUI(WPopupUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }

    public class ResizeDirections
    implements Function<Point, CompassDirection> {
        protected final int distance;

        public ResizeDirections(int distance) {
            this.distance = distance;
        }

        public int distance() {
            return this.distance;
        }

        public CompassDirection apply(Point point) {
            Object direction;
            if (WebPopup.this.isResizable()) {
                Insets i = WebPopup.this.getInsets();
                direction = point.getY() < (double)(i.top + this.distance) ? (point.getX() < (double)(i.left + this.distance) ? CompassDirection.northWest : (point.getX() > (double)(WebPopup.this.getWidth() - i.right - this.distance) ? CompassDirection.northEast : CompassDirection.north)) : (point.getY() > (double)(WebPopup.this.getHeight() - i.bottom - this.distance) ? (point.getX() < (double)(i.left + this.distance) ? CompassDirection.southWest : (point.getX() > (double)(WebPopup.this.getWidth() - i.right - this.distance) ? CompassDirection.southEast : CompassDirection.south)) : (point.getX() < (double)(i.left + this.distance) ? CompassDirection.west : (point.getX() > (double)(WebPopup.this.getWidth() - i.right - this.distance) ? CompassDirection.east : (WebPopup.this.isDraggable() ? CompassDirection.center : null))));
            } else {
                direction = WebPopup.this.isDraggable() ? CompassDirection.center : null;
            }
            return direction;
        }
    }
}

