/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.api.annotations.NotNull;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.progressbar.WebProgressBar;
import com.alee.laf.window.WebDialog;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;

public class WebProgressDialog
extends WebDialog {
    private int preferredProgressWidth = 0;
    private boolean shownOnce = false;
    private final WebPanel container;
    private final WebLabel titleText;
    private final WebProgressBar progressBar;
    private Component middleComponent = null;

    public WebProgressDialog(String title) {
        this((Window)null, title);
    }

    public WebProgressDialog(Window owner, String title) {
        super(owner, title);
        this.setLayout(new BorderLayout());
        this.container = new WebPanel((LayoutManager)new BorderLayout(5, 5), new Component[0]);
        this.container.setMargin(10, 10, 10, 10);
        this.container.setOpaque(false);
        this.add((Component)this.container, "Center");
        this.titleText = new WebLabel(StyleId.labelShadow, " ", 0, new Object[0]){

            @Override
            @NotNull
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                ps.width = 0;
                return ps;
            }
        };
        this.container.add((Component)this.titleText, (Object)"North");
        this.progressBar = new WebProgressBar(0, 0, 100){

            @Override
            @NotNull
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                if (WebProgressDialog.this.preferredProgressWidth > 0) {
                    ps.width = WebProgressDialog.this.preferredProgressWidth;
                }
                return ps;
            }
        };
        this.progressBar.setStringPainted(true);
        this.container.add((Component)this.progressBar, (Object)"South");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setModal(false);
        this.updateBounds();
        this.setLocationRelativeTo(owner);
    }

    public void setText(final String text) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.titleText.setText(text);
            }
        });
    }

    public void setTextKey(final String key) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.titleText.setLanguage(key, new Object[0]);
            }
        });
    }

    public String getText() {
        return this.titleText.getText();
    }

    public void setProgressText(final String progressText) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setString(progressText);
            }
        });
    }

    public String getProgressText() {
        return this.progressBar.getString();
    }

    public void setShowProgressText(final boolean showProgressText) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setStringPainted(showProgressText);
                WebProgressDialog.this.updateBounds();
            }
        });
    }

    public boolean isShowProgressText() {
        return this.progressBar.isStringPainted();
    }

    public void setIndeterminate(final boolean indeterminate) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setIndeterminate(indeterminate);
            }
        });
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    public void setMinimum(final int minimum) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setMinimum(minimum);
            }
        });
    }

    public int getMinimum() {
        return this.progressBar.getMinimum();
    }

    public void setMaximum(final int maximum) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setMaximum(maximum);
            }
        });
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public void setProgress(final int progress) {
        CoreSwingUtils.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebProgressDialog.this.progressBar.setValue(progress);
            }
        });
    }

    public int getPreferredProgressWidth() {
        return this.preferredProgressWidth;
    }

    public void setPreferredProgressWidth(int preferredProgressWidth) {
        this.preferredProgressWidth = preferredProgressWidth;
        this.updateBounds();
    }

    public int getProgress() {
        return this.progressBar.getValue();
    }

    public WebLabel getTitleLabel() {
        return this.titleText;
    }

    public Component getMiddleComponent() {
        return this.middleComponent;
    }

    public void setMiddleComponent(Component middleComponent) {
        if (this.middleComponent != null) {
            this.container.remove(middleComponent);
        }
        this.middleComponent = middleComponent;
        this.container.add(middleComponent, (Object)"Center");
        this.container.revalidate();
        this.updateBounds();
    }

    public WebProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setShowProgressBar(boolean showProgressBar) {
        if (showProgressBar) {
            if (this.progressBar.getParent() != this.container) {
                this.container.add((Component)this.progressBar, (Object)"South");
                this.container.revalidate();
                this.updateBounds();
            }
        } else if (this.progressBar.getParent() == this.container) {
            this.container.remove((Component)this.progressBar);
            this.container.revalidate();
            this.updateBounds();
        }
    }

    private void updateBounds() {
        this.pack();
        if (!this.shownOnce) {
            this.setLocationRelativeTo(this.getOwner());
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.shownOnce = true;
        }
        super.setVisible(b);
    }
}

