/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.api.annotations.NotNull;
import com.alee.laf.WebUI;
import com.alee.laf.button.ButtonInputListener;
import com.alee.laf.button.WButtonInputListener;
import com.alee.utils.LafUtils;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;

public abstract class WButtonUI<C extends AbstractButton>
extends ButtonUI
implements WebUI<C> {
    protected ButtonInputListener<C> inputListener;
    protected C button;

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "Button.";
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.button = (AbstractButton)c;
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.button = null;
    }

    protected void installDefaults() {
        LafUtils.installDefaults(this.button, this.getPropertyPrefix());
    }

    protected void uninstallDefaults() {
        LafUtils.uninstallDefaults(this.button);
    }

    protected void installListeners() {
        this.inputListener = this.createButtonInputListener();
        this.inputListener.install(this.button);
    }

    protected void uninstallListeners() {
        this.inputListener.uninstall(this.button);
        this.inputListener = null;
    }

    @NotNull
    protected ButtonInputListener<C> createButtonInputListener() {
        return new WButtonInputListener();
    }
}

