/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.checkbox;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;

@XStreamAlias(value="CheckIcon")
public class CheckIcon<C extends AbstractButton, D extends IDecoration<C, D>, I extends CheckIcon<C, D, I>>
extends AbstractContent<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Stroke stroke;
    @XStreamAsAttribute
    @Nullable
    protected Color color;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "check";
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d) {
        return false;
    }

    @Nullable
    public Stroke getStroke(@NotNull C c, @NotNull D d) {
        return this.stroke;
    }

    @NotNull
    public Color getColor(@NotNull C c, @NotNull D d) {
        if (this.color == null) {
            throw new DecorationException("Shape color must be specified");
        }
        return this.color;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)this.stroke, (this.stroke != null ? 1 : 0) != 0);
        Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)this.color);
        GeneralPath gp = new GeneralPath();
        gp.moveTo((double)bounds.x + (double)bounds.width * 0.1875, (double)bounds.y + (double)bounds.height * 0.375);
        gp.lineTo((double)bounds.x + (double)bounds.width * 0.4575, (double)bounds.y + (double)bounds.height * 0.6875);
        gp.lineTo((double)bounds.x + (double)bounds.width * 0.875, (double)bounds.y + (double)bounds.height * 0.125);
        g2d.draw(gp);
        GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
        GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        return new Dimension(0, 0);
    }
}

