/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.laf.AbstractUIInputListener;
import com.alee.laf.UIActionMap;
import com.alee.laf.desktoppane.InternalFrameInputListener;
import com.alee.laf.desktoppane.WInternalFrameUI;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class WInternalFrameInputListener<C extends JInternalFrame, U extends WInternalFrameUI<C>>
extends AbstractUIInputListener<C, U>
implements InternalFrameInputListener<C>,
PropertyChangeListener,
ComponentListener,
MouseListener,
MouseMotionListener,
WindowFocusListener,
SwingConstants {
    protected static final int RESIZE_NONE = 0;
    private Rectangle parentBounds;
    protected boolean dragging = false;
    protected boolean resizing = false;
    protected int absX;
    protected int absY;
    protected int relX;
    protected int relY;
    protected Rectangle startingBounds;
    protected int resizeDir;
    protected boolean discardRelease = false;
    protected int resizeCornerSize = 16;
    protected boolean componentListenerAdded = false;

    @Override
    public void install(@NotNull C component) {
        super.install(component);
        ((Container)component).addPropertyChangeListener(this);
        ((Component)component).addMouseListener(this);
        ((Component)component).addMouseMotionListener(this);
        if (((Component)component).getParent() != null && !this.componentListenerAdded) {
            ((Component)component).getParent().addComponentListener(this);
            this.componentListenerAdded = true;
        }
        UIActionMap actionMap = new UIActionMap();
        SwingUtilities.replaceUIActionMap(component, actionMap);
    }

    @Override
    public void uninstall(@NotNull C component) {
        SwingUtilities.replaceUIInputMap(component, 2, null);
        SwingUtilities.replaceUIActionMap(component, null);
        if (((Component)component).getParent() != null && this.componentListenerAdded) {
            ((Component)component).getParent().removeComponentListener(this);
            this.componentListenerAdded = false;
        }
        ((Component)component).removeMouseMotionListener(this);
        ((Component)component).removeMouseListener(this);
        ((Component)component).removePropertyChangeListener(this);
        super.uninstall(component);
    }

    @Override
    public void installPane(@NotNull Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    @Override
    public void uninstallPane(@NotNull Component component) {
        component.removeMouseMotionListener(this);
        component.removeMouseListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (Objects.equals((Object)prop, (Object)"closed")) {
            if (newValue == Boolean.TRUE) {
                this.cancelResize();
                if (((JInternalFrame)this.component).getParent() != null && this.componentListenerAdded) {
                    ((JInternalFrame)this.component).getParent().removeComponentListener(this);
                    this.componentListenerAdded = false;
                }
                ((WInternalFrameUI)this.componentUI).closeFrame();
            }
        } else if (Objects.equals((Object)prop, (Object)"maximum")) {
            if (newValue == Boolean.TRUE) {
                ((WInternalFrameUI)this.componentUI).maximizeFrame();
            } else {
                ((WInternalFrameUI)this.componentUI).minimizeFrame();
            }
        } else if (Objects.equals((Object)prop, (Object)"icon")) {
            if (newValue == Boolean.TRUE) {
                ((WInternalFrameUI)this.componentUI).iconifyFrame();
            } else {
                ((WInternalFrameUI)this.componentUI).deiconifyFrame();
            }
        } else if (Objects.equals((Object)prop, (Object)"selected")) {
            if (newValue == Boolean.TRUE && oldValue == Boolean.FALSE) {
                ((WInternalFrameUI)this.componentUI).activateFrame();
            } else if (newValue == Boolean.FALSE && oldValue == Boolean.TRUE) {
                ((WInternalFrameUI)this.componentUI).deactivateFrame();
            }
        } else if (Objects.equals((Object)prop, (Object)"ancestor")) {
            if (newValue == null) {
                this.cancelResize();
            }
            this.parentBounds = ((JInternalFrame)this.component).getParent() != null ? ((JInternalFrame)this.component).getParent().getBounds() : null;
            if (((JInternalFrame)this.component).getParent() != null && !this.componentListenerAdded) {
                ((JInternalFrame)this.component).getParent().addComponentListener(this);
                this.componentListenerAdded = true;
            }
        } else if (Objects.equals((Object)prop, (Object[])new Object[]{"title", "closable", "iconable", "maximizable"})) {
            Dimension dim = ((JInternalFrame)this.component).getMinimumSize();
            Dimension frame_dim = ((JInternalFrame)this.component).getSize();
            if (dim.width > frame_dim.width) {
                ((JInternalFrame)this.component).setSize(dim.width, frame_dim.height);
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Rectangle parentNewBounds = ((Component)e.getSource()).getBounds();
        Component icon = null;
        if (this.component != null) {
            icon = ((JInternalFrame)this.component).getDesktopIcon();
            if (((JInternalFrame)this.component).isMaximum()) {
                ((JInternalFrame)this.component).setBounds(0, 0, parentNewBounds.width, parentNewBounds.height);
            }
        }
        if (icon != null) {
            Rectangle iconBounds = icon.getBounds();
            int y = iconBounds.y + parentNewBounds.height - this.parentBounds.height;
            icon.setBounds(iconBounds.x, y, iconBounds.width, iconBounds.height);
        }
        if (!this.parentBounds.equals(parentNewBounds)) {
            this.parentBounds = parentNewBounds;
        }
        if (this.component != null) {
            ((JInternalFrame)this.component).validate();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.cancelResize();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && e.getSource() == ((WInternalFrameUI)this.componentUI).getNorthPane() && SwingUtils.isLeftMouseButton(e)) {
            if (((JInternalFrame)this.component).isIconifiable() && ((JInternalFrame)this.component).isIcon()) {
                try {
                    ((JInternalFrame)this.component).setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (((JInternalFrame)this.component).isMaximizable()) {
                if (!((JInternalFrame)this.component).isMaximum()) {
                    try {
                        ((JInternalFrame)this.component).setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        ((JInternalFrame)this.component).setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void cancelResize() {
        if (this.resizing) {
            this.finishMouseReleased();
        }
    }

    protected void finishMouseReleased() {
        if (!this.discardRelease) {
            if (this.resizeDir == 0) {
                ((WInternalFrameUI)this.componentUI).getDesktopManager().endDraggingFrame(this.component);
                this.dragging = false;
            } else {
                Window windowAncestor = SwingUtilities.getWindowAncestor(this.component);
                if (windowAncestor != null) {
                    windowAncestor.removeWindowFocusListener(this);
                }
                ((WInternalFrameUI)this.componentUI).getDesktopManager().endResizingFrame(this.component);
                this.resizing = false;
                this.restoreFrameCursor();
            }
            this.absX = 0;
            this.absY = 0;
            this.relX = 0;
            this.relY = 0;
            this.startingBounds = null;
            this.resizeDir = 0;
            this.discardRelease = true;
        } else {
            this.discardRelease = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.finishMouseReleased();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Component source = (Component)e.getSource();
        this.relX = e.getX();
        this.relY = e.getY();
        Point p = SwingUtilities.convertPoint(source, e.getX(), e.getY(), null);
        this.absX = p.x;
        this.absY = p.y;
        this.startingBounds = ((JInternalFrame)this.component).getBounds();
        this.resizeDir = 0;
        this.discardRelease = false;
        try {
            ((JInternalFrame)this.component).setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        Point ep = new Point(this.relX, this.relY);
        if (source == ((WInternalFrameUI)this.componentUI).getNorthPane()) {
            Point np = ((WInternalFrameUI)this.componentUI).getNorthPane().getLocation();
            ep.x += np.x;
            ep.y += np.y;
        }
        Insets i = ((JInternalFrame)this.component).getInsets();
        if (source == ((WInternalFrameUI)this.componentUI).getNorthPane() && ep.x > i.left && ep.y > i.top && ep.x < ((JInternalFrame)this.component).getWidth() - i.right) {
            ((WInternalFrameUI)this.componentUI).getDesktopManager().beginDraggingFrame(this.component);
            this.dragging = true;
        } else if (((JInternalFrame)this.component).isResizable() && (source == this.component || source == ((WInternalFrameUI)this.componentUI).getNorthPane())) {
            if (ep.x <= i.left) {
                this.resizeDir = ep.y < this.resizeCornerSize + i.top ? 8 : (ep.y > ((JInternalFrame)this.component).getHeight() - this.resizeCornerSize - i.bottom ? 6 : 7);
            } else if (ep.x >= ((JInternalFrame)this.component).getWidth() - i.right) {
                this.resizeDir = ep.y < this.resizeCornerSize + i.top ? 2 : (ep.y > ((JInternalFrame)this.component).getHeight() - this.resizeCornerSize - i.bottom ? 4 : 3);
            } else if (ep.y <= i.top) {
                this.resizeDir = ep.x < this.resizeCornerSize + i.left ? 8 : (ep.x > ((JInternalFrame)this.component).getWidth() - this.resizeCornerSize - i.right ? 2 : 1);
            } else if (ep.y >= ((JInternalFrame)this.component).getHeight() - i.bottom) {
                this.resizeDir = ep.x < this.resizeCornerSize + i.left ? 6 : (ep.x > ((JInternalFrame)this.component).getWidth() - this.resizeCornerSize - i.right ? 4 : 5);
            } else {
                this.discardRelease = true;
            }
            if (this.resizeDir != 0) {
                ((WInternalFrameUI)this.componentUI).getDesktopManager().beginResizingFrame(this.component, this.resizeDir);
                this.resizing = true;
                Window windowAncestor = SwingUtilities.getWindowAncestor(this.component);
                if (windowAncestor != null) {
                    windowAncestor.addWindowFocusListener(this);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startingBounds != null) {
            Component source = (Component)e.getSource();
            Point p = SwingUtilities.convertPoint(source, e.getX(), e.getY(), null);
            int deltaX = this.absX - p.x;
            int deltaY = this.absY - p.y;
            Dimension min = ((JInternalFrame)this.component).getMinimumSize();
            Dimension max = ((JInternalFrame)this.component).getMaximumSize();
            if (this.dragging) {
                if (!((JInternalFrame)this.component).isMaximum() && (e.getModifiers() & 0x10) == 16) {
                    Dimension s = ((JInternalFrame)this.component).getParent().getSize();
                    int pWidth = s.width;
                    int pHeight = s.height;
                    int newX = this.startingBounds.x - deltaX;
                    int newY = this.startingBounds.y - deltaY;
                    Insets i = ((JInternalFrame)this.component).getInsets();
                    if (newX + i.left <= -this.relX) {
                        newX = -this.relX - i.left + 1;
                    }
                    if (newY + i.top <= -this.relY) {
                        newY = -this.relY - i.top + 1;
                    }
                    if (newX + this.relX + i.right >= pWidth) {
                        newX = pWidth - this.relX - i.right - 1;
                    }
                    if (newY + this.relY + i.bottom >= pHeight) {
                        newY = pHeight - this.relY - i.bottom - 1;
                    }
                    ((WInternalFrameUI)this.componentUI).getDesktopManager().dragFrame(this.component, newX, newY);
                }
            } else if (((JInternalFrame)this.component).isResizable()) {
                int newX = ((JInternalFrame)this.component).getX();
                int newY = ((JInternalFrame)this.component).getY();
                this.parentBounds = ((JInternalFrame)this.component).getParent().getBounds();
                if (this.resizeDir == 1) {
                    if (this.startingBounds.height + deltaY < min.height) {
                        deltaY = -(this.startingBounds.height - min.height);
                    } else if (this.startingBounds.height + deltaY > max.height) {
                        deltaY = max.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - deltaY < 0) {
                        deltaY = this.startingBounds.y;
                    }
                    newX = this.startingBounds.x;
                    newY = this.startingBounds.y - deltaY;
                    int newW = this.startingBounds.width;
                    int newH = this.startingBounds.height + deltaY;
                    ((WInternalFrameUI)this.componentUI).getDesktopManager().resizeFrame(this.component, newX, newY, newW, newH);
                } else if (this.resizeDir == 2) {
                    if (this.startingBounds.height + deltaY < min.height) {
                        deltaY = -(this.startingBounds.height - min.height);
                    } else if (this.startingBounds.height + deltaY > max.height) {
                        deltaY = max.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - deltaY < 0) {
                        deltaY = this.startingBounds.y;
                    }
                    if (this.startingBounds.width - deltaX < min.width) {
                        deltaX = this.startingBounds.width - min.width;
                    } else if (this.startingBounds.width - deltaX > max.width) {
                        deltaX = -(max.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - deltaX > this.parentBounds.width) {
                        deltaX = this.startingBounds.x + this.startingBounds.width - this.parentBounds.width;
                    }
                    newX = this.startingBounds.x;
                    newY = this.startingBounds.y - deltaY;
                    int newW = this.startingBounds.width - deltaX;
                    int newH = this.startingBounds.height + deltaY;
                    ((WInternalFrameUI)this.componentUI).getDesktopManager().resizeFrame(this.component, newX, newY, newW, newH);
                } else if (this.resizeDir == 3) {
                    if (this.startingBounds.width - deltaX < min.width) {
                        deltaX = this.startingBounds.width - min.width;
                    } else if (this.startingBounds.width - deltaX > max.width) {
                        deltaX = -(max.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - deltaX > this.parentBounds.width) {
                        deltaX = this.startingBounds.x + this.startingBounds.width - this.parentBounds.width;
                    }
                    int newW = this.startingBounds.width - deltaX;
                    int newH = this.startingBounds.height;
                    ((WInternalFrameUI)this.componentUI).getDesktopManager().resizeFrame(this.component, newX, newY, newW, newH);
                } else if (this.resizeDir == 4) {
                    if (this.startingBounds.width - deltaX < min.width) {
                        deltaX = this.startingBounds.width - min.width;
                    } else if (this.startingBounds.width - deltaX > max.width) {
                        deltaX = -(max.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - deltaX > this.parentBounds.width) {
                        deltaX = this.startingBounds.x + this.startingBounds.width - this.parentBounds.width;
                    }
                    if (this.startingBounds.height - deltaY < min.height) {
                        deltaY = this.startingBounds.height - min.height;
                    } else if (this.startingBounds.height - deltaY > max.height) {
                        deltaY = -(max.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - deltaY > this.parentBounds.height) {
                        deltaY = this.startingBounds.y + this.startingBounds.height - this.parentBounds.height;
                    }
                    int newW = this.startingBounds.width - deltaX;
                    int newH = this.startingBounds.height - deltaY;
                    ((WInternalFrameUI)this.componentUI).getDesktopManager().resizeFrame(this.component, newX, newY, newW, newH);
                } else if (this.resizeDir == 5) {
                    if (this.startingBounds.height - deltaY < min.height) {
                        deltaY = this.startingBounds.height - min.height;
                    } else if (this.startingBounds.height - deltaY > max.height) {
                        deltaY = -(max.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - deltaY > this.parentBounds.height) {
                        deltaY = this.startingBounds.y + this.startingBounds.height - this.parentBounds.height;
                    }
                    int newW = this.startingBounds.width;
                    int newH = this.startingBounds.height - deltaY;
                    ((WInternalFrameUI)this.componentUI).getDesktopManager().resizeFrame(this.component, newX, newY, newW, newH);
                } else if (this.resizeDir == 6) {
                    if (this.startingBounds.height - deltaY < min.height) {
                        deltaY = this.startingBounds.height - min.height;
                    } else if (this.startingBounds.height - deltaY > max.height) {
                        deltaY = -(max.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - deltaY > this.parentBounds.height) {
                        deltaY = this.startingBounds.y + this.startingBounds.height - this.parentBounds.height;
                    }
                    if (this.startingBounds.width + deltaX < min.width) {
                        deltaX = -(this.startingBounds.width - min.width);
                    } else if (this.startingBounds.width + deltaX > max.width) {
                        deltaX = max.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - deltaX < 0) {
                        deltaX = this.startingBounds.x;
                    }
                    newX = this.startingBounds.x - deltaX;
                    newY = this.startingBounds.y;
                    int newW = this.startingBounds.width + deltaX;
                    int newH = this.startingBounds.height - deltaY;
                    ((WInternalFrameUI)this.componentUI).getDesktopManager().resizeFrame(this.component, newX, newY, newW, newH);
                } else if (this.resizeDir == 7) {
                    if (this.startingBounds.width + deltaX < min.width) {
                        deltaX = -(this.startingBounds.width - min.width);
                    } else if (this.startingBounds.width + deltaX > max.width) {
                        deltaX = max.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - deltaX < 0) {
                        deltaX = this.startingBounds.x;
                    }
                    newX = this.startingBounds.x - deltaX;
                    newY = this.startingBounds.y;
                    int newW = this.startingBounds.width + deltaX;
                    int newH = this.startingBounds.height;
                    ((WInternalFrameUI)this.componentUI).getDesktopManager().resizeFrame(this.component, newX, newY, newW, newH);
                } else if (this.resizeDir == 8) {
                    if (this.startingBounds.width + deltaX < min.width) {
                        deltaX = -(this.startingBounds.width - min.width);
                    } else if (this.startingBounds.width + deltaX > max.width) {
                        deltaX = max.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - deltaX < 0) {
                        deltaX = this.startingBounds.x;
                    }
                    if (this.startingBounds.height + deltaY < min.height) {
                        deltaY = -(this.startingBounds.height - min.height);
                    } else if (this.startingBounds.height + deltaY > max.height) {
                        deltaY = max.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - deltaY < 0) {
                        deltaY = this.startingBounds.y;
                    }
                    newX = this.startingBounds.x - deltaX;
                    newY = this.startingBounds.y - deltaY;
                    int newW = this.startingBounds.width + deltaX;
                    int newH = this.startingBounds.height + deltaY;
                    ((WInternalFrameUI)this.componentUI).getDesktopManager().resizeFrame(this.component, newX, newY, newW, newH);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (((JInternalFrame)this.component).isResizable()) {
            Object source = e.getSource();
            if (source == this.component || source == ((WInternalFrameUI)this.componentUI).getNorthPane()) {
                Insets i = ((JInternalFrame)this.component).getInsets();
                Point ep = new Point(e.getX(), e.getY());
                if (source == ((WInternalFrameUI)this.componentUI).getNorthPane()) {
                    Point np = ((WInternalFrameUI)this.componentUI).getNorthPane().getLocation();
                    ep.x += np.x;
                    ep.y += np.y;
                }
                if (ep.x <= i.left) {
                    if (ep.y < this.resizeCornerSize + i.top) {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(6));
                    } else if (ep.y > ((JInternalFrame)this.component).getHeight() - this.resizeCornerSize - i.bottom) {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(4));
                    } else {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(10));
                    }
                } else if (ep.x >= ((JInternalFrame)this.component).getWidth() - i.right) {
                    if (e.getY() < this.resizeCornerSize + i.top) {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(7));
                    } else if (ep.y > ((JInternalFrame)this.component).getHeight() - this.resizeCornerSize - i.bottom) {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (ep.y <= i.top) {
                    if (ep.x < this.resizeCornerSize + i.left) {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(6));
                    } else if (ep.x > ((JInternalFrame)this.component).getWidth() - this.resizeCornerSize - i.right) {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(7));
                    } else {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(8));
                    }
                } else if (ep.y >= ((JInternalFrame)this.component).getHeight() - i.bottom) {
                    if (ep.x < this.resizeCornerSize + i.left) {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(4));
                    } else if (ep.x > ((JInternalFrame)this.component).getWidth() - this.resizeCornerSize - i.right) {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        ((JInternalFrame)this.component).setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    this.restoreFrameCursor();
                }
            } else {
                this.restoreFrameCursor();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.restoreFrameCursor();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.restoreFrameCursor();
    }

    protected void restoreFrameCursor() {
        if (!this.resizing) {
            Cursor s = ((JInternalFrame)this.component).getLastCursor();
            if (s == null) {
                s = Cursor.getPredefinedCursor(0);
            }
            ((JInternalFrame)this.component).setCursor(s);
        }
    }
}

