/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.extended.image.WebImage;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.grouping.GroupPane;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.managers.style.StyleId;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingConstants;

public class WebInternalFrameTitlePane
extends WebPanel
implements SwingConstants {
    @NotNull
    protected final JComponent parent;
    @NotNull
    protected final JInternalFrame frame;
    @NotNull
    protected WebImage titleIcon;
    @NotNull
    protected WebLabel titleLabel;
    @NotNull
    protected GroupPane buttonsPanel;
    @NotNull
    protected JButton minimizeButton;
    @NotNull
    protected JButton maximizeButton;
    @NotNull
    protected JButton closeButton;
    @Nullable
    protected Handler handler;

    public WebInternalFrameTitlePane(@NotNull JComponent parent, @NotNull JInternalFrame frame) {
        super(StyleId.internalframeTitlePanel.at(parent), new BorderLayout(), new Component[0]);
        this.parent = parent;
        this.frame = frame;
        this.titleIcon = new WebImage(StyleId.internalframeTitleIcon.at(this), frame.getFrameIcon());
        this.add((Component)this.titleIcon, (Object)"Before");
        this.titleLabel = new WebLabel(StyleId.internalframeTitleLabel.at(this), frame.getTitle());
        this.titleLabel.setFont(WebLookAndFeel.globalWindowFont);
        this.titleLabel.setFontSize(13);
        this.titleLabel.addComponentListener(new ComponentAdapter(){
            private final int initialAlignment;
            {
                this.initialAlignment = WebInternalFrameTitlePane.this.titleLabel.getHorizontalAlignment();
            }

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                boolean trimmed = WebInternalFrameTitlePane.this.titleLabel.getOriginalPreferredSize().width > WebInternalFrameTitlePane.this.titleLabel.getWidth();
                boolean ltr = WebInternalFrameTitlePane.this.titleLabel.getComponentOrientation().isLeftToRight();
                int alignment = trimmed ? (ltr ? 10 : 11) : this.initialAlignment;
                WebInternalFrameTitlePane.this.titleLabel.setHorizontalAlignment(alignment);
            }
        });
        this.add((Component)this.titleLabel, (Object)"Center");
        this.buttonsPanel = new GroupPane(StyleId.internalframeButtonsPanel.at(this), new Component[0]);
        this.buttonsPanel.setPaintSides(false, true, true, true);
        this.minimizeButton = new WebButton(StyleId.internalframeMinimizeButton.at(this.buttonsPanel));
        this.minimizeButton.setName("minimize");
        this.minimizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebInternalFrameTitlePane.this.iconify();
            }
        });
        this.maximizeButton = new WebButton(StyleId.internalframeMaximizeButton.at(this.buttonsPanel));
        this.maximizeButton.setName("maximize");
        this.maximizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebInternalFrameTitlePane.this.maximize();
            }
        });
        this.closeButton = new WebButton(StyleId.internalframeCloseButton.at(this.buttonsPanel));
        this.closeButton.setName("close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebInternalFrameTitlePane.this.close();
            }
        });
        this.updateButtonIcons();
        this.placeButtons();
        this.add((Component)this.buttonsPanel, (Object)"After");
    }

    protected void updateButtonIcons() {
        boolean icon = this.frame.isIcon();
        this.minimizeButton.setIcon(icon ? WebRootPaneUI.restoreIcon : WebRootPaneUI.minimizeIcon);
        this.minimizeButton.setRolloverIcon(icon ? WebRootPaneUI.restoreActiveIcon : WebRootPaneUI.minimizeActiveIcon);
        boolean maximum = this.frame.isMaximum();
        this.maximizeButton.setIcon(maximum && !icon ? WebRootPaneUI.restoreIcon : WebRootPaneUI.maximizeIcon);
        this.maximizeButton.setRolloverIcon(maximum && !icon ? WebRootPaneUI.restoreActiveIcon : WebRootPaneUI.maximizeActiveIcon);
        this.closeButton.setIcon(WebRootPaneUI.closeIcon);
        this.closeButton.setRolloverIcon(WebRootPaneUI.closeActiveIcon);
    }

    protected void placeButtons() {
        this.buttonsPanel.removeAll();
        if (this.frame.isIconifiable()) {
            this.buttonsPanel.add((Component)this.minimizeButton);
        }
        if (this.frame.isMaximizable()) {
            this.buttonsPanel.add((Component)this.maximizeButton);
        }
        if (this.frame.isClosable()) {
            this.buttonsPanel.add((Component)this.closeButton);
        }
        this.revalidate();
        this.repaint();
    }

    protected void removeButton(@NotNull AbstractButton button) {
        this.buttonsPanel.remove((Component)button);
        this.revalidate();
        this.repaint();
    }

    protected void install() {
        this.handler = new Handler();
        this.frame.addPropertyChangeListener(this.handler);
    }

    protected void uninstall() {
        this.frame.removePropertyChangeListener(this.handler);
        this.handler = null;
    }

    protected void iconify() {
        if (this.frame.isIconifiable()) {
            if (!this.frame.isIcon()) {
                try {
                    this.frame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                try {
                    this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected void maximize() {
        if (this.frame.isMaximizable()) {
            if (this.frame.isMaximum() && this.frame.isIcon()) {
                try {
                    this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (!this.frame.isMaximum()) {
                try {
                    this.frame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                try {
                    this.frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    protected void close() {
        if (this.frame.isClosable()) {
            this.frame.doDefaultCloseAction();
        }
    }

    protected class Handler
    implements PropertyChangeListener,
    Serializable {
        protected Handler() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (Objects.equals((Object)prop, (Object)"frameIcon")) {
                WebInternalFrameTitlePane.this.titleIcon.setImage(WebInternalFrameTitlePane.this.frame.getFrameIcon());
            } else if (Objects.equals((Object)prop, (Object)"title")) {
                WebInternalFrameTitlePane.this.titleLabel.setText(WebInternalFrameTitlePane.this.frame.getTitle());
            } else if (Objects.equals((Object)prop, (Object)"selected")) {
                WebInternalFrameTitlePane.this.repaint();
            } else if (Objects.equals((Object)prop, (Object[])new Object[]{"icon", "maximum"})) {
                WebInternalFrameTitlePane.this.updateButtonIcons();
            } else if (Objects.equals((Object)prop, (Object)"iconable")) {
                this.toggleButton(evt, WebInternalFrameTitlePane.this.minimizeButton);
            } else if (Objects.equals((Object)prop, (Object)"maximizable")) {
                this.toggleButton(evt, WebInternalFrameTitlePane.this.maximizeButton);
            } else if (Objects.equals((Object)prop, (Object)"closable")) {
                this.toggleButton(evt, WebInternalFrameTitlePane.this.closeButton);
            }
        }

        protected void toggleButton(@NotNull PropertyChangeEvent evt, @NotNull JButton button) {
            if (evt.getOldValue() != evt.getNewValue()) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    WebInternalFrameTitlePane.this.placeButtons();
                } else {
                    WebInternalFrameTitlePane.this.removeButton(button);
                }
            }
        }
    }
}

