/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.grouping;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.grouping.GroupPaneLayout;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.style.StyleId;
import com.alee.utils.swing.UnselectableButtonGroup;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.SwingConstants;

public class GroupPane
extends WebPanel
implements SwingConstants {
    public GroupPane() {
        this(StyleId.auto, new Component[0]);
    }

    public GroupPane(boolean groupButtons) {
        this(StyleId.auto, groupButtons);
    }

    public GroupPane(Component ... components) {
        this(StyleId.auto, components);
    }

    public GroupPane(int orientation, Component ... components) {
        this(StyleId.auto, orientation, components);
    }

    public GroupPane(int columns, int rows, Component ... components) {
        this(StyleId.auto, columns, rows, components);
    }

    public GroupPane(int orientation, int columns, int rows, Component ... components) {
        this(StyleId.auto, orientation, columns, rows, components);
    }

    public GroupPane(@NotNull StyleId id, boolean groupButtons) {
        this(id, groupButtons, 0, Integer.MAX_VALUE, 1, new Component[0]);
    }

    public GroupPane(@NotNull StyleId id, Component ... components) {
        this(id, 0, Integer.MAX_VALUE, 1, components);
    }

    public GroupPane(@NotNull StyleId id, int orientation, Component ... components) {
        this(id, orientation, Integer.MAX_VALUE, 1, components);
    }

    public GroupPane(@NotNull StyleId id, int columns, int rows, Component ... components) {
        this(id, 0, columns, rows, components);
    }

    public GroupPane(@NotNull StyleId id, int orientation, int columns, int rows, Component ... components) {
        this(id, true, orientation, columns, rows, components);
    }

    public GroupPane(@NotNull StyleId id, boolean groupButtons, int orientation, int columns, int rows, Component ... components) {
        super(id, new GroupPaneLayout(orientation, columns, rows), new Component[0]);
        this.setGroupButtons(groupButtons);
        this.add(components);
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.grouppane;
    }

    @Override
    public void setLayout(@NotNull LayoutManager mgr) {
        if (!(mgr instanceof GroupPaneLayout)) {
            throw new IllegalArgumentException("GroupPane supports only GroupPaneLayout");
        }
        super.setLayout(mgr);
    }

    @Override
    @NotNull
    public GroupPaneLayout getLayout() {
        return (GroupPaneLayout)super.getLayout();
    }

    public boolean isGrouping() {
        return this.getLayout().isGrouping();
    }

    public void setGroup(boolean group) {
        this.getLayout().setGroup(group);
    }

    public boolean isGroupButtons() {
        return this.getLayout().isGroupButtons();
    }

    public void setGroupButtons(boolean group) {
        this.getLayout().setGroupButtons(group);
    }

    public boolean isUnselectableGrouping() {
        return this.getLayout().isUnselectableGrouping();
    }

    public void setUnselectableGrouping(boolean unselectable) {
        this.getLayout().setUnselectableGrouping(unselectable);
    }

    @Nullable
    public UnselectableButtonGroup getButtonGroup() {
        return this.getLayout().getButtonGroup();
    }

    public int getOrientation() {
        return this.getLayout().getOrientation();
    }

    public void setOrientation(int orientation) {
        this.getLayout().setOrientation(orientation);
        this.revalidate();
    }

    public int getColumns() {
        return this.getLayout().getColumns();
    }

    public void setColumns(int columns) {
        this.getLayout().setColumns(columns);
        this.revalidate();
    }

    public int getRows() {
        return this.getLayout().getRows();
    }

    public void setRows(int rows) {
        this.getLayout().setRows(rows);
        this.revalidate();
    }

    public boolean isPaintTop() {
        return this.getLayout().isPaintTop();
    }

    public boolean isPaintLeft() {
        return this.getLayout().isPaintLeft();
    }

    public boolean isPaintBottom() {
        return this.getLayout().isPaintBottom();
    }

    public boolean isPaintRight() {
        return this.getLayout().isPaintRight();
    }

    public void setPaintSides(boolean top, boolean left, boolean bottom, boolean right) {
        this.getLayout().setPaintSides(top, left, bottom, right);
        this.revalidate();
        this.repaint();
    }
}

