/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.api.annotations.NotNull;
import com.alee.laf.list.IListItemPainter;
import com.alee.laf.list.WebListUI;
import com.alee.painter.decoration.AbstractSectionDecorationPainter;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.IDecoration;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;

public class ListItemPainter<C extends JList, U extends WebListUI, D extends IDecoration<C, D>>
extends AbstractSectionDecorationPainter<C, U, D>
implements IListItemPainter<C, U> {
    protected transient Integer index;

    @Override
    public String getSectionId() {
        return "item";
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        this.addItemStates(states);
        return states;
    }

    protected void addItemStates(List<String> states) {
        ListModel model;
        if (this.index != null && (model = ((JList)this.component).getModel()) != null && 0 <= this.index && this.index < model.getSize()) {
            Object item = model.getElementAt(this.index);
            this.addItemStates(states, item);
        }
    }

    protected void addItemStates(List<String> states, Object item) {
        this.addNumerationStates(states, item);
        states.add(((JList)this.component).isSelectedIndex(this.index) ? "selected" : "unselected");
        if (this.index.intValue() == ((WebListUI)this.ui).getHoverIndex()) {
            states.add("hover");
        } else {
            states.remove("hover");
        }
        states.addAll(DecorationUtils.getExtraStates(item));
    }

    protected void addNumerationStates(List<String> states, Object item) {
        states.add(this.index % 2 == 0 ? "odd" : "even");
    }

    @Override
    protected boolean isFocused() {
        return false;
    }

    @Override
    public void prepareToPaint(int index) {
        this.index = index;
        this.updateDecorationState();
    }
}

