/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.ui.ChildStyleIdBridge;
import com.alee.api.ui.ForegroundBridge;
import com.alee.api.ui.IconBridge;
import com.alee.api.ui.StyleIdBridge;
import com.alee.api.ui.TextBridge;
import com.alee.extended.label.WebStyledLabel;
import com.alee.laf.list.ListCellParameters;
import com.alee.laf.list.WListUI;
import com.alee.managers.style.ChildStyleId;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Stateful;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ListUI;

public class WebListCellRenderer<V, C extends JList, P extends ListCellParameters<V, C>>
extends WebStyledLabel
implements ListCellRenderer,
Stateful {
    protected final List<String> states;

    public WebListCellRenderer() {
        this.setName("List.cellRenderer");
        this.states = new ArrayList<String>(3);
    }

    @Override
    @Nullable
    public List<String> getStates() {
        return this.states;
    }

    protected void updateStates(P parameters) {
        ListUI ui;
        this.states.clear();
        this.states.add(((ListCellParameters)parameters).isSelected() ? "selected" : "unselected");
        if (((ListCellParameters)parameters).isFocused()) {
            this.states.add("focused");
        }
        if ((ui = ((JList)((ListCellParameters)parameters).list()).getUI()) instanceof WListUI && ((WListUI)ui).getHoverIndex() == ((ListCellParameters)parameters).index()) {
            this.states.add("hover");
        }
        this.states.addAll(DecorationUtils.getExtraStates(((ListCellParameters)parameters).value()));
    }

    protected void updateStyleId(P parameters) {
        StyleIdBridge styleIdBridge;
        StyleId styleId;
        StyleId id = null;
        if (((ListCellParameters)parameters).value() instanceof ChildStyleIdBridge) {
            ChildStyleIdBridge childStyleIdBridge = (ChildStyleIdBridge)((ListCellParameters)parameters).value();
            ChildStyleId childStyleId = childStyleIdBridge.getChildStyleId(parameters);
            if (childStyleId != null) {
                id = childStyleId.at((JComponent)((ListCellParameters)parameters).list());
            }
        } else if (((ListCellParameters)parameters).value() instanceof StyleIdBridge && (styleId = (styleIdBridge = (StyleIdBridge)((ListCellParameters)parameters).value()).getStyleId(parameters)) != null) {
            id = styleId;
        }
        if (id == null) {
            id = this.getIcon() != null ? StyleId.listIconCellRenderer.at((JComponent)((ListCellParameters)parameters).list()) : StyleId.listTextCellRenderer.at((JComponent)((ListCellParameters)parameters).list());
        }
        this.setStyleId(id);
    }

    protected void updateView(P parameters) {
        this.setEnabled(this.enabledForValue(parameters));
        this.setComponentOrientation(this.orientationForValue(parameters));
        this.setFont(this.fontForValue(parameters));
        this.setForeground(this.foregroundForValue(parameters));
        this.setHorizontalAlignment(this.horizontalAlignmentForValue(parameters));
        this.setIcon(this.iconForValue(parameters));
        this.setText(this.textForValue(parameters));
    }

    protected boolean enabledForValue(P parameters) {
        return ((Component)((ListCellParameters)parameters).list()).isEnabled();
    }

    protected ComponentOrientation orientationForValue(P parameters) {
        return ((Component)((ListCellParameters)parameters).list()).getComponentOrientation();
    }

    protected Font fontForValue(P parameters) {
        return ((Component)((ListCellParameters)parameters).list()).getFont();
    }

    protected Color foregroundForValue(P parameters) {
        ForegroundBridge foregroundBridge;
        Color fg;
        Color foreground = ((ListCellParameters)parameters).value() instanceof ForegroundBridge ? ((fg = (foregroundBridge = (ForegroundBridge)((ListCellParameters)parameters).value()).getForeground(parameters)) != null ? fg : (((ListCellParameters)parameters).isSelected() ? ((JList)((ListCellParameters)parameters).list()).getSelectionForeground() : ((Component)((ListCellParameters)parameters).list()).getForeground())) : (((ListCellParameters)parameters).isSelected() ? ((JList)((ListCellParameters)parameters).list()).getSelectionForeground() : ((Component)((ListCellParameters)parameters).list()).getForeground());
        return foreground;
    }

    protected int horizontalAlignmentForValue(P parameters) {
        return 10;
    }

    protected Icon iconForValue(P parameters) {
        Icon icon;
        if (((ListCellParameters)parameters).value() instanceof IconBridge) {
            IconBridge iconBridge = (IconBridge)((ListCellParameters)parameters).value();
            icon = iconBridge.getIcon(parameters);
        } else {
            icon = ((ListCellParameters)parameters).value() instanceof Icon ? (Icon)((ListCellParameters)parameters).value() : null;
        }
        return icon;
    }

    protected String textForValue(P parameters) {
        String text;
        if (((ListCellParameters)parameters).value() instanceof TextBridge) {
            TextBridge textBridge = (TextBridge)((ListCellParameters)parameters).value();
            text = textBridge.getText(parameters);
        } else {
            text = ((ListCellParameters)parameters).value() != null && !(((ListCellParameters)parameters).value() instanceof Icon) ? ((ListCellParameters)parameters).value().toString() : "";
        }
        return text;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        P parameters = this.getRenderingParameters(list, value, index, isSelected, hasFocus);
        this.updateStates(parameters);
        this.updateStyleId(parameters);
        this.updateView(parameters);
        DecorationUtils.fireStatesChanged(this);
        return this;
    }

    protected P getRenderingParameters(C list, V value, int index, boolean isSelected, boolean hasFocus) {
        return (P)new ListCellParameters<V, C>(list, value, index, isSelected, hasFocus);
    }

    @Override
    public final void validate() {
    }

    @Override
    public final void invalidate() {
    }

    @Override
    public final void revalidate() {
    }

    @Override
    public final void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public final void repaint(Rectangle r) {
    }

    @Override
    public final void repaint() {
    }

    protected void checkPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (Objects.equals((Object)propertyName, (Object[])new Object[]{"styleId", "parent", "decorationStates", "styleRanges", "text", "border", "model"})) {
            this.allowPropertyChange(propertyName, oldValue, newValue);
        } else if (Objects.equals((Object)propertyName, (Object[])new Object[]{"font", "foreground"}) && oldValue != newValue && this.getClientProperty("html") != null) {
            this.allowPropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void allowPropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, char oldValue, char newValue) {
        this.checkPropertyChange(propertyName, Character.valueOf(oldValue), Character.valueOf(newValue));
    }

    @Override
    public final void firePropertyChange(String propertyName, short oldValue, short newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.checkPropertyChange(propertyName, Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    @Override
    public final void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.checkPropertyChange(propertyName, oldValue, newValue);
    }

    public static final class UIResource<V, C extends JList, P extends ListCellParameters<V, C>>
    extends WebListCellRenderer<V, C, P>
    implements javax.swing.plaf.UIResource {
    }
}

