/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Supplier;
import com.alee.laf.menu.PopupStyle;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.PainterShapeProvider;
import com.alee.painter.AbstractPainter;
import com.alee.painter.decoration.shadow.WebShadow;
import com.alee.painter.decoration.shape.StretchInfo;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.ShapeUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;

public abstract class AbstractPopupPainter<C extends JComponent, U extends ComponentUI>
extends AbstractPainter<C, U>
implements PainterShapeProvider<C>,
SwingConstants {
    protected static final String SIMPLE_FILL_SHAPE = "simple-fill";
    protected static final String SIMPLE_BORDER_SHAPE = "simple-border";
    protected static final String DROPDOWN_FILL_SHAPE = "dropdown-fill";
    protected static final String DROPDOWN_BORDER_SHAPE = "dropdown-border";
    protected PopupStyle popupStyle = PopupStyle.dropdown;
    protected Color background = Color.WHITE;
    protected Color borderColor = new Color(128, 128, 128, 128);
    protected int round = 4;
    protected int shadeWidth = 12;
    protected float shadeOpacity = 0.75f;
    protected int cornerWidth = 6;
    protected float opacity = 0.95f;
    protected transient boolean shaped = true;
    protected transient int cornerSide = 1;
    protected transient int relativeCorner = 0;
    protected transient int cornerAlignment = -1;
    protected transient NinePatchIcon shade = null;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.shaped = ProprietaryUtils.isWindowTransparencyAllowed() || ProprietaryUtils.isWindowShapeAllowed();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.shaped = false;
        super.uninstallPropertiesAndListeners();
    }

    public PopupStyle getPopupStyle() {
        return this.popupStyle;
    }

    public void setPopupStyle(PopupStyle style) {
        this.popupStyle = style;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int width) {
        this.shadeWidth = width;
    }

    public float getShadeOpacity() {
        return this.shadeOpacity;
    }

    public void setShadeOpacity(float opacity) {
        this.shadeOpacity = opacity;
    }

    public int getCornerWidth() {
        return this.cornerWidth;
    }

    public void setCornerWidth(int width) {
        this.cornerWidth = width;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public int getCornerSide() {
        return this.cornerSide;
    }

    public void setCornerSide(int cornerSide) {
        this.cornerSide = cornerSide;
    }

    public int getRelativeCorner() {
        return this.relativeCorner;
    }

    public void setRelativeCorner(int relativeCorner) {
        this.relativeCorner = relativeCorner;
    }

    public int getCornerAlignment() {
        return this.cornerAlignment;
    }

    public void setCornerAlignment(int cornerAlignment) {
        this.cornerAlignment = cornerAlignment;
    }

    @Override
    @NotNull
    public Shape provideShape(@NotNull C component, @NotNull Rectangle bounds) {
        return this.getBorderShape(component, bounds.getSize(), false);
    }

    @Override
    @Nullable
    public Boolean isOpaque() {
        return !this.shaped;
    }

    @Override
    @NotNull
    protected Insets getBorder() {
        Insets border;
        if (this.shaped) {
            int sideWidth = this.getSideWidth();
            border = new Insets(sideWidth + 1, sideWidth + 1, sideWidth + 1, sideWidth + 1);
        } else {
            border = new Insets(1, 1, 1, 1);
        }
        return border;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull C popup, @NotNull U ui, @NotNull Bounds bounds) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        if (this.shaped) {
            this.paintTransparentPopup(g2d, popup);
        } else {
            this.paintSimplePopup(g2d, popup);
        }
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected void paintTransparentPopup(Graphics2D g2d, C popup) {
        Dimension popupSize = ((Component)popup).getSize();
        this.paintShade(g2d, popup, popupSize);
        this.paintBackground(g2d, popup, popupSize);
        this.paintBorder(g2d, popup, popupSize);
    }

    protected void paintSimplePopup(Graphics2D g2d, C popup) {
        g2d.setPaint(this.getBackgroundColor(popup));
        g2d.fillRoundRect(1, 1, ((JComponent)popup).getWidth() - 2, ((JComponent)popup).getHeight() - 2, this.round * 2, this.round * 2);
        g2d.setPaint(this.borderColor);
        g2d.drawRoundRect(0, 0, ((JComponent)popup).getWidth() - 1, ((JComponent)popup).getHeight() - 1, this.round * 2, this.round * 2);
    }

    protected void paintShade(Graphics2D g2d, C popup, Dimension popupSize) {
        if (this.shadeWidth > 0) {
            float opacity = this.getCurrentShadeOpacity();
            Rectangle b = BoundsType.component.bounds((Component)popup);
            Pair hor = new Pair((Object)(b.x + this.shadeWidth * 2), (Object)(b.x + b.width - this.shadeWidth * 2));
            Pair ver = new Pair((Object)(b.y + this.shadeWidth * 2), (Object)(b.y + b.height - this.shadeWidth * 2));
            StretchInfo info = new StretchInfo((Pair<Integer, Integer>)hor, (Pair<Integer, Integer>)ver);
            Shape shape = this.getBorderShape(popup, popupSize, true);
            this.shade = WebShadow.getShadowIcon(info, b, this.shadeWidth, opacity, Color.BLACK, shape, new Object[]{this.popupStyle, this.cornerSide, this.relativeCorner});
            this.shade.paintIcon(g2d, this.getShadeBounds(popupSize));
        } else {
            this.shade = null;
        }
    }

    protected float getCurrentShadeOpacity() {
        return this.shadeOpacity;
    }

    protected void paintBackground(Graphics2D g2d, C popup, Dimension popupSize) {
        Color backgroundColor = this.getBackgroundColor(popup);
        if (backgroundColor != null) {
            g2d.setPaint(backgroundColor);
            g2d.fill(this.getBorderShape(popup, popupSize, true));
        }
    }

    protected void paintBorder(Graphics2D g2d, C popup, Dimension popupSize) {
        if (this.borderColor != null) {
            g2d.setPaint(this.borderColor);
            g2d.draw(this.getBorderShape(popup, popupSize, false));
        }
    }

    protected Color getBackgroundColor(C popup) {
        Color bg = this.getComponentBackground(popup);
        return !this.shaped || this.opacity >= 1.0f ? bg : ColorUtils.transparent((Color)bg, (int)Math.max(0, Math.min((int)(this.opacity * 255.0f), 255)));
    }

    protected Color getComponentBackground(C popup) {
        return this.background;
    }

    protected Rectangle getShadeBounds(Dimension popupSize) {
        switch (this.popupStyle) {
            case simple: {
                return new Rectangle(0, 0, popupSize.width, popupSize.height);
            }
            case dropdown: {
                int spacing = Math.max(0, this.cornerWidth - this.shadeWidth);
                return new Rectangle(spacing, spacing, popupSize.width - spacing * 2, popupSize.height - spacing * 2);
            }
        }
        return null;
    }

    protected Shape getBorderShape(final C popup, final Dimension popupSize, final boolean fill) {
        switch (this.popupStyle) {
            case simple: {
                return ShapeUtils.getShape(popup, fill ? SIMPLE_FILL_SHAPE : SIMPLE_BORDER_SHAPE, new Supplier<Shape>(){

                    public Shape get() {
                        return AbstractPopupPainter.this.createSimpleShape(popup, popupSize, fill);
                    }
                }, this.getCachedShapeSettings(popup, popupSize));
            }
            case dropdown: {
                return ShapeUtils.getShape(popup, fill ? DROPDOWN_FILL_SHAPE : DROPDOWN_BORDER_SHAPE, new Supplier<Shape>(){

                    public Shape get() {
                        return AbstractPopupPainter.this.createDropdownShape(popup, popupSize, fill);
                    }
                }, this.getCachedShapeSettings(popup, popupSize));
            }
        }
        return null;
    }

    protected Object[] getCachedShapeSettings(C popup, Dimension popupSize) {
        return new Object[]{this.round, this.shadeWidth, this.cornerWidth, this.cornerSide, this.relativeCorner, this.cornerAlignment, popupSize, this.ltr};
    }

    protected GeneralPath createSimpleShape(C popup, Dimension popupSize, boolean fill) {
        int shear = fill ? 1 : 0;
        GeneralPath shape = new GeneralPath(0);
        int top = this.shadeWidth + shear;
        int left = this.shadeWidth + shear;
        int bottom = popupSize.height - 1 - this.shadeWidth;
        int right = popupSize.width - 1 - this.shadeWidth;
        shape.moveTo(left, top + this.round);
        shape.quadTo(left, top, left + this.round, top);
        shape.lineTo(right - this.round, top);
        shape.quadTo(right, top, right, top + this.round);
        shape.lineTo(right, bottom - this.round);
        shape.quadTo(right, bottom, right - this.round, bottom);
        shape.lineTo(left + this.round, bottom);
        shape.quadTo(left, bottom, left, bottom - this.round);
        shape.closePath();
        return shape;
    }

    protected GeneralPath createDropdownShape(C popup, Dimension popupSize, boolean fill) {
        int length;
        boolean topCorner = this.cornerSide == 1;
        boolean bottomCorner = this.cornerSide == 3;
        boolean leftCorner = this.cornerSide == 2 || this.cornerSide == 10;
        boolean rightCorner = this.cornerSide == 4 || this.cornerSide == 11;
        int shear = fill ? 1 : 0;
        int sideWidth = this.getSideWidth();
        int cornerShear = sideWidth + shear + this.round + this.cornerWidth * 2;
        int n = length = topCorner || bottomCorner ? popupSize.width : popupSize.height;
        int spacing = this.cornerAlignment == 0 || length < sideWidth * 2 + this.round * 2 + this.cornerWidth * 4 ? length / 2 - sideWidth - this.round - this.cornerWidth * 2 : (this.cornerAlignment == 2 || this.cornerAlignment == 10 && this.ltr || this.cornerAlignment == 11 && !this.ltr ? 0 : (this.cornerAlignment == 4 || this.cornerAlignment == 11 && this.ltr || this.cornerAlignment == 10 && !this.ltr ? length - cornerShear * 2 : (this.relativeCorner < sideWidth + this.round + this.cornerWidth * 2 ? 0 : Math.min(this.relativeCorner - cornerShear, length - cornerShear * 2))));
        int top = sideWidth + shear;
        int right = popupSize.width - 1 - sideWidth;
        int bottom = popupSize.height - 1 - sideWidth;
        int left = sideWidth + shear;
        GeneralPath shape = new GeneralPath(0);
        shape.moveTo(left, top + this.round);
        shape.quadTo(left, top, left + this.round, top);
        if (topCorner) {
            shape.lineTo(left + this.round + spacing + this.cornerWidth, top);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2, top - this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2 + 1, top - this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 3 + 1, top);
        }
        shape.lineTo(right - this.round, top);
        shape.quadTo(right, top, right, top + this.round);
        if (rightCorner) {
            shape.lineTo(right, top + this.round + spacing + this.cornerWidth);
            shape.lineTo(right + this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2);
            shape.lineTo(right + this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2 + 1);
            shape.lineTo(right, top + this.round + spacing + this.cornerWidth * 3 + 1);
        }
        shape.lineTo(right, bottom - this.round);
        shape.quadTo(right, bottom, right - this.round, bottom);
        if (bottomCorner) {
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 3 + 1, bottom);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2 + 1, bottom + this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2, bottom + this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth, bottom);
        }
        shape.lineTo(left + this.round, bottom);
        shape.quadTo(left, bottom, left, bottom - this.round);
        if (leftCorner) {
            shape.lineTo(left, top + this.round + spacing + this.cornerWidth * 3 + 1);
            shape.lineTo(left - this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2 + 1);
            shape.lineTo(left - this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2);
            shape.lineTo(left, top + this.round + spacing + this.cornerWidth);
        }
        shape.closePath();
        return shape;
    }

    protected Shape getDropdownCornerShape(final C popupMenu, final Dimension menuSize, final boolean fill) {
        return ShapeUtils.getShape(popupMenu, fill ? "dropdown-corner-fill" : "dropdown-corner-border", new Supplier<Shape>(){

            public Shape get() {
                return AbstractPopupPainter.this.createDropdownCornerShape(popupMenu, menuSize, fill);
            }
        }, this.getCachedShapeSettings(popupMenu, menuSize));
    }

    protected GeneralPath createDropdownCornerShape(C popupMenu, Dimension menuSize, boolean fill) {
        int length;
        boolean topCorner = this.cornerSide == 1;
        boolean bottomCorner = this.cornerSide == 3;
        boolean leftCorner = this.cornerSide == 2 || this.cornerSide == 10;
        boolean rightCorner = this.cornerSide == 4 || this.cornerSide == 11;
        int shear = fill ? 1 : 0;
        int sideWidth = this.getSideWidth();
        int cornerShear = sideWidth + shear + this.round + this.cornerWidth * 2;
        int n = length = topCorner || bottomCorner ? menuSize.width : menuSize.height;
        int spacing = this.cornerAlignment == 0 || length < sideWidth * 2 + this.round * 2 + this.cornerWidth * 4 ? length / 2 - sideWidth - this.round - this.cornerWidth * 2 : (this.cornerAlignment == 2 || this.cornerAlignment == 10 && this.ltr || this.cornerAlignment == 11 && !this.ltr ? 0 : (this.cornerAlignment == 4 || this.cornerAlignment == 11 && this.ltr || this.cornerAlignment == 10 && !this.ltr ? length - cornerShear * 2 : (this.relativeCorner < sideWidth + this.round + this.cornerWidth * 2 ? 0 : Math.min(this.relativeCorner - cornerShear, length - cornerShear * 2))));
        int top = sideWidth + shear;
        int right = menuSize.width - 1 - sideWidth;
        int bottom = menuSize.height - 1 - sideWidth;
        int left = sideWidth + shear;
        GeneralPath shape = new GeneralPath(0);
        if (topCorner) {
            shape.moveTo(left + this.round + spacing + this.cornerWidth, top);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2, top - this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2 + 1, top - this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 3 + 1, top);
            shape.closePath();
        }
        if (rightCorner) {
            shape.lineTo(right, top + this.round + spacing + this.cornerWidth);
            shape.lineTo(right + this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2);
            shape.lineTo(right + this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2 + 1);
            shape.lineTo(right, top + this.round + spacing + this.cornerWidth * 3 + 1);
        }
        if (bottomCorner) {
            shape.moveTo(left + this.round + spacing + this.cornerWidth * 3 + 1, bottom);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2 + 1, bottom + this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2, bottom + this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth, bottom);
            shape.closePath();
        }
        if (leftCorner) {
            shape.lineTo(left, top + this.round + spacing + this.cornerWidth * 3 + 1);
            shape.lineTo(left - this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2 + 1);
            shape.lineTo(left - this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2);
            shape.lineTo(left, top + this.round + spacing + this.cornerWidth);
        }
        return shape;
    }

    protected int getSideWidth() {
        return this.popupStyle == PopupStyle.dropdown ? Math.max(this.cornerWidth, this.shadeWidth) : this.shadeWidth;
    }
}

