/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.button.AbstractButtonPainter;
import com.alee.laf.checkbox.ButtonStatePainter;
import com.alee.laf.checkbox.IButtonStatePainter;
import com.alee.laf.menu.IAbstractMenuItemPainter;
import com.alee.laf.menu.MenuItemChangeListener;
import com.alee.painter.DefaultPainter;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.GraphicsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;

public abstract class AbstractStateMenuItemPainter<C extends JMenuItem, U extends MenuItemUI, D extends IDecoration<C, D>>
extends AbstractButtonPainter<C, U, D>
implements IAbstractMenuItemPainter<C, U> {
    public static final String STATE_ICON_PROPERTY = "menuItemStateIcon";
    protected transient MenuItemChangeListener menuItemChangeListener;
    @DefaultPainter(value=ButtonStatePainter.class)
    @Nullable
    protected IButtonStatePainter stateIconPainter;

    @Override
    @Nullable
    protected List<SectionPainter<C, U>> getSectionPainters() {
        return this.asList(this.stateIconPainter);
    }

    @Override
    public void install(@NotNull C c, @NotNull U ui) {
        super.install(c, ui);
        this.installStateIcon();
    }

    @Override
    public void uninstall(@NotNull C c, @NotNull U ui) {
        this.uninstallStateIcon();
        super.uninstall(c, ui);
    }

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installMenuItemChangeListener();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallMenuItemChangeListener();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        if (((JMenuItem)this.component).isSelected()) {
            states.add("checked");
        }
        return states;
    }

    @Override
    protected boolean isSelected() {
        return ((JMenuItem)this.component).isEnabled() && ((JMenuItem)this.component).getModel().isArmed();
    }

    protected void installStateIcon() {
        if (this.stateIconPainter != null) {
            Dimension size = this.stateIconPainter.getPreferredSize();
            if (size.width > 0 && size.height > 0) {
                ((JMenuItem)this.component).putClientProperty(STATE_ICON_PROPERTY, this.createIcon());
            }
        }
    }

    protected void uninstallStateIcon() {
        if (this.stateIconPainter != null) {
            Dimension size = this.stateIconPainter.getPreferredSize();
            if (size.width > 0 && size.height > 0) {
                ((JMenuItem)this.component).putClientProperty(STATE_ICON_PROPERTY, null);
            }
        }
    }

    protected void installMenuItemChangeListener() {
        this.menuItemChangeListener = MenuItemChangeListener.install((JMenuItem)this.component);
    }

    protected void uninstallMenuItemChangeListener() {
        this.menuItemChangeListener = MenuItemChangeListener.uninstall((JMenuItem)this.component, this.menuItemChangeListener);
    }

    @NotNull
    protected Icon createIcon() {
        return new StateIcon();
    }

    protected class StateIcon
    implements Icon,
    UIResource {
        protected StateIcon() {
        }

        @Override
        public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
            if (AbstractStateMenuItemPainter.this.stateIconPainter != null) {
                Graphics2D g2d = (Graphics2D)g;
                Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
                AbstractStateMenuItemPainter.this.paintSection(AbstractStateMenuItemPainter.this.stateIconPainter, g2d, new Rectangle(new Point(x, y), this.getSize()));
                GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
            }
        }

        @NotNull
        protected Dimension getSize() {
            return AbstractStateMenuItemPainter.this.stateIconPainter != null ? AbstractStateMenuItemPainter.this.stateIconPainter.getPreferredSize() : new Dimension(16, 16);
        }

        @Override
        public int getIconWidth() {
            return this.getSize().width;
        }

        @Override
        public int getIconHeight() {
            return this.getSize().height;
        }
    }
}

