/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.menu.PopupMenuPainter;
import com.alee.laf.menu.PopupStyle;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.SwingUtils;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MenuItemChangeListener
implements ChangeListener,
PropertyChangeListener {
    @NotNull
    protected JMenuItem menuItem;

    public MenuItemChangeListener(@NotNull JMenuItem menuItem) {
        this.menuItem = menuItem;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        ((ButtonModel)evt.getOldValue()).removeChangeListener(this);
        ((ButtonModel)evt.getNewValue()).addChangeListener(this);
    }

    @Override
    public void stateChanged(@NotNull ChangeEvent e) {
        PopupMenuPainter webPainter;
        Painter painter;
        JPopupMenu popupMenu = SwingUtils.getFirstParent(this.menuItem, JPopupMenu.class);
        if (popupMenu != null && (painter = PainterSupport.getPainter(popupMenu)) instanceof PopupMenuPainter && (webPainter = (PopupMenuPainter)painter).getPopupStyle() == PopupStyle.dropdown) {
            int zOrder = popupMenu.getComponentZOrder(this.menuItem);
            if (webPainter.getCornerSide() == 1 && zOrder == 0) {
                popupMenu.repaint(0, 0, popupMenu.getWidth(), this.menuItem.getBounds().y);
            } else if (webPainter.getCornerSide() == 5 && zOrder == popupMenu.getComponentCount() - 1) {
                Rectangle itemBounds = this.menuItem.getBounds();
                int y = itemBounds.y + itemBounds.height;
                popupMenu.repaint(0, y, popupMenu.getWidth(), popupMenu.getHeight() - y);
            }
        }
    }

    @NotNull
    public static MenuItemChangeListener install(@NotNull JMenuItem menuItem) {
        MenuItemChangeListener listener = new MenuItemChangeListener(menuItem);
        menuItem.getModel().addChangeListener(listener);
        menuItem.addPropertyChangeListener("model", listener);
        return listener;
    }

    @Nullable
    public static MenuItemChangeListener uninstall(@NotNull JMenuItem menuItem, @NotNull MenuItemChangeListener listener) {
        menuItem.removePropertyChangeListener("model", listener);
        menuItem.getModel().removeChangeListener(listener);
        return null;
    }
}

