/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.progressbar;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.progressbar.IProgressBarPainter;
import com.alee.laf.progressbar.IProgressPainter;
import com.alee.laf.progressbar.IProgressTextPainter;
import com.alee.laf.progressbar.ProgressPainter;
import com.alee.laf.progressbar.ProgressTextPainter;
import com.alee.laf.progressbar.WProgressBarUI;
import com.alee.managers.style.BoundsType;
import com.alee.painter.DefaultPainter;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressBarPainter<C extends JProgressBar, U extends WProgressBarUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements IProgressBarPainter<C, U>,
ChangeListener {
    protected Dimension minimumContentSize;
    @DefaultPainter(value=ProgressPainter.class)
    protected IProgressPainter progressPainter;
    @DefaultPainter(value=ProgressTextPainter.class)
    protected IProgressTextPainter progressTextPainter;
    protected transient int value;

    @Override
    @Nullable
    protected List<SectionPainter<C, U>> getSectionPainters() {
        return this.asList(this.progressPainter, this.progressTextPainter);
    }

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installProgressBarValueListeners();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallProgressBarValueListeners();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object[])new Object[]{"indeterminate", "orientation"})) {
            this.updateDecorationState();
        }
    }

    protected void installProgressBarValueListeners() {
        this.value = ((JProgressBar)this.component).getValue();
        ((JProgressBar)this.component).addChangeListener(this);
    }

    protected void uninstallProgressBarValueListeners() {
        ((JProgressBar)this.component).removeChangeListener(this);
        this.value = -1;
    }

    @Override
    public void stateChanged(@NotNull ChangeEvent e) {
        int newValue;
        if (this.component != null && (newValue = ((JProgressBar)this.component).getValue()) != this.value) {
            if (!((JProgressBar)this.component).isIndeterminate()) {
                int min = ((JProgressBar)this.component).getMinimum();
                int max = ((JProgressBar)this.component).getMaximum();
                if (this.value == min || this.value == max || newValue == min || newValue == max) {
                    this.updateDecorationState();
                }
            }
            this.value = newValue;
        }
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        states.add(this.isHorizontal() ? "horizontal" : "vertical");
        states.add(((JProgressBar)this.component).isIndeterminate() ? "indeterminate" : "progress");
        if (!((JProgressBar)this.component).isIndeterminate()) {
            boolean max;
            boolean min = ((JProgressBar)this.component).getValue() == ((JProgressBar)this.component).getMinimum();
            boolean bl = max = ((JProgressBar)this.component).getValue() == ((JProgressBar)this.component).getMaximum();
            if (min) {
                states.add("minimum");
            }
            if (max) {
                states.add("maximum");
            }
            if (!min && !max) {
                states.add("intermediate");
            }
        }
        return states;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        this.paintProgress(g2d, BoundsType.border.bounds((Component)c));
        this.paintText(g2d, BoundsType.padding.bounds((Component)c));
    }

    protected void paintProgress(@NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        if (this.progressPainter != null) {
            this.paintSection(this.progressPainter, g2d, bounds);
        }
    }

    protected void paintText(@NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        if (this.progressTextPainter != null && ((JProgressBar)this.component).isStringPainted()) {
            this.paintSection(this.progressTextPainter, g2d, bounds);
        }
    }

    @NotNull
    protected Dimension getMinimumContentSize() {
        boolean hor;
        Dimension ms = this.component != null && this.minimumContentSize != null ? new Dimension((hor = this.isHorizontal()) ? this.minimumContentSize.width : this.minimumContentSize.height, hor ? this.minimumContentSize.height : this.minimumContentSize.width) : new Dimension();
        return ms;
    }

    protected boolean isHorizontal() {
        return ((JProgressBar)this.component).getOrientation() == 0;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension min = this.getMinimumContentSize();
        int w = min.width;
        int h = min.height;
        if (((JProgressBar)this.component).isStringPainted()) {
            boolean hor = this.isHorizontal();
            FontMetrics fontSizer = ((JProgressBar)this.component).getFontMetrics(((JProgressBar)this.component).getFont());
            String progString = ((JProgressBar)this.component).getString();
            int stringWidth = SwingUtils.stringWidth(fontSizer, progString);
            int stringHeight = fontSizer.getHeight() + fontSizer.getDescent();
            w = Math.max(w, hor ? stringWidth : stringHeight);
            h = Math.max(h, hor ? stringHeight : stringWidth);
        }
        Insets border = ((JProgressBar)this.component).getInsets();
        return new Dimension(border.left + w + border.right, border.top + h + border.bottom);
    }
}

