/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.Mergeable;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.xml.DimensionConverter;
import com.alee.utils.xml.PointConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.List;
import javax.swing.JRootPane;

@XStreamAlias(value="WindowState")
public class WindowState
implements Mergeable,
Cloneable,
Serializable {
    @XStreamAsAttribute
    @XStreamConverter(value=PointConverter.class)
    @Nullable
    protected Point location;
    @XStreamAsAttribute
    @XStreamConverter(value=DimensionConverter.class)
    @Nullable
    protected Dimension size;
    @XStreamAsAttribute
    @Nullable
    protected Integer state;

    public WindowState() {
        this(null, null, null);
    }

    public WindowState(@Nullable Point location) {
        this(location, null, null);
    }

    public WindowState(@Nullable Dimension size) {
        this(null, size, null);
    }

    public WindowState(@Nullable Point location, @Nullable Dimension size) {
        this(location, size, null);
    }

    public WindowState(@Nullable Integer state) {
        this(null, null, state);
    }

    public WindowState(@Nullable Point location, @Nullable Integer state) {
        this(location, null, state);
    }

    public WindowState(@Nullable Dimension size, @Nullable Integer state) {
        this(null, size, state);
    }

    public WindowState(@Nullable Point location, @Nullable Dimension size, @Nullable Integer state) {
        this.location = location;
        this.size = size;
        this.state = state;
    }

    public WindowState(@NotNull Window window) {
        this(CoreSwingUtils.getNonNullRootPane((Component)window));
    }

    public WindowState(@NotNull JRootPane rootPane) {
        this.retrieve(rootPane);
    }

    @Nullable
    public Point location() {
        return this.location;
    }

    @Nullable
    public Dimension size() {
        return this.size;
    }

    @Nullable
    public Integer state() {
        return this.state;
    }

    @NotNull
    public WindowState retrieve(@NotNull JRootPane rootPane) {
        Window window = CoreSwingUtils.getNonNullWindowAncestor((Component)rootPane);
        if (window instanceof Frame) {
            this.state = ((Frame)window).getExtendedState();
        }
        if (this.state == null || (this.state & 6) == 0 || this.size == null || this.location == null) {
            Rectangle bounds = window.getBounds();
            this.location = bounds.getLocation();
            this.size = bounds.getSize();
        }
        return this;
    }

    public void apply(@NotNull JRootPane rootPane) {
        Window window = CoreSwingUtils.getNonNullWindowAncestor((Component)rootPane);
        Rectangle bounds = window.getBounds();
        if (this.size != null) {
            if (Objects.notEquals((Object)this.size, (Object)bounds.getSize())) {
                if (this.size.width > 0 && this.size.height > 0) {
                    window.setSize(this.size);
                } else if (this.size.width > 0 || this.size.height > 0) {
                    Dimension ps = window.getPreferredSize();
                    this.size.width = this.size.width > 0 ? this.size.width : ps.width;
                    this.size.height = this.size.height > 0 ? this.size.height : ps.height;
                    window.setSize(this.size);
                } else {
                    this.size = window.getPreferredSize();
                    window.setSize(this.size);
                }
            }
        } else {
            window.pack();
            this.size = window.getPreferredSize();
        }
        if (this.location != null) {
            if (Objects.notEquals((Object)this.location, (Object)bounds.getLocation())) {
                if (this.location.x > 0 && this.location.y > 0) {
                    Rectangle b = new Rectangle(this.location, window.getSize());
                    List devicesBounds = SystemUtils.getDevicesBounds((boolean)false);
                    boolean intersects = false;
                    for (Rectangle deviceBounds : devicesBounds) {
                        if (!b.intersects(deviceBounds)) continue;
                        intersects = true;
                        break;
                    }
                    if (intersects) {
                        window.setLocation(this.location);
                    } else {
                        window.setLocationRelativeTo(window.getOwner());
                        this.location = window.getLocation();
                    }
                } else {
                    window.setLocationRelativeTo(window.getOwner());
                    this.location = window.getLocation();
                }
            }
        } else {
            window.setLocationRelativeTo(window.getOwner());
            this.location = window.getLocation();
        }
        if (window instanceof Frame && this.state != null) {
            this.state = this.state & 0xFFFFFFFE;
            ((Frame)window).setExtendedState(this.state);
        }
    }
}

