/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll.layout;

import com.alee.api.merge.Mergeable;
import com.alee.laf.scroll.layout.ScrollBarSettings;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;

@XStreamAlias(value="ScrollPaneLayout")
public class ScrollPaneLayout
extends javax.swing.ScrollPaneLayout
implements Mergeable,
Cloneable {
    protected static final ScrollBarSettings DEFAULT_SCROLL_BAR_SETTINGS = new ScrollBarSettings();
    @XStreamAlias(value="Vertical")
    protected ScrollBarSettings vpos;
    @XStreamAlias(value="Horizontal")
    protected ScrollBarSettings hpos;

    public ScrollBarSettings getVerticalScrollBarPosition() {
        return this.vpos != null ? this.vpos : DEFAULT_SCROLL_BAR_SETTINGS;
    }

    public void setVerticalScrollBarPosition(ScrollBarSettings position) {
        this.vpos = position;
    }

    public ScrollBarSettings getHorizontalScrollBarPosition() {
        return this.hpos != null ? this.hpos : DEFAULT_SCROLL_BAR_SETTINGS;
    }

    public void setHorizontalScrollBarPosition(ScrollBarSettings position) {
        this.hpos = position;
    }

    @Override
    public void addLayoutComponent(String s, Component c) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }

    @Override
    public void syncWithScrollPane(JScrollPane scrollPane) {
    }

    @Override
    public void layoutContainer(Container container) {
        boolean hsbNeeded;
        boolean vsbNeeded;
        Scrollable sv;
        boolean isEmpty;
        Insets viewInsets;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)container;
        JViewport viewport = scrollPane.getViewport();
        JScrollBar vsb = scrollPane.getVerticalScrollBar();
        JScrollBar hsb = scrollPane.getHorizontalScrollBar();
        JViewport rowHead = scrollPane.getRowHeader();
        JViewport colHead = scrollPane.getColumnHeader();
        Component lowerLeft = scrollPane.getCorner("LOWER_LEFT_CORNER");
        Component lowerRight = scrollPane.getCorner("LOWER_RIGHT_CORNER");
        Component upperLeft = scrollPane.getCorner("UPPER_LEFT_CORNER");
        Component upperRight = scrollPane.getCorner("UPPER_RIGHT_CORNER");
        int vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        int hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        ScrollBarSettings vpos = this.getVerticalScrollBarPosition();
        ScrollBarSettings hpos = this.getHorizontalScrollBarPosition();
        Rectangle availR = scrollPane.getBounds();
        availR.y = 0;
        availR.x = 0;
        Insets insets = container.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        boolean ltr = scrollPane.getComponentOrientation().isLeftToRight();
        Rectangle colHeadR = new Rectangle(0, availR.y, 0, 0);
        if (colHead != null && colHead.isVisible()) {
            int colHeadHeight;
            colHeadR.height = colHeadHeight = Math.min(availR.height, colHead.getPreferredSize().height);
            availR.y += colHeadHeight;
            availR.height -= colHeadHeight;
        }
        Rectangle rowHeadR = new Rectangle(0, 0, 0, 0);
        if (rowHead != null && rowHead.isVisible()) {
            int rowHeadWidth;
            rowHeadR.width = rowHeadWidth = Math.min(availR.width, rowHead.getPreferredSize().width);
            availR.width -= rowHeadWidth;
            if (ltr) {
                rowHeadR.x = availR.x;
                availR.x += rowHeadWidth;
            } else {
                rowHeadR.x = availR.x + availR.width;
            }
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            viewInsets = viewportBorder.getBorderInsets(container);
            availR.x += viewInsets.left;
            availR.y += viewInsets.top;
            availR.width -= viewInsets.left + viewInsets.right;
            availR.height -= viewInsets.top + viewInsets.bottom;
        } else {
            viewInsets = new Insets(0, 0, 0, 0);
        }
        Component view = viewport != null ? viewport.getView() : null;
        Dimension viewPrefSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
        Dimension extentSize = viewport != null ? viewport.toViewCoordinates(availR.getSize()) : new Dimension(0, 0);
        boolean viewTracksViewportWidth = false;
        boolean viewTracksViewportHeight = false;
        boolean bl = isEmpty = availR.width < 0 || availR.height < 0;
        if (!isEmpty && view instanceof Scrollable) {
            sv = (Scrollable)((Object)view);
            viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
            viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
        } else {
            sv = null;
        }
        Rectangle vsbR = new Rectangle(0, availR.y - viewInsets.top, 0, 0);
        boolean bl2 = vsbNeeded = !isEmpty && vsbPolicy != 21 && (vsbPolicy == 22 || !viewTracksViewportHeight && viewPrefSize.height > extentSize.height);
        if (vsb != null && vsbNeeded) {
            this.adjustForVSB(vsb, true, availR, vsbR, viewInsets, ltr);
            extentSize = viewport.toViewCoordinates(availR.getSize());
        }
        Rectangle hsbR = new Rectangle(availR.x - viewInsets.left, 0, 0, 0);
        boolean bl3 = hsbNeeded = !isEmpty && hsbPolicy != 31 && (hsbPolicy == 32 || !viewTracksViewportWidth && viewPrefSize.width > extentSize.width || vsb != null && vsbNeeded && vpos.isHovering() && vpos.isExtending() && viewPrefSize.width + vsb.getPreferredSize().width > extentSize.width);
        if (hsb != null && hsbNeeded) {
            this.adjustForHSB(hsb, true, availR, hsbR, viewInsets);
            if (vsb != null && !vsbNeeded && vsbPolicy != 21) {
                extentSize = viewport.toViewCoordinates(availR.getSize());
                boolean bl4 = vsbNeeded = viewPrefSize.height > extentSize.height || hpos.isHovering() && hpos.isExtending() && viewPrefSize.height + hsb.getPreferredSize().height > extentSize.height;
                if (vsbNeeded) {
                    this.adjustForVSB(vsb, true, availR, vsbR, viewInsets, ltr);
                    if (!ltr && !vpos.isHovering()) {
                        hsbR.x += vsbR.width;
                    }
                }
            }
        }
        if (viewport != null) {
            viewport.setBounds(availR);
            if (sv != null) {
                extentSize = viewport.toViewCoordinates(availR.getSize());
                boolean oldHSBNeeded = hsbNeeded;
                boolean oldVSBNeeded = vsbNeeded;
                viewTracksViewportWidth = sv.getScrollableTracksViewportWidth();
                viewTracksViewportHeight = sv.getScrollableTracksViewportHeight();
                if (vsb != null && vsbPolicy == 20) {
                    boolean newVSBNeeded;
                    boolean bl5 = newVSBNeeded = !viewTracksViewportHeight && viewPrefSize.height > extentSize.height || hsb != null && hsbNeeded && hpos.isHovering() && hpos.isExtending() && viewPrefSize.height + hsb.getPreferredSize().height > extentSize.height;
                    if (newVSBNeeded != vsbNeeded) {
                        vsbNeeded = newVSBNeeded;
                        this.adjustForVSB(vsb, vsbNeeded, availR, vsbR, viewInsets, ltr);
                        extentSize = viewport.toViewCoordinates(availR.getSize());
                    }
                }
                if (hsb != null && hsbPolicy == 30) {
                    boolean newHSBbNeeded;
                    boolean bl6 = newHSBbNeeded = !viewTracksViewportWidth && viewPrefSize.width > extentSize.width || vsb != null && vsbNeeded && vpos.isHovering() && vpos.isExtending() && viewPrefSize.width + vsb.getPreferredSize().width > extentSize.width;
                    if (newHSBbNeeded != hsbNeeded) {
                        hsbNeeded = newHSBbNeeded;
                        this.adjustForHSB(hsb, hsbNeeded, availR, hsbR, viewInsets);
                        if (vsb != null && !vsbNeeded && vsbPolicy != 21) {
                            extentSize = viewport.toViewCoordinates(availR.getSize());
                            boolean bl7 = vsbNeeded = viewPrefSize.height > extentSize.height || hsbNeeded && hpos.isHovering() && hpos.isExtending() && viewPrefSize.height + hsb.getPreferredSize().height > extentSize.height;
                            if (vsbNeeded) {
                                this.adjustForVSB(vsb, true, availR, vsbR, viewInsets, ltr);
                                if (!ltr && !vpos.isHovering()) {
                                    hsbR.x += vsbR.width;
                                }
                            }
                        }
                    }
                }
                if (oldHSBNeeded != hsbNeeded || oldVSBNeeded != vsbNeeded) {
                    viewport.setBounds(availR);
                }
            }
        }
        vsbR.height = availR.height + viewInsets.top + viewInsets.bottom;
        if (hsbNeeded) {
            if (vpos.isTrailing()) {
                vsbR.height += hsbR.height;
            }
            if (vpos.isHovering()) {
                vsbR.height -= hsbR.height;
            }
        }
        hsbR.width = availR.width + viewInsets.left + viewInsets.right;
        if (vsbNeeded) {
            if (hpos.isTrailing()) {
                hsbR.width += vsbR.width;
            }
            if (!ltr) {
                if (hpos.isTrailing() && !vpos.isHovering()) {
                    hsbR.x -= vsbR.width;
                } else if (!hpos.isTrailing() && vpos.isHovering()) {
                    hsbR.x += vsbR.width;
                }
            }
            if (hpos.isHovering()) {
                hsbR.width -= vsbR.width;
            }
        }
        rowHeadR.height = availR.height + viewInsets.top + viewInsets.bottom;
        rowHeadR.y = availR.y - viewInsets.top;
        colHeadR.width = availR.width + viewInsets.left + viewInsets.right;
        colHeadR.x = availR.x - viewInsets.left;
        if (rowHead != null) {
            rowHead.setBounds(rowHeadR);
        }
        if (colHead != null) {
            colHead.setBounds(colHeadR);
        }
        if (vsb != null) {
            if (vsbNeeded) {
                if (colHead != null && (vpos.isLeading() || UIManager.getBoolean("ScrollPane.fillUpperCorner") && (ltr && upperRight == null || !ltr && upperLeft == null))) {
                    vsbR.y = colHeadR.y;
                    vsbR.height += colHeadR.height;
                }
                vsb.setVisible(true);
                vsb.setBounds(vsbR);
                container.setComponentZOrder(vsb, 0);
            } else {
                vsb.setVisible(false);
            }
        }
        if (hsb != null) {
            if (hsbNeeded) {
                if (rowHead != null && (hpos.isLeading() || UIManager.getBoolean("ScrollPane.fillLowerCorner") && (ltr && lowerLeft == null || !ltr && lowerRight == null))) {
                    if (ltr) {
                        hsbR.x = rowHeadR.x;
                    }
                    hsbR.width += rowHeadR.width;
                }
                hsb.setVisible(true);
                hsb.setBounds(hsbR);
                container.setComponentZOrder(hsb, vsbNeeded ? 1 : 0);
            } else {
                hsb.setVisible(false);
            }
        }
        if (lowerLeft != null) {
            lowerLeft.setBounds(ltr ? rowHeadR.x : vsbR.x, hsbR.y, ltr ? rowHeadR.width : vsbR.width, hsbR.height);
        }
        if (lowerRight != null) {
            lowerRight.setBounds(ltr ? vsbR.x : rowHeadR.x, hsbR.y, ltr ? vsbR.width : rowHeadR.width, hsbR.height);
        }
        if (upperLeft != null) {
            upperLeft.setBounds(ltr ? rowHeadR.x : vsbR.x, colHeadR.y, ltr ? rowHeadR.width : vsbR.width, colHeadR.height);
        }
        if (upperRight != null) {
            upperRight.setBounds(ltr ? vsbR.x : rowHeadR.x, colHeadR.y, ltr ? vsbR.width : rowHeadR.width, colHeadR.height);
        }
        scrollPane.setComponentZOrder(viewport, scrollPane.getComponentCount() - 1);
    }

    protected void adjustForVSB(JScrollBar vsb, boolean needed, Rectangle view, Rectangle scroll, Insets viewInsets, boolean leftToRight) {
        int oldWidth = scroll.width;
        if (needed) {
            int vsbWidth = Math.max(0, Math.min(vsb.getPreferredSize().width, view.width));
            ScrollBarSettings vpos = this.getVerticalScrollBarPosition();
            if (!vpos.isHovering()) {
                view.width -= vsbWidth;
            }
            scroll.width = vsbWidth;
            if (leftToRight) {
                scroll.x = view.x + view.width + (vpos.isHovering() ? -vsbWidth : 0) + viewInsets.right;
            } else {
                scroll.x = view.x - viewInsets.left;
                view.x = view.x + (!vpos.isHovering() ? vsbWidth : 0);
            }
        } else {
            view.width += oldWidth;
        }
    }

    protected void adjustForHSB(JScrollBar hsb, boolean needed, Rectangle view, Rectangle scroll, Insets viewInsets) {
        int oldHeight = scroll.height;
        if (needed) {
            int hsbHeight = Math.max(0, Math.min(view.height, hsb.getPreferredSize().height));
            ScrollBarSettings hpos = this.getHorizontalScrollBarPosition();
            if (!hpos.isHovering()) {
                view.height -= hsbHeight;
            }
            scroll.y = view.y + view.height + (hpos.isHovering() ? -hsbHeight : 0) + viewInsets.bottom;
            scroll.height = hsbHeight;
        } else {
            view.height += oldHeight;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)container;
        JViewport viewport = scrollPane.getViewport();
        JScrollBar vsb = scrollPane.getVerticalScrollBar();
        JScrollBar hsb = scrollPane.getHorizontalScrollBar();
        JViewport rowHead = scrollPane.getRowHeader();
        JViewport colHead = scrollPane.getColumnHeader();
        int vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        int hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        ScrollBarSettings vpos = this.getVerticalScrollBarPosition();
        ScrollBarSettings hpos = this.getHorizontalScrollBarPosition();
        Insets insets = container.getInsets();
        int prefWidth = insets.left + insets.right;
        int prefHeight = insets.top + insets.bottom;
        Dimension extentSize = null;
        Dimension viewSize = null;
        Component view = null;
        if (viewport != null) {
            extentSize = viewport.getPreferredSize();
            view = viewport.getView();
            Dimension dimension = viewSize = view != null ? view.getPreferredSize() : new Dimension(0, 0);
        }
        if (extentSize != null) {
            prefWidth += extentSize.width;
            prefHeight += extentSize.height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(container);
            prefWidth += vpbInsets.left + vpbInsets.right;
            prefHeight += vpbInsets.top + vpbInsets.bottom;
        }
        if (rowHead != null && rowHead.isVisible()) {
            prefWidth += rowHead.getPreferredSize().width;
        }
        if (colHead != null && colHead.isVisible()) {
            prefHeight += colHead.getPreferredSize().height;
        }
        if (vsb != null && vsbPolicy != 21 && !vpos.isHovering()) {
            if (vsbPolicy == 22) {
                prefWidth += vsb.getPreferredSize().width;
            } else if (viewSize != null && extentSize != null) {
                boolean canScroll = true;
                if (view instanceof Scrollable) {
                    boolean bl = canScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportHeight();
                }
                if (canScroll && viewSize.height > extentSize.height) {
                    prefWidth += vsb.getPreferredSize().width;
                }
            }
        }
        if (hsb != null && hsbPolicy != 31 && !hpos.isHovering()) {
            if (hsbPolicy == 32) {
                prefHeight += hsb.getPreferredSize().height;
            } else if (viewSize != null && extentSize != null) {
                boolean canScroll = true;
                if (view instanceof Scrollable) {
                    boolean bl = canScroll = !((Scrollable)((Object)view)).getScrollableTracksViewportWidth();
                }
                if (canScroll && viewSize.width > extentSize.width) {
                    prefHeight += hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(prefWidth, prefHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension size;
        Border viewportBorder;
        JScrollPane scrollPane = (JScrollPane)container;
        JViewport viewport = scrollPane.getViewport();
        JScrollBar vsb = scrollPane.getVerticalScrollBar();
        JScrollBar hsb = scrollPane.getHorizontalScrollBar();
        JViewport rowHead = scrollPane.getRowHeader();
        JViewport colHead = scrollPane.getColumnHeader();
        int vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        int hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        ScrollBarSettings vpos = this.getVerticalScrollBarPosition();
        ScrollBarSettings hpos = this.getHorizontalScrollBarPosition();
        Insets insets = container.getInsets();
        int minWidth = insets.left + insets.right;
        int minHeight = insets.top + insets.bottom;
        if (viewport != null) {
            Dimension size2 = viewport.getMinimumSize();
            minWidth += size2.width;
            minHeight += size2.height;
        }
        if ((viewportBorder = scrollPane.getViewportBorder()) != null) {
            Insets vpbInsets = viewportBorder.getBorderInsets(container);
            minWidth += vpbInsets.left + vpbInsets.right;
            minHeight += vpbInsets.top + vpbInsets.bottom;
        }
        if (rowHead != null && rowHead.isVisible()) {
            size = rowHead.getMinimumSize();
            minWidth += size.width;
            minHeight = Math.max(minHeight, size.height);
        }
        if (colHead != null && colHead.isVisible()) {
            size = colHead.getMinimumSize();
            minWidth = Math.max(minWidth, size.width);
            minHeight += size.height;
        }
        if (vsb != null && vsbPolicy != 21 && (!vpos.isHovering() || vpos.isExtending())) {
            Dimension vms = vsb.getMinimumSize();
            minWidth += vms.width;
            minHeight = Math.max(minHeight, vms.height);
        }
        if (hsb != null && hsbPolicy != 31 && (!hpos.isHovering() || hpos.isExtending())) {
            Dimension hms = hsb.getMinimumSize();
            minWidth = Math.max(minWidth, hms.width);
            minHeight += hms.height;
        }
        return new Dimension(minWidth, minHeight);
    }

    @XStreamAlias(value="ScrollPaneLayout$UIResource")
    public static final class UIResource
    extends ScrollPaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

