/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.spinner;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class WebSpinnerLayout
extends AbstractLayoutManager {
    public static final String EDITOR = "Editor";
    public static final String NEXT = "Next";
    public static final String PREVIOUS = "Previous";
    protected Component editor = null;
    protected Component nextButton = null;
    protected Component previousButton = null;

    @Override
    public void addComponent(@NotNull Component component, @Nullable Object constraints) {
        if (EDITOR.equals(constraints)) {
            this.editor = component;
        } else if (NEXT.equals(constraints)) {
            this.nextButton = component;
        } else if (PREVIOUS.equals(constraints)) {
            this.previousButton = component;
        }
    }

    @Override
    public void removeComponent(@NotNull Component component) {
        if (component == this.editor) {
            this.editor = null;
        } else if (component == this.nextButton) {
            this.nextButton = null;
        } else if (component == this.previousButton) {
            this.previousButton = null;
        }
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        Insets b = container.getInsets();
        Dimension s = container.getSize();
        Dimension next = this.nextButton != null ? this.nextButton.getPreferredSize() : new Dimension(0, 0);
        Dimension prev = this.previousButton != null ? this.previousButton.getPreferredSize() : new Dimension(0, 0);
        int bw = Math.max(next.width, prev.width);
        int bah = s.height - b.top - b.bottom;
        int nh = bah % 2 == 0 ? bah / 2 : (bah - 1) / 2 + 1;
        int ph = bah % 2 == 0 ? bah / 2 : (bah - 1) / 2;
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        if (this.editor != null) {
            this.editor.setBounds(b.left + (ltr ? 0 : bw), b.top, s.width - b.left - b.right - bw, s.height - b.top - b.bottom);
        }
        if (this.nextButton != null) {
            this.nextButton.setBounds(ltr ? s.width - b.right - bw : b.left, b.top, bw, nh);
        }
        if (this.previousButton != null) {
            this.previousButton.setBounds(ltr ? s.width - b.right - bw : b.left, b.top + nh, bw, ph);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Insets b = container.getInsets();
        Dimension ed = this.editor != null ? this.editor.getPreferredSize() : new Dimension(0, 0);
        Dimension next = this.nextButton != null ? this.nextButton.getPreferredSize() : new Dimension(0, 0);
        Dimension prev = this.previousButton != null ? this.previousButton.getPreferredSize() : new Dimension(0, 0);
        int w = b.left + ed.width + Math.max(next.width, prev.width) + b.right;
        int h = b.top + Math.max(ed.height, next.height + prev.height) + b.bottom;
        return new Dimension(w, h);
    }
}

