/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.splitpane.ISplitPaneDividerPainter;
import com.alee.laf.splitpane.WSplitPaneDividerUI;
import com.alee.laf.splitpane.WebSplitPaneDivider;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JSplitPane;

public class SplitPaneDividerPainter<C extends WebSplitPaneDivider, U extends WSplitPaneDividerUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements ISplitPaneDividerPainter<C, U> {
    protected transient PropertyChangeListener splitPanePropertyChangeListener;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        if (((WebSplitPaneDivider)this.component).getSplitPane() != null) {
            this.installSplitPaneListeners(((WebSplitPaneDivider)this.component).getSplitPane());
        }
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        if (((WebSplitPaneDivider)this.component).getSplitPane() != null) {
            this.uninstallSplitPaneListeners(((WebSplitPaneDivider)this.component).getSplitPane());
        }
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"splitPane")) {
            if (oldValue != null) {
                this.uninstallSplitPaneListeners((JSplitPane)oldValue);
            }
            if (newValue != null) {
                this.installSplitPaneListeners((JSplitPane)newValue);
            }
        }
    }

    protected void installSplitPaneListeners(@NotNull JSplitPane splitPane) {
        this.splitPanePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (Objects.equals((Object)event.getPropertyName(), (Object[])new Object[]{"orientation", "oneTouchExpandable"})) {
                    SplitPaneDividerPainter.this.updateDecorationState();
                }
            }
        };
        splitPane.addPropertyChangeListener(this.splitPanePropertyChangeListener);
    }

    protected void uninstallSplitPaneListeners(@NotNull JSplitPane splitPane) {
        splitPane.removePropertyChangeListener(this.splitPanePropertyChangeListener);
        this.splitPanePropertyChangeListener = null;
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        JSplitPane splitPane = ((WebSplitPaneDivider)this.component).getSplitPane();
        if (splitPane != null) {
            boolean vertical = splitPane.getOrientation() == 1;
            states.add(vertical ? "vertical" : "horizontal");
            if (splitPane.isOneTouchExpandable()) {
                states.add("one-touch");
            }
        }
        return states;
    }
}

