/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.laf.splitpane.WSplitPaneUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.JSplitPane;

public class SplitPaneLayout
implements LayoutManager2 {
    protected int[] sizes;
    protected Component[] components;
    protected int lastSplitPaneSize;
    protected boolean doReset;
    protected final int axis;

    public SplitPaneLayout(int orientation) {
        this.axis = orientation == 1 ? 0 : 1;
        this.components = new Component[3];
        this.sizes = new int[3];
    }

    @Override
    public void addLayoutComponent(String constraints, Component component) {
        boolean isValid = true;
        if (constraints != null) {
            if (constraints.equals("divider")) {
                this.components[2] = component;
                this.sizes[2] = this.getSizeForPrimaryAxis(component.getPreferredSize());
            } else if (constraints.equals("left") || constraints.equals("top")) {
                this.components[0] = component;
                this.sizes[0] = 0;
            } else if (constraints.equals("right") || constraints.equals("bottom")) {
                this.components[1] = component;
                this.sizes[1] = 0;
            } else if (!constraints.equals("nonContinuousDivider")) {
                isValid = false;
            }
        } else {
            isValid = false;
        }
        if (!isValid) {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + constraints);
        }
        this.doReset = true;
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
        }
        this.addLayoutComponent((String)constraints, component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        for (int counter = 0; counter < 3; ++counter) {
            if (this.components[counter] != component) continue;
            this.components[counter] = null;
            this.sizes[counter] = 0;
            this.doReset = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        int newLocation;
        Dimension dSize;
        JSplitPane splitPane = (JSplitPane)container;
        WSplitPaneUI splitPaneUI = (WSplitPaneUI)splitPane.getUI();
        Dimension containerSize = container.getSize();
        if (containerSize.height <= 0 || containerSize.width <= 0) {
            this.lastSplitPaneSize = 0;
            return;
        }
        int spDividerLocation = splitPane.getDividerLocation();
        Insets insets = splitPane.getInsets();
        int availableSize = this.getAvailableSize(containerSize, insets);
        int dOffset = this.getSizeForPrimaryAxis(insets, true);
        Dimension dimension = dSize = this.components[2] == null ? null : this.components[2].getPreferredSize();
        if (this.doReset && !splitPaneUI.isDividerLocationSet() || spDividerLocation < 0) {
            this.resetToPreferredSizes(splitPane, availableSize);
        } else if (this.lastSplitPaneSize <= 0 || availableSize == this.lastSplitPaneSize || !splitPaneUI.isPainted() || dSize != null && this.getSizeForPrimaryAxis(dSize) != this.sizes[2]) {
            this.sizes[2] = dSize != null ? this.getSizeForPrimaryAxis(dSize) : 0;
            this.setDividerLocation(spDividerLocation - dOffset, availableSize);
            splitPaneUI.setDividerLocationSet(false);
        } else if (availableSize != this.lastSplitPaneSize) {
            this.distributeSpace(splitPane, availableSize - this.lastSplitPaneSize, splitPaneUI.isKeepHidden());
        }
        this.doReset = false;
        splitPaneUI.setDividerLocationSet(false);
        this.lastSplitPaneSize = availableSize;
        int nextLocation = this.getInitialLocation(insets);
        int counter = 0;
        while (counter < 3) {
            if (this.components[counter] != null && this.components[counter].isVisible()) {
                this.setComponentToSize(this.components[counter], this.sizes[counter], nextLocation, insets, containerSize);
                nextLocation += this.sizes[counter];
            }
            switch (counter) {
                case 0: {
                    counter = 2;
                    break;
                }
                case 2: {
                    counter = 1;
                    break;
                }
                case 1: {
                    counter = 3;
                }
            }
        }
        if (splitPaneUI.isPainted() && (newLocation = splitPane.getUI().getDividerLocation(splitPane)) != spDividerLocation - dOffset) {
            try {
                int lastLocation = splitPane.getLastDividerLocation();
                splitPaneUI.setIgnoreDividerLocationChange(true);
                splitPane.setDividerLocation(newLocation);
                splitPane.setLastDividerLocation(lastLocation);
            }
            finally {
                splitPaneUI.setIgnoreDividerLocationChange(false);
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        JSplitPane splitPane = (JSplitPane)container;
        int minPrimary = 0;
        int minSecondary = 0;
        Insets insets = splitPane.getInsets();
        for (int counter = 0; counter < 3; ++counter) {
            if (this.components[counter] == null) continue;
            Dimension minSize = this.components[counter].getMinimumSize();
            int secSize = this.getSizeForSecondaryAxis(minSize);
            minPrimary += this.getSizeForPrimaryAxis(minSize);
            if (secSize <= minSecondary) continue;
            minSecondary = secSize;
        }
        if (insets != null) {
            minPrimary += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
            minSecondary += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
        }
        if (this.axis == 0) {
            return new Dimension(minPrimary, minSecondary);
        }
        return new Dimension(minSecondary, minPrimary);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        JSplitPane splitPane = (JSplitPane)container;
        int prePrimary = 0;
        int preSecondary = 0;
        Insets insets = splitPane.getInsets();
        for (int counter = 0; counter < 3; ++counter) {
            if (this.components[counter] == null) continue;
            Dimension preSize = this.components[counter].getPreferredSize();
            int secSize = this.getSizeForSecondaryAxis(preSize);
            prePrimary += this.getSizeForPrimaryAxis(preSize);
            if (secSize <= preSecondary) continue;
            preSecondary = secSize;
        }
        if (insets != null) {
            prePrimary += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
            preSecondary += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
        }
        if (this.axis == 0) {
            return new Dimension(prePrimary, preSecondary);
        }
        return new Dimension(preSecondary, prePrimary);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    public void resetToPreferredSizes() {
        this.doReset = true;
    }

    protected void setSizes(int[] newSizes) {
        System.arraycopy(newSizes, 0, this.sizes, 0, 3);
    }

    protected int[] getSizes() {
        int[] retSizes = new int[3];
        System.arraycopy(this.sizes, 0, retSizes, 0, 3);
        return retSizes;
    }

    protected int getPreferredSizeOfComponent(Component component) {
        return this.getSizeForPrimaryAxis(component.getPreferredSize());
    }

    protected int getMinimumSizeOfComponent(Component component) {
        return this.getSizeForPrimaryAxis(component.getMinimumSize());
    }

    protected int getAvailableSize(Dimension containerSize, Insets insets) {
        int size = this.getSizeForPrimaryAxis(containerSize);
        if (insets != null) {
            size -= this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
        }
        return size;
    }

    protected int getInitialLocation(Insets insets) {
        return insets != null ? this.getSizeForPrimaryAxis(insets, true) : 0;
    }

    protected void setComponentToSize(Component component, int size, int location, Insets insets, Dimension containerSize) {
        if (insets != null) {
            if (this.axis == 0) {
                component.setBounds(location, insets.top, size, containerSize.height - (insets.top + insets.bottom));
            } else {
                component.setBounds(insets.left, location, containerSize.width - (insets.left + insets.right), size);
            }
        } else if (this.axis == 0) {
            component.setBounds(location, 0, size, containerSize.height);
        } else {
            component.setBounds(0, location, containerSize.width, size);
        }
    }

    protected int getSizeForPrimaryAxis(Dimension size) {
        return this.axis == 0 ? size.width : size.height;
    }

    protected int getSizeForSecondaryAxis(Dimension size) {
        return this.axis == 0 ? size.height : size.width;
    }

    protected int getSizeForPrimaryAxis(Insets insets, boolean isTop) {
        return this.axis == 0 ? (isTop ? insets.left : insets.right) : (isTop ? insets.top : insets.bottom);
    }

    protected int getSizeForSecondaryAxis(Insets insets, boolean isTop) {
        return this.axis == 0 ? (isTop ? insets.top : insets.bottom) : (isTop ? insets.left : insets.right);
    }

    protected void updateComponents(JSplitPane splitPane) {
        WSplitPaneUI splitPaneUI = (WSplitPaneUI)splitPane.getUI();
        Component comp = splitPane.getLeftComponent();
        if (this.components[0] != comp) {
            this.components[0] = comp;
            this.sizes[0] = comp == null ? 0 : -1;
        }
        if (this.components[1] != (comp = splitPane.getRightComponent())) {
            this.components[1] = comp;
            this.sizes[1] = comp == null ? 0 : -1;
        }
        Component[] children = splitPane.getComponents();
        Component oldDivider = this.components[2];
        this.components[2] = null;
        for (int counter = children.length - 1; counter >= 0; --counter) {
            if (children[counter] == this.components[0] || children[counter] == this.components[1] || children[counter] == splitPaneUI.getNonContinuousLayoutDivider()) continue;
            if (oldDivider != children[counter]) {
                this.components[2] = children[counter];
                break;
            }
            this.components[2] = oldDivider;
            break;
        }
        this.sizes[2] = this.components[2] == null ? 0 : this.getSizeForPrimaryAxis(this.components[2].getPreferredSize());
    }

    protected void setDividerLocation(int leftSize, int availableSize) {
        boolean lValid = this.components[0] != null && this.components[0].isVisible();
        boolean rValid = this.components[1] != null && this.components[1].isVisible();
        boolean dValid = this.components[2] != null && this.components[2].isVisible();
        int max = availableSize;
        if (dValid) {
            max -= this.sizes[2];
        }
        leftSize = Math.max(0, Math.min(leftSize, max));
        if (lValid) {
            if (rValid) {
                this.sizes[0] = leftSize;
                this.sizes[1] = max - leftSize;
            } else {
                this.sizes[0] = max;
                this.sizes[1] = 0;
            }
        } else if (rValid) {
            this.sizes[1] = max;
            this.sizes[0] = 0;
        }
    }

    protected int[] getPreferredSizes() {
        int[] retValue = new int[3];
        for (int counter = 0; counter < 3; ++counter) {
            retValue[counter] = this.components[counter] != null && this.components[counter].isVisible() ? this.getPreferredSizeOfComponent(this.components[counter]) : -1;
        }
        return retValue;
    }

    protected int[] getMinimumSizes() {
        int[] retValue = new int[3];
        for (int counter = 0; counter < 2; ++counter) {
            retValue[counter] = this.components[counter] != null && this.components[counter].isVisible() ? this.getMinimumSizeOfComponent(this.components[counter]) : -1;
        }
        retValue[2] = this.components[2] != null ? this.getMinimumSizeOfComponent(this.components[2]) : -1;
        return retValue;
    }

    protected void resetToPreferredSizes(JSplitPane splitPane, int availableSize) {
        int counter;
        int[] testSizes = this.getPreferredSizes();
        int totalSize = 0;
        for (counter = 0; counter < 3; ++counter) {
            if (testSizes[counter] == -1) continue;
            totalSize += testSizes[counter];
        }
        if (totalSize > availableSize) {
            testSizes = this.getMinimumSizes();
            totalSize = 0;
            for (counter = 0; counter < 3; ++counter) {
                if (testSizes[counter] == -1) continue;
                totalSize += testSizes[counter];
            }
        }
        this.setSizes(testSizes);
        this.distributeSpace(splitPane, availableSize - totalSize, false);
    }

    protected void distributeSpace(JSplitPane splitPane, int space, boolean keepHidden) {
        boolean rValid;
        boolean lValid = this.components[0] != null && this.components[0].isVisible();
        boolean bl = rValid = this.components[1] != null && this.components[1].isVisible();
        if (keepHidden) {
            if (lValid && this.getSizeForPrimaryAxis(this.components[0].getSize()) == 0) {
                lValid = rValid && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0;
            } else if (rValid && this.getSizeForPrimaryAxis(this.components[1].getSize()) == 0) {
                rValid = false;
            }
        }
        if (lValid && rValid) {
            boolean rMinValid;
            double weight = splitPane.getResizeWeight();
            int lExtra = (int)(weight * (double)space);
            int rExtra = space - lExtra;
            this.sizes[0] = this.sizes[0] + lExtra;
            this.sizes[1] = this.sizes[1] + rExtra;
            int lMin = this.getMinimumSizeOfComponent(this.components[0]);
            int rMin = this.getMinimumSizeOfComponent(this.components[1]);
            boolean lMinValid = this.sizes[0] >= lMin;
            boolean bl2 = rMinValid = this.sizes[1] >= rMin;
            if (!lMinValid && !rMinValid) {
                if (this.sizes[0] < 0) {
                    this.sizes[1] = this.sizes[1] + this.sizes[0];
                    this.sizes[0] = 0;
                } else if (this.sizes[1] < 0) {
                    this.sizes[0] = this.sizes[0] + this.sizes[1];
                    this.sizes[1] = 0;
                }
            } else if (!lMinValid) {
                if (this.sizes[1] - (lMin - this.sizes[0]) < rMin) {
                    if (this.sizes[0] < 0) {
                        this.sizes[1] = this.sizes[1] + this.sizes[0];
                        this.sizes[0] = 0;
                    }
                } else {
                    this.sizes[1] = this.sizes[1] - (lMin - this.sizes[0]);
                    this.sizes[0] = lMin;
                }
            } else if (!rMinValid) {
                if (this.sizes[0] - (rMin - this.sizes[1]) < lMin) {
                    if (this.sizes[1] < 0) {
                        this.sizes[0] = this.sizes[0] + this.sizes[1];
                        this.sizes[1] = 0;
                    }
                } else {
                    this.sizes[0] = this.sizes[0] - (rMin - this.sizes[1]);
                    this.sizes[1] = rMin;
                }
            }
            if (this.sizes[0] < 0) {
                this.sizes[0] = 0;
            }
            if (this.sizes[1] < 0) {
                this.sizes[1] = 0;
            }
        } else if (lValid) {
            this.sizes[0] = Math.max(0, this.sizes[0] + space);
        } else if (rValid) {
            this.sizes[1] = Math.max(0, this.sizes[1] + space);
        }
    }
}

