/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.AbstractUIInputListener;
import com.alee.laf.UIAction;
import com.alee.laf.UIActionMap;
import com.alee.laf.splitpane.SplitPaneInputListener;
import com.alee.laf.splitpane.WSplitPaneUI;
import com.alee.utils.LafLookup;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WSplitPaneInputListener<C extends JSplitPane, U extends WSplitPaneUI<C>>
extends AbstractUIInputListener<C, U>
implements SplitPaneInputListener<C>,
PropertyChangeListener,
FocusListener {
    protected Set managingFocusForwardTraversalKeys;
    protected Set managingFocusBackwardTraversalKeys;

    @Override
    public void install(@NotNull C component) {
        super.install(component);
        ((Container)component).addPropertyChangeListener(this);
        ((Component)component).addFocusListener(this);
        this.managingFocusForwardTraversalKeys = new HashSet();
        this.managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        ((JComponent)component).setFocusTraversalKeys(0, this.managingFocusForwardTraversalKeys);
        this.managingFocusBackwardTraversalKeys = new HashSet();
        this.managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        ((JComponent)component).setFocusTraversalKeys(1, this.managingFocusBackwardTraversalKeys);
        UIActionMap actionMap = new UIActionMap();
        actionMap.put(new Action<C>(component, "negativeIncrement"));
        actionMap.put(new Action<C>(component, "positiveIncrement"));
        actionMap.put(new Action<C>(component, "selectMin"));
        actionMap.put(new Action<C>(component, "selectMax"));
        actionMap.put(new Action<C>(component, "startResize"));
        actionMap.put(new Action<C>(component, "toggleFocus"));
        actionMap.put(new Action<C>(component, "focusOutForward"));
        actionMap.put(new Action<C>(component, "focusOutBackward"));
        SwingUtilities.replaceUIActionMap(component, actionMap);
        InputMap inputMap = LafLookup.getInputMap(component, 1);
        SwingUtilities.replaceUIInputMap(component, 1, inputMap);
    }

    @Override
    public void uninstall(@NotNull C component) {
        SwingUtilities.replaceUIInputMap(component, 1, null);
        SwingUtilities.replaceUIActionMap(component, null);
        ((JComponent)component).setFocusTraversalKeys(1, null);
        this.managingFocusBackwardTraversalKeys = null;
        ((JComponent)component).setFocusTraversalKeys(0, null);
        this.managingFocusForwardTraversalKeys = null;
        ((Component)component).removeFocusListener(this);
        ((Component)component).removePropertyChangeListener(this);
        super.uninstall(component);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event.getSource() == this.component) {
            String changeName = event.getPropertyName();
            if (changeName.equals("orientation")) {
                ((WSplitPaneUI)this.componentUI).setOrientation(((JSplitPane)this.component).getOrientation());
                ((WSplitPaneUI)this.componentUI).resetLayoutManager();
            } else if (changeName.equals("continuousLayout")) {
                ((WSplitPaneUI)this.componentUI).setContinuousLayout(((JSplitPane)this.component).isContinuousLayout());
                if (!((WSplitPaneUI)this.componentUI).isContinuousLayout()) {
                    if (((WSplitPaneUI)this.componentUI).getNonContinuousLayoutDivider() == null) {
                        ((WSplitPaneUI)this.componentUI).setNonContinuousLayoutDivider(((WSplitPaneUI)this.componentUI).createNonContinuousDivider(), true);
                    } else if (((WSplitPaneUI)this.componentUI).getNonContinuousLayoutDivider().getParent() == null) {
                        ((WSplitPaneUI)this.componentUI).setNonContinuousLayoutDivider(((WSplitPaneUI)this.componentUI).getNonContinuousLayoutDivider(), true);
                    }
                }
            } else if (changeName.equals("dividerSize")) {
                ((WSplitPaneUI)this.componentUI).setDividerSize(((JSplitPane)this.component).getDividerSize());
                ((JSplitPane)this.component).revalidate();
                ((JSplitPane)this.component).repaint();
            }
        }
    }

    @Override
    public void focusGained(@NotNull FocusEvent event) {
        ((WSplitPaneUI)this.componentUI).setDividerKeyboardResize(true);
    }

    @Override
    public void focusLost(@NotNull FocusEvent event) {
        ((WSplitPaneUI)this.componentUI).setDividerKeyboardResize(false);
    }

    public static class Action<S extends JSplitPane>
    extends UIAction<S> {
        public static final String NEGATIVE_INCREMENT = "negativeIncrement";
        public static final String POSITIVE_INCREMENT = "positiveIncrement";
        public static final String SELECT_MIN = "selectMin";
        public static final String SELECT_MAX = "selectMax";
        public static final String START_RESIZE = "startResize";
        public static final String TOGGLE_FOCUS = "toggleFocus";
        public static final String FOCUS_OUT_FORWARD = "focusOutForward";
        public static final String FOCUS_OUT_BACKWARD = "focusOutBackward";

        public Action(@NotNull S splitPane, @NotNull String name) {
            super(splitPane, name);
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent event) {
            JSplitPane splitPane = (JSplitPane)this.getComponent();
            WSplitPaneUI splitPaneUI = (WSplitPaneUI)LafUtils.getUI(splitPane);
            if (splitPaneUI != null) {
                String key = this.getName();
                if (key.equals(NEGATIVE_INCREMENT)) {
                    if (splitPaneUI.isDividerKeyboardResize()) {
                        splitPane.setDividerLocation(Math.max(0, splitPaneUI.getDividerLocation(splitPane) - splitPaneUI.getKeyboardMoveIncrement()));
                    }
                } else if (key.equals(POSITIVE_INCREMENT)) {
                    if (splitPaneUI.isDividerKeyboardResize()) {
                        splitPane.setDividerLocation(splitPaneUI.getDividerLocation(splitPane) + splitPaneUI.getKeyboardMoveIncrement());
                    }
                } else if (key.equals(SELECT_MIN)) {
                    if (splitPaneUI.isDividerKeyboardResize()) {
                        splitPane.setDividerLocation(0);
                    }
                } else if (key.equals(SELECT_MAX)) {
                    if (splitPaneUI.isDividerKeyboardResize()) {
                        int rightI;
                        Insets insets = splitPane.getInsets();
                        int bottomI = insets != null ? insets.bottom : 0;
                        int n = rightI = insets != null ? insets.right : 0;
                        if (splitPaneUI.orientation == 0) {
                            splitPane.setDividerLocation(splitPane.getHeight() - bottomI);
                        } else {
                            splitPane.setDividerLocation(splitPane.getWidth() - rightI);
                        }
                    }
                } else if (key.equals(START_RESIZE)) {
                    if (!splitPaneUI.isDividerKeyboardResize()) {
                        splitPane.requestFocus();
                    } else {
                        JSplitPane parentSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, splitPane);
                        if (parentSplitPane != null) {
                            parentSplitPane.requestFocus();
                        }
                    }
                } else if (key.equals(TOGGLE_FOCUS)) {
                    this.toggleFocus(splitPane);
                } else if (key.equals(FOCUS_OUT_FORWARD)) {
                    this.moveFocus(splitPane, 1);
                } else if (key.equals(FOCUS_OUT_BACKWARD)) {
                    this.moveFocus(splitPane, -1);
                }
            }
        }

        protected void moveFocus(@NotNull S splitPane, int direction) {
            Container rootAncestor = ((Component)splitPane).getFocusCycleRootAncestor();
            FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
            Component focusOn = direction > 0 ? policy.getComponentAfter(rootAncestor, (Component)splitPane) : policy.getComponentBefore(rootAncestor, (Component)splitPane);
            HashSet<Component> focusFrom = new HashSet<Component>();
            if (((Container)splitPane).isAncestorOf(focusOn)) {
                do {
                    focusFrom.add(focusOn);
                    rootAncestor = focusOn.getFocusCycleRootAncestor();
                    policy = rootAncestor.getFocusTraversalPolicy();
                    Component component = focusOn = direction > 0 ? policy.getComponentAfter(rootAncestor, focusOn) : policy.getComponentBefore(rootAncestor, focusOn);
                } while (((Container)splitPane).isAncestorOf(focusOn) && !focusFrom.contains(focusOn));
            }
            if (focusOn != null && !((Container)splitPane).isAncestorOf(focusOn)) {
                focusOn.requestFocus();
            }
        }

        protected void toggleFocus(@NotNull S splitPane) {
            Component left = ((JSplitPane)splitPane).getLeftComponent();
            Component right = ((JSplitPane)splitPane).getRightComponent();
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component focus = manager.getFocusOwner();
            Component focusOn = this.getNextSide((JSplitPane)splitPane, focus);
            if (!(focusOn == null || focus != null && (SwingUtilities.isDescendingFrom(focus, left) && SwingUtilities.isDescendingFrom(focusOn, left) || SwingUtilities.isDescendingFrom(focus, right) && SwingUtilities.isDescendingFrom(focusOn, right)))) {
                SwingUtils.compositeRequestFocus(focusOn);
            }
        }

        @Nullable
        protected Component getNextSide(@NotNull JSplitPane splitPane, @Nullable Component focus) {
            Component result = null;
            Component left = splitPane.getLeftComponent();
            Component right = splitPane.getRightComponent();
            if (focus != null && SwingUtilities.isDescendingFrom(focus, left) && right != null) {
                result = this.getFirstAvailableComponent(right);
            }
            if (result == null) {
                JSplitPane parentSplitPane = (JSplitPane)SwingUtilities.getAncestorOfClass(JSplitPane.class, splitPane);
                if (parentSplitPane != null) {
                    result = this.getNextSide(parentSplitPane, focus);
                } else {
                    result = this.getFirstAvailableComponent(left);
                    if (result == null) {
                        result = this.getFirstAvailableComponent(right);
                    }
                }
            }
            return result;
        }

        @Nullable
        protected Component getFirstAvailableComponent(@Nullable Component component) {
            if (component != null && component instanceof JSplitPane) {
                JSplitPane splitPane = (JSplitPane)component;
                Component left = this.getFirstAvailableComponent(splitPane.getLeftComponent());
                component = left != null ? left : this.getFirstAvailableComponent(splitPane.getRightComponent());
            }
            return component;
        }
    }
}

