/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.WebUI;
import com.alee.laf.button.WebButton;
import com.alee.laf.tabbedpane.Tab;
import com.alee.laf.tabbedpane.TabArea;
import com.alee.laf.tabbedpane.TabContainer;
import com.alee.laf.tabbedpane.TabContainerLayout;
import com.alee.laf.tabbedpane.TabMenuButton;
import com.alee.laf.tabbedpane.TabViewport;
import com.alee.laf.tabbedpane.TabbedPaneInputListener;
import com.alee.laf.tabbedpane.TabbedPaneTabArea;
import com.alee.laf.tabbedpane.TabbedPaneToolTipProvider;
import com.alee.laf.tabbedpane.WTabbedPaneInputListener;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.laf.viewport.WebViewport;
import com.alee.managers.hover.GlobalHoverListener;
import com.alee.managers.hover.HoverManager;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.style.ChildStyleId;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.FontUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.TabbedPaneUI;

public abstract class WTabbedPaneUI<C extends JTabbedPane>
extends TabbedPaneUI
implements WebUI<C> {
    @Nullable
    protected PropertyChangeListener propertyChangeListener;
    @Nullable
    protected ChangeListener changeListener;
    @Nullable
    protected ContainerListener containerListener;
    @Nullable
    protected ComponentListener componentListener;
    @Nullable
    protected TabbedPaneInputListener<C> inputListener;
    @Nullable
    protected GlobalHoverListener toolTipHoverListener;
    protected C tabbedPane;
    protected TabArea tabArea;
    protected WebButton tabMenuButton;
    protected TabViewport tabViewport;
    protected TabContainer tabContainer;

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "TabbedPane.";
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.tabbedPane = (JTabbedPane)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.tabbedPane = null;
    }

    protected void installDefaults() {
        LafUtils.installDefaults(this.tabbedPane, this.getPropertyPrefix());
    }

    protected void uninstallDefaults() {
        LafUtils.uninstallDefaults(this.tabbedPane);
    }

    protected void installComponents() {
        this.tabArea = this.createTabArea();
        ((JTabbedPane)this.tabbedPane).add(this.tabArea);
        this.tabMenuButton = this.createTabMenuButton();
        this.tabArea.add((Component)this.tabMenuButton);
        this.tabViewport = this.createTabViewport();
        this.tabArea.add((Component)this.tabViewport);
        this.tabContainer = this.createTabContainer();
        this.tabViewport.setView(this.tabContainer);
        for (int index = 0; index < ((JTabbedPane)this.tabbedPane).getTabCount(); ++index) {
            this.addTab(index);
        }
    }

    @NotNull
    protected TabArea createTabArea() {
        return new TabArea((JTabbedPane)this.tabbedPane);
    }

    @NotNull
    protected TabMenuButton createTabMenuButton() {
        return new TabMenuButton((JTabbedPane)this.tabbedPane, this.tabArea);
    }

    @NotNull
    protected TabViewport createTabViewport() {
        return new TabViewport((JTabbedPane)this.tabbedPane, this.tabArea);
    }

    @NotNull
    protected TabContainer createTabContainer() {
        return new TabContainer((JTabbedPane)this.tabbedPane, this.tabViewport);
    }

    protected void uninstallComponents() {
        ((JTabbedPane)this.tabbedPane).remove(this.tabArea);
        this.tabContainer = null;
        this.tabViewport = null;
        this.tabArea = null;
    }

    protected void addTab(int index) {
        Tab tab = this.createTab(index);
        Component tabComponent = ((JTabbedPane)this.tabbedPane).getTabComponentAt(index);
        if (tabComponent != null) {
            tab.add(tabComponent);
        }
        this.tabContainer.add((Component)tab, index);
        if (this.inputListener != null) {
            this.inputListener.tabAdded(tab, index);
        }
        this.updateTabAreaStates();
        this.recalculateViewSizes();
    }

    @NotNull
    protected Tab createTab(int index) {
        return new Tab((JTabbedPane)this.tabbedPane, this.tabContainer, index);
    }

    protected void removeTab(int index) {
        this.tabContainer.remove(index);
        if (this.inputListener != null) {
            this.inputListener.tabRemoved(index);
        }
        this.updateTabAreaStates();
        this.recalculateViewSizes();
        ((JComponent)this.tabbedPane).putClientProperty("__index_to_remove__", null);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            ((Container)this.tabbedPane).addPropertyChangeListener(this.propertyChangeListener);
        }
        this.changeListener = this.createChangeListener();
        if (this.changeListener != null) {
            ((JTabbedPane)this.tabbedPane).addChangeListener(this.changeListener);
        }
        this.containerListener = this.createContainerListener();
        if (this.containerListener != null) {
            ((Container)this.tabbedPane).addContainerListener(this.containerListener);
        }
        this.componentListener = this.createComponentListener();
        if (this.componentListener != null) {
            ((Component)this.tabbedPane).addComponentListener(this.componentListener);
        }
        this.inputListener = this.createTabbedPaneInputListener();
        if (this.inputListener != null) {
            this.inputListener.install(this.tabbedPane);
        }
        this.updateToolTipHoverListener();
    }

    protected void uninstallListeners() {
        this.uninstallToolTipHoverListener();
        if (this.inputListener != null) {
            this.inputListener.uninstall(this.tabbedPane);
            this.inputListener = null;
        }
        if (this.componentListener != null) {
            ((Component)this.tabbedPane).removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
        if (this.containerListener != null) {
            ((Container)this.tabbedPane).removeContainerListener(this.containerListener);
            this.containerListener = null;
        }
        if (this.changeListener != null) {
            ((JTabbedPane)this.tabbedPane).removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        if (this.propertyChangeListener != null) {
            ((Component)this.tabbedPane).removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    @Nullable
    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if (Objects.equals((Object)property, (Object[])new Object[]{"tabLayoutPolicy", "tabPlacement"})) {
                    ((JComponent)WTabbedPaneUI.this.tabbedPane).revalidate();
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                } else if (Objects.equals((Object)property, (Object)"indexForTitle")) {
                    int index = (Integer)evt.getNewValue();
                    Tab tab = (Tab)WTabbedPaneUI.this.tabContainer.getComponent(index);
                    String newTitle = ((JTabbedPane)WTabbedPaneUI.this.tabbedPane).getTitleAt(index);
                    tab.setText(UILanguageManager.getInitialText(newTitle, new Object[0]));
                    UILanguageManager.registerInitialLanguage(tab, newTitle, new Object[0]);
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                } else if (Objects.equals((Object)property, (Object)"indexForTabComponent")) {
                    int index = (Integer)evt.getNewValue();
                    Tab tab = (Tab)WTabbedPaneUI.this.tabContainer.getComponent(index);
                    tab.setComponent(((JTabbedPane)WTabbedPaneUI.this.tabbedPane).getTabComponentAt(index));
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                } else if (Objects.equals((Object)property, (Object)"indexForNullComponent")) {
                    Integer addedIndex = (Integer)evt.getNewValue();
                    if (addedIndex != null && addedIndex != -1) {
                        WTabbedPaneUI.this.addTab(addedIndex);
                    }
                } else if (Objects.equals((Object)property, (Object)"__index_to_remove__")) {
                    Integer index = (Integer)evt.getNewValue();
                    if (index != null) {
                        WTabbedPaneUI.this.removeTab(index);
                    }
                } else if (Objects.equals((Object)property, (Object)"font")) {
                    FontUIResource font = FontUtils.getFontUIResource(((Component)WTabbedPaneUI.this.tabbedPane).getFont());
                    for (int i = 0; i < WTabbedPaneUI.this.tabContainer.getComponentCount(); ++i) {
                        Component component = WTabbedPaneUI.this.tabContainer.getComponent(i);
                        if (!(component instanceof Tab)) continue;
                        FontUtils.replaceFontUIResource(component, font);
                    }
                } else if (Objects.equals((Object)property, (Object)"enabledAt")) {
                    int index = (Integer)evt.getNewValue();
                    Tab tab = (Tab)WTabbedPaneUI.this.tabContainer.getComponent(index);
                    tab.setEnabled(((JTabbedPane)WTabbedPaneUI.this.tabbedPane).isEnabledAt(index));
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                } else if (Objects.equals((Object)property, (Object)"iconAt")) {
                    int index = (Integer)evt.getNewValue();
                    Tab tab = (Tab)WTabbedPaneUI.this.tabContainer.getComponent(index);
                    tab.setIcon(((JTabbedPane)WTabbedPaneUI.this.tabbedPane).getIconAt(index));
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                } else if (Objects.equals((Object)property, (Object)"disabledIconAt")) {
                    int index = (Integer)evt.getNewValue();
                    Tab tab = (Tab)WTabbedPaneUI.this.tabContainer.getComponent(index);
                    tab.setDisabledIcon(((JTabbedPane)WTabbedPaneUI.this.tabbedPane).getDisabledIconAt(index));
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                } else if (Objects.equals((Object)property, (Object)"styleIdAt")) {
                    Object[] newValue = (Object[])evt.getNewValue();
                    int index = (Integer)newValue[0];
                    StyleId styleId = (StyleId)newValue[1];
                    Tab tab = (Tab)WTabbedPaneUI.this.tabContainer.getComponent(index);
                    tab.setStyleId(styleId);
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                } else if (Objects.equals((Object)property, (Object)"childStyleIdAt")) {
                    Object[] newValue = (Object[])evt.getNewValue();
                    int index = (Integer)newValue[0];
                    ChildStyleId styleId = (ChildStyleId)newValue[1];
                    Tab tab = (Tab)WTabbedPaneUI.this.tabContainer.getComponent(index);
                    tab.setStyleId(styleId.at(WTabbedPaneUI.this.tabContainer));
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                } else if (Objects.equals((Object)property, (Object)WebTabbedPane.HIDE_SINGLE_TAB_PROPERTY.key())) {
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                } else if (Objects.equals((Object)property, (Object)WebTabbedPane.TOOLTIP_PROVIDER_PROPERTY.key())) {
                    WTabbedPaneUI.this.updateToolTipHoverListener();
                } else if (Objects.equals((Object)property, (Object[])new Object[]{WebTabbedPane.LEADING_TAB_AREA_COMPONENT_PROPERTY.key(), WebTabbedPane.TRAILING_TAB_AREA_COMPONENT_PROPERTY.key()})) {
                    JComponent newComponent;
                    JComponent oldComponent = (JComponent)evt.getOldValue();
                    if (oldComponent != null) {
                        WTabbedPaneUI.this.tabArea.remove((Component)oldComponent);
                    }
                    if ((newComponent = (JComponent)evt.getNewValue()) != null) {
                        WTabbedPaneUI.this.tabArea.add((Component)newComponent);
                    }
                    WTabbedPaneUI.this.updateTabAreaStates();
                    WTabbedPaneUI.this.recalculateViewSizes();
                }
            }
        };
    }

    @Nullable
    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                WTabbedPaneUI.this.updateTabAreaStates();
                WTabbedPaneUI.this.recalculateViewSizes();
            }
        };
    }

    @Nullable
    protected ContainerListener createContainerListener() {
        return new ContainerAdapter(){

            @Override
            public void componentAdded(@NotNull ContainerEvent e) {
                int index;
                Component component = e.getChild();
                if (component != WTabbedPaneUI.this.tabArea && (index = ((JTabbedPane)WTabbedPaneUI.this.tabbedPane).indexOfComponent(component)) != -1 && WTabbedPaneUI.this.tabContainer.getComponentCount() < ((JTabbedPane)WTabbedPaneUI.this.tabbedPane).getTabCount()) {
                    WTabbedPaneUI.this.addTab(index);
                }
            }
        };
    }

    @Nullable
    protected ComponentListener createComponentListener() {
        return new ComponentAdapter(){
            private Dimension oldSize = null;

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                Dimension newSize = ((Component)WTabbedPaneUI.this.tabbedPane).getSize();
                if (Objects.notEquals((Object)this.oldSize, (Object)newSize)) {
                    WTabbedPaneUI.this.recalculateViewSizes();
                    this.oldSize = newSize;
                }
            }
        };
    }

    protected void updateTabAreaStates() {
        int tabCount = ((JTabbedPane)this.tabbedPane).getTabCount();
        this.tabArea.setVisible(tabCount > (WebTabbedPane.HIDE_SINGLE_TAB_PROPERTY.get((JComponent)this.tabbedPane) != false ? 1 : 0));
        for (int i = 0; i < this.tabContainer.getComponentCount(); ++i) {
            DecorationUtils.fireStatesChanged(this.tabContainer.getComponent(i));
        }
        DecorationUtils.fireStatesChanged(this.tabContainer);
        DecorationUtils.fireStatesChanged(this.tabArea);
    }

    protected void recalculateViewSizes() {
        Dimension oldViewSize = this.tabViewport.getViewSize();
        Dimension oldExtentSize = this.tabViewport.getExtentSize();
        this.tabContainer.revalidate();
        ((JComponent)this.tabbedPane).revalidate();
        Insets tpInsets = ((JComponent)this.tabbedPane).getInsets();
        Insets taInsets = this.tabArea.getInsets();
        Dimension tabContainerSize = this.tabContainer.getPreferredSize();
        Dimension extentSize = new Dimension(tabContainerSize);
        Dimension viewSize = new Dimension(tabContainerSize);
        JComponent leading = WebTabbedPane.LEADING_TAB_AREA_COMPONENT_PROPERTY.get((JComponent)this.tabbedPane);
        Dimension leadingSize = leading != null ? leading.getPreferredSize() : new Dimension(0, 0);
        JComponent trailing = WebTabbedPane.TRAILING_TAB_AREA_COMPONENT_PROPERTY.get((JComponent)this.tabbedPane);
        Dimension trailingSize = trailing != null ? trailing.getPreferredSize() : new Dimension(0, 0);
        switch (((JTabbedPane)this.tabbedPane).getTabPlacement()) {
            default: {
                extentSize.width = ((JComponent)this.tabbedPane).getWidth() - leadingSize.width - trailingSize.width - tpInsets.left - tpInsets.right - taInsets.left - taInsets.right;
                viewSize.width = Math.max(viewSize.width, extentSize.width);
                break;
            }
            case 2: 
            case 4: {
                extentSize.height = ((JComponent)this.tabbedPane).getHeight() - leadingSize.height - trailingSize.height - tpInsets.top - tpInsets.bottom - taInsets.top - taInsets.bottom;
                viewSize.height = Math.max(viewSize.height, extentSize.height);
            }
        }
        if (!oldViewSize.equals(extentSize) || !oldExtentSize.equals(viewSize)) {
            if (((JTabbedPane)this.tabbedPane).getTabLayoutPolicy() == 1) {
                boolean horizontal;
                int tabPlacement = ((JTabbedPane)this.tabbedPane).getTabPlacement();
                boolean bl = horizontal = tabPlacement == 1 || tabPlacement == 3;
                this.tabMenuButton.setVisible(horizontal ? viewSize.width > extentSize.width : viewSize.height > extentSize.height);
            } else {
                this.tabMenuButton.setVisible(false);
            }
            if (((JTabbedPane)this.tabbedPane).getTabLayoutPolicy() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int selectedIndex = ((JTabbedPane)WTabbedPaneUI.this.tabbedPane).getSelectedIndex();
                        if (selectedIndex != -1) {
                            Tab selectedTab = WTabbedPaneUI.this.getTab(selectedIndex);
                            Rectangle selectedBounds = selectedTab.getBounds();
                            if (!WTabbedPaneUI.this.tabContainer.getVisibleRect().contains(selectedBounds)) {
                                WTabbedPaneUI.this.tabContainer.scrollRectToVisible(selectedBounds);
                            }
                        }
                    }
                });
            }
            this.tabViewport.setViewSize(extentSize);
            this.tabViewport.setExtentSize(viewSize);
            this.tabContainer.revalidate();
            this.tabContainer.repaint();
        }
    }

    @Nullable
    protected TabbedPaneInputListener<C> createTabbedPaneInputListener() {
        return new WTabbedPaneInputListener();
    }

    protected void installToolTipHoverListener() {
        if (this.toolTipHoverListener == null) {
            this.toolTipHoverListener = this.createToolTipHoverListener();
            if (this.toolTipHoverListener != null) {
                HoverManager.registerGlobalHoverListener(this.tabbedPane, this.toolTipHoverListener);
            }
        }
    }

    protected void uninstallToolTipHoverListener() {
        if (this.toolTipHoverListener != null) {
            HoverManager.unregisterGlobalHoverListener(this.tabbedPane, this.toolTipHoverListener);
            this.toolTipHoverListener = null;
        }
    }

    protected void updateToolTipHoverListener() {
        if (this.getToolTipProvider() != null) {
            this.installToolTipHoverListener();
        } else {
            this.uninstallToolTipHoverListener();
        }
    }

    @Nullable
    protected GlobalHoverListener createToolTipHoverListener() {
        return new GlobalHoverListener(){

            @Override
            public void hoverChanged(@Nullable Component oldHover, @Nullable Component newHover) {
                Tab newHoverTab;
                Tab oldHoverTab;
                TabbedPaneToolTipProvider provider = WTabbedPaneUI.this.getToolTipProvider();
                if (provider != null && (oldHoverTab = this.getOwnedTab(oldHover)) != (newHoverTab = this.getOwnedTab(newHover))) {
                    provider.hoverAreaChanged(WTabbedPaneUI.this.tabbedPane, oldHoverTab != null ? new TabbedPaneTabArea(oldHoverTab.getIndex()) : null, newHoverTab != null ? new TabbedPaneTabArea(newHoverTab.getIndex()) : null);
                }
            }

            @Nullable
            private Tab getOwnedTab(@Nullable Component component) {
                Tab oldHoverTab;
                Tab tab = null;
                if (component instanceof Tab && (oldHoverTab = (Tab)component).getTabbedPane() == WTabbedPaneUI.this.tabbedPane) {
                    tab = oldHoverTab;
                }
                return tab;
            }
        };
    }

    @Nullable
    protected TabbedPaneToolTipProvider getToolTipProvider() {
        return this.tabbedPane != null ? WebTabbedPane.TOOLTIP_PROVIDER_PROPERTY.get((JComponent)this.tabbedPane) : null;
    }

    @Nullable
    public TabArea getTabArea() {
        return this.tabArea;
    }

    @Nullable
    public WebViewport getTabViewport() {
        return this.tabViewport;
    }

    @Nullable
    public TabContainer getTabContainer() {
        return this.tabContainer;
    }

    @NotNull
    public Tab getTab(int index) {
        if (this.tabContainer != null) {
            return (Tab)this.tabContainer.getComponent(index);
        }
        throw new RuntimeException("JTabbedPane UI is not yet initialized");
    }

    @NotNull
    public StyleId getStyleIdAt(int index) {
        return this.getTab(index).getStyleId();
    }

    @Override
    public int tabForCoordinate(@NotNull JTabbedPane pane, int x, int y) {
        int tabIndex;
        if (this.tabContainer != null) {
            if (this.tabContainer.isShowing()) {
                Point tabAreaLocation = CoreSwingUtils.getRelativeLocation((Component)this.tabContainer, this.tabbedPane);
                Component possibleTab = this.tabContainer.getComponentAt(x - tabAreaLocation.x, y - tabAreaLocation.y);
                tabIndex = this.tabContainer.getComponentZOrder(possibleTab);
            } else {
                tabIndex = -1;
            }
        } else {
            throw new RuntimeException("JTabbedPane UI is not yet initialized");
        }
        return tabIndex;
    }

    @Override
    @Nullable
    public Rectangle getTabBounds(@NotNull JTabbedPane pane, int index) {
        Rectangle tabBounds;
        if (this.tabContainer != null) {
            tabBounds = this.tabContainer.isShowing() ? SwingUtils.moveBy(this.tabContainer.getComponent(index).getBounds(), CoreSwingUtils.getRelativeLocation((Component)this.tabContainer, this.tabbedPane)) : null;
        } else {
            throw new RuntimeException("JTabbedPane UI is not yet initialized");
        }
        return tabBounds;
    }

    @Override
    public int getTabRunCount(@NotNull JTabbedPane pane) {
        int runCount;
        if (this.tabContainer != null) {
            if (this.tabContainer.getLayout() instanceof TabContainerLayout) {
                TabContainerLayout layout = (TabContainerLayout)this.tabContainer.getLayout();
                runCount = layout.getRunCount();
            } else {
                runCount = 1;
            }
        } else {
            throw new RuntimeException("JTabbedPane UI is not yet initialized");
        }
        return runCount;
    }
}

