/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table.renderers;

import com.alee.laf.label.WebLabel;
import com.alee.managers.style.StyleId;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class WebTableHeaderCellRenderer
extends WebLabel
implements TableCellRenderer,
javax.swing.plaf.UIResource {
    private boolean horizontalTextPositionSet;

    @Override
    public void setHorizontalTextPosition(int textPosition) {
        this.horizontalTextPositionSet = true;
        super.setHorizontalTextPosition(textPosition);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isPaintingForPrint = false;
        if (table != null) {
            this.setStyleId(StyleId.tableHeaderCellRenderer.at(table.getTableHeader()));
        }
        Icon sortIcon = null;
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                Color fgColor = null;
                Color bgColor = null;
                if (hasFocus) {
                    fgColor = UIManager.getColor("TableHeader.focusCellForeground");
                    bgColor = UIManager.getColor("TableHeader.focusCellBackground");
                }
                if (fgColor == null) {
                    fgColor = header.getForeground();
                }
                if (bgColor == null) {
                    bgColor = header.getBackground();
                }
                this.setForeground(fgColor);
                this.setBackground(bgColor);
                this.setFont(header.getFont());
                isPaintingForPrint = header.isPaintingForPrint();
            }
            if (!isPaintingForPrint && table.getRowSorter() != null) {
                List<RowSorter.SortKey> sortKeys;
                if (!this.horizontalTextPositionSet) {
                    this.setHorizontalTextPosition(10);
                }
                if ((sortKeys = table.getRowSorter().getSortKeys()).size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
                    switch (sortKeys.get(0).getSortOrder()) {
                        case ASCENDING: {
                            sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                            break;
                        }
                        case DESCENDING: {
                            sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                            break;
                        }
                        case UNSORTED: {
                            sortIcon = UIManager.getIcon("Table.naturalSortIcon");
                        }
                    }
                }
            }
        }
        this.setIcon(sortIcon);
        this.setText(value == null ? "" : value.toString());
        return this;
    }

    public static final class UIResource
    extends WebTableHeaderCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

