/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.text.WFormattedTextFieldUI;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.plaf.ComponentUI;

public class WebFormattedTextFieldUI
extends WFormattedTextFieldUI {
    protected String inputPrompt;
    protected transient JFormattedTextField field = null;
    protected transient JComponent leadingComponent = null;
    protected transient JComponent trailingComponent = null;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebFormattedTextFieldUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.field = (JFormattedTextField)c;
        super.installUI(c);
        StyleManager.installSkin(this.field);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.field);
        this.removeLeadingComponent();
        this.removeTrailingComponent();
        super.uninstallUI(c);
        this.field = null;
    }

    @Override
    @Nullable
    public String getInputPrompt() {
        return this.inputPrompt;
    }

    @Override
    public void setInputPrompt(@Nullable String text) {
        if (Objects.notEquals((Object)text, (Object)this.inputPrompt)) {
            this.inputPrompt = text;
            this.field.repaint();
        }
    }

    @Override
    @Nullable
    public JComponent getLeadingComponent() {
        return this.leadingComponent;
    }

    @Override
    @Nullable
    public JComponent setLeadingComponent(@Nullable JComponent leadingComponent) {
        JComponent old = this.leadingComponent;
        if (leadingComponent != this.leadingComponent) {
            if (this.leadingComponent != null) {
                this.field.remove(this.leadingComponent);
                this.leadingComponent = null;
            }
            if (leadingComponent != null) {
                this.leadingComponent = leadingComponent;
                this.field.add(leadingComponent);
            }
            SwingUtils.firePropertyChanged(this.field, "leadingComponent", old, leadingComponent);
            this.field.revalidate();
        }
        return old;
    }

    @Override
    @Nullable
    public JComponent removeLeadingComponent() {
        return this.setLeadingComponent(null);
    }

    @Override
    @Nullable
    public JComponent getTrailingComponent() {
        return this.trailingComponent;
    }

    @Override
    @Nullable
    public JComponent setTrailingComponent(@Nullable JComponent trailingComponent) {
        JComponent old = this.trailingComponent;
        if (trailingComponent != this.trailingComponent) {
            if (this.trailingComponent != null) {
                this.field.remove(this.trailingComponent);
                this.trailingComponent = null;
            }
            if (trailingComponent != null) {
                this.trailingComponent = trailingComponent;
                this.field.add(trailingComponent);
            }
            SwingUtils.firePropertyChanged(this.field, "leadingComponent", old, trailingComponent);
            this.field.revalidate();
        }
        return old;
    }

    @Override
    @Nullable
    public JComponent removeTrailingComponent() {
        return this.setTrailingComponent(null);
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    protected void paintSafely(@NotNull Graphics g) {
        ReflectUtils.setFieldValueSafely((Object)this, (String)"painted", (Object)true);
        PainterSupport.paint(g, this.getComponent(), this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        Dimension ps = super.getPreferredSize(c);
        ++ps.width;
        return PainterSupport.getPreferredSize(c, ps);
    }
}

