/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.window.WebDialog;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ProprietaryUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class WebToolBarUI
extends BasicToolBarUI {
    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebToolBarUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.toolBar);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.toolBar);
        super.uninstallUI(c);
        this.toolBar = null;
    }

    @Override
    @Nullable
    protected PropertyChangeListener createPropertyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                WebToolBarUI.this.propertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
    }

    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        if (Objects.equals((Object)property, (Object)"orientation") && newValue != null) {
            int orientation = (Integer)newValue;
            for (Component component : this.toolBar.getComponents()) {
                if (!(component instanceof JToolBar.Separator)) continue;
                JToolBar.Separator separator = (JToolBar.Separator)component;
                separator.setOrientation(orientation == 0 ? 1 : 0);
                Dimension size = separator.getSeparatorSize();
                if (size == null || size.width == size.height) continue;
                Dimension newSize = new Dimension(size.height, size.width);
                separator.setSeparatorSize(newSize);
            }
        }
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return null;
    }

    @Override
    protected RootPaneContainer createFloatingWindow(@NotNull JToolBar toolbar) {
        Window window = CoreSwingUtils.getWindowAncestor((Component)toolbar);
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName()) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName()) : new ToolBarDialog((Frame)null, toolbar.getName()));
        dialog.getRootPane().setName("ToolBar.FloatingWindow");
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        dialog.addWindowListener(this.createFrameListener());
        return dialog;
    }

    @Override
    protected BasicToolBarUI.DragWindow createDragWindow(@NotNull JToolBar toolbar) {
        BasicToolBarUI.DragWindow dragWindow = super.createDragWindow(toolbar);
        ProprietaryUtils.setWindowOpacity(dragWindow, 0.5f);
        return dragWindow;
    }

    @Override
    protected void installRolloverBorders(@NotNull JComponent c) {
    }

    @Override
    protected void installNonRolloverBorders(@NotNull JComponent c) {
    }

    @Override
    protected void installNormalBorders(@NotNull JComponent c) {
    }

    @Override
    protected void setBorderToRollover(@NotNull Component c) {
    }

    @Override
    protected void setBorderToNonRollover(@NotNull Component c) {
    }

    @Override
    protected void setBorderToNormal(@NotNull Component c) {
    }

    protected class ToolBarDialog
    extends WebDialog {
        public ToolBarDialog(@Nullable Frame owner, String title) {
            super(owner, title, false);
        }

        public ToolBarDialog(@Nullable Dialog owner, String title) {
            super(owner, title, false);
        }

        @Override
        @NotNull
        protected JRootPane createRootPane() {
            WebDialog.WebDialogRootPane rootPane = new WebDialog.WebDialogRootPane(){
                private boolean packing = false;

                @Override
                public void validate() {
                    super.validate();
                    if (!this.packing) {
                        this.packing = true;
                        ToolBarDialog.this.pack();
                        this.packing = false;
                    }
                }
            };
            rootPane.setOpaque(true);
            return rootPane;
        }
    }
}

