/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.api.jdk.Predicate;
import com.alee.laf.tree.NodesAcceptPolicy;
import com.alee.laf.tree.TreeEventMethods;
import com.alee.laf.tree.TreeEventMethodsImpl;
import com.alee.laf.tree.TreeNodeEventRunnable;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.TreeToolTipProvider;
import com.alee.laf.tree.TreeUtils;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WTreeUI;
import com.alee.laf.tree.WebTreeModel;
import com.alee.laf.tree.WebTreeNode;
import com.alee.laf.tree.behavior.TreeHoverSelectionBehavior;
import com.alee.laf.tree.behavior.TreeSelectionExpandBehavior;
import com.alee.laf.tree.behavior.TreeSingleChildExpandBehavior;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LanguageEventMethods;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.UISettingsManager;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.Styleable;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.swing.HoverListener;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.EventMethods;
import com.alee.utils.swing.extensions.EventMethodsImpl;
import com.alee.utils.swing.extensions.FocusEventRunnable;
import com.alee.utils.swing.extensions.FontMethods;
import com.alee.utils.swing.extensions.FontMethodsImpl;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import com.alee.utils.swing.extensions.SizeMethods;
import com.alee.utils.swing.extensions.SizeMethodsImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WebTree<N extends MutableTreeNode>
extends JTree
implements Styleable,
TreeEventMethods<N>,
EventMethods,
LanguageEventMethods,
SettingsMethods,
FontMethods<WebTree<N>>,
SizeMethods<WebTree<N>> {
    public static final String DROP_LOCATION_PROPERTY = "dropLocation";
    public static final String TOOLTIP_PROVIDER_PROPERTY = "tooltipProvider";
    public static final int SINGLE_TREE_SELECTION = 1;
    public static final int CONTIGUOUS_TREE_SELECTION = 2;
    public static final int DISCONTIGUOUS_TREE_SELECTION = 4;
    @Nullable
    protected transient TreeSelectionListener scrollToSelectionListener = null;
    @Nullable
    protected transient Predicate<N> editableStateProvider = null;

    public WebTree() {
        this(StyleId.auto);
    }

    public WebTree(@NotNull Object[] data) {
        this(StyleId.auto, data);
    }

    public WebTree(@NotNull Vector<?> data) {
        this(StyleId.auto, data);
    }

    public WebTree(@NotNull Hashtable<?, ?> data) {
        this(StyleId.auto, data);
    }

    public WebTree(@Nullable N root) {
        this(StyleId.auto, root);
    }

    public WebTree(@Nullable N root, boolean asksAllowsChildren) {
        this(StyleId.auto, root, asksAllowsChildren);
    }

    public WebTree(@Nullable TreeModel newModel) {
        this(StyleId.auto, newModel);
    }

    public WebTree(@NotNull StyleId id) {
        this(id, WebTree.createDefaultTreeModel());
    }

    public WebTree(@NotNull StyleId id, @NotNull Object[] data) {
        this(id, WebTree.createTreeModel(data));
    }

    public WebTree(@NotNull StyleId id, @NotNull Vector<?> data) {
        this(id, WebTree.createTreeModel(data));
    }

    public WebTree(@NotNull StyleId id, @NotNull Hashtable<?, ?> data) {
        this(id, WebTree.createTreeModel(data));
    }

    public WebTree(@NotNull StyleId id, @Nullable N root) {
        this(id, new WebTreeModel<N>(root));
    }

    public WebTree(@NotNull StyleId id, @Nullable N root, boolean asksAllowsChildren) {
        this(id, new WebTreeModel<N>(root, asksAllowsChildren));
    }

    public WebTree(@NotNull StyleId id, @Nullable TreeModel newModel) {
        super(newModel);
        this.setStyleId(id);
    }

    @Override
    @Nullable
    public TreeModel getModel() {
        return super.getModel();
    }

    @Override
    public void setModel(@Nullable TreeModel newModel) {
        super.setModel(newModel);
    }

    @Override
    public void setCellEditor(@Nullable TreeCellEditor cellEditor) {
        if (this.cellEditor != null) {
            for (CellEditorListener listener : (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class)) {
                this.cellEditor.removeCellEditorListener(listener);
            }
        }
        super.setCellEditor(cellEditor);
        if (cellEditor != null) {
            for (CellEditorListener listener : (CellEditorListener[])this.listenerList.getListeners(CellEditorListener.class)) {
                cellEditor.addCellEditorListener(listener);
            }
        }
    }

    @Override
    @Nullable
    public String getToolTipText(@Nullable MouseEvent event) {
        String tip = null;
        if (event != null) {
            Rectangle pathBounds;
            boolean leaf;
            boolean expanded;
            boolean selected;
            TreePath path;
            Object value;
            Component renderer;
            Point point = event.getPoint();
            WTreeUI ui = this.getUI();
            int row = ui.getExactRowForLocation(point);
            TreeCellRenderer cellRenderer = this.getCellRenderer();
            if (row != -1 && cellRenderer != null && (renderer = cellRenderer.getTreeCellRendererComponent(this, value = (path = this.getPathForRow(row)).getLastPathComponent(), selected = this.isRowSelected(row), expanded = this.isExpanded((N)row), leaf = this.isLeaf((MutableTreeNode)value), row, true)) instanceof JComponent && (pathBounds = this.getPathBounds(path)) != null) {
                MouseEvent newEvent = new MouseEvent(renderer, event.getID(), event.getWhen(), event.getModifiers(), point.x - pathBounds.x, point.y - pathBounds.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), 0);
                JComponent jComponent = (JComponent)renderer;
                tip = jComponent.getToolTipText(newEvent);
            }
        }
        if (tip == null) {
            tip = this.getToolTipText();
        }
        return tip;
    }

    public void addCellEditorListener(@NotNull CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
        if (this.cellEditor != null) {
            this.cellEditor.addCellEditorListener(listener);
        }
    }

    public void removeCellEditorListener(@NotNull CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
        if (this.cellEditor != null) {
            this.cellEditor.removeCellEditorListener(listener);
        }
    }

    @Nullable
    public Predicate<N> getEditableStateProvider() {
        return this.editableStateProvider;
    }

    public void setEditableStateProvider(@Nullable Predicate<N> stateProvider) {
        this.editableStateProvider = stateProvider;
    }

    @Override
    public boolean isPathEditable(@NotNull TreePath path) {
        return super.isPathEditable(path) && this.isNodeEditable((MutableTreeNode)path.getLastPathComponent());
    }

    public boolean isNodeEditable(@NotNull N node) {
        return this.editableStateProvider == null || this.editableStateProvider.test(node);
    }

    @Nullable
    public TreeToolTipProvider<N> getToolTipProvider() {
        return (TreeToolTipProvider)this.getClientProperty(TOOLTIP_PROVIDER_PROPERTY);
    }

    public void setToolTipProvider(@Nullable TreeToolTipProvider<N> provider) {
        this.putClientProperty(TOOLTIP_PROVIDER_PROPERTY, provider);
    }

    public void expandRoot() {
        this.expandNode(this.getRootNode());
    }

    public void expandAll() {
        this.expandAllImpl(this.getRootNode(), null, Integer.MAX_VALUE);
    }

    public void expandAll(@Nullable Filter<N> filter) {
        this.expandAllImpl(this.getRootNode(), filter, Integer.MAX_VALUE);
    }

    public void expandAll(@NotNull N node) {
        this.expandAllImpl(node, null, Integer.MAX_VALUE);
    }

    public void expandAll(@NotNull N node, @Nullable Filter<N> filter) {
        this.expandAllImpl(node, filter, Integer.MAX_VALUE);
    }

    public void expandAll(int depth) {
        this.expandAllImpl(this.getRootNode(), null, depth);
    }

    public void expandAll(@Nullable Filter<N> filter, int depth) {
        this.expandAllImpl(this.getRootNode(), filter, depth);
    }

    public void expandAll(@NotNull N node, int depth) {
        this.expandAllImpl(node, null, depth);
    }

    public void expandAll(@NotNull N node, @Nullable Filter<N> filter, int depth) {
        this.expandAllImpl(node, filter, depth);
    }

    protected void expandAllImpl(@NotNull N node, @Nullable Filter<N> filter, int depth) {
        if (depth > 0 && (filter == null || filter.accept(node)) && !this.isLeaf(node)) {
            if (!this.isExpanded(node)) {
                this.expandNode(node);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.expandAllImpl((MutableTreeNode)node.getChildAt(i), filter, depth - 1);
            }
        }
    }

    public void collapseAll() {
        this.collapseAll(this.getRootNode(), null);
    }

    public void collapseAll(@Nullable Filter<N> filter) {
        this.collapseAll(this.getRootNode(), filter);
    }

    public void collapseAll(@NotNull N node) {
        this.collapseAll(node, null);
    }

    public void collapseAll(@NotNull N node, @Nullable Filter<N> filter) {
        this.collapseAllImpl(node, filter);
    }

    protected void collapseAllImpl(@NotNull N node, @Nullable Filter<N> filter) {
        if ((filter == null || filter.accept(node)) && !this.isLeaf(node)) {
            if (!this.isCollapsed(node)) {
                this.collapseNode(node);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.collapseAllImpl((MutableTreeNode)node.getChildAt(i), filter);
            }
        }
    }

    public void expandNode(@Nullable N node) {
        this.expandPath(this.getPathForNode(node));
    }

    public boolean isExpanded(@Nullable N node) {
        return this.isExpanded((N)this.getPathForNode(node));
    }

    public void collapseNode(@Nullable N node) {
        this.collapsePath(this.getPathForNode(node));
    }

    public boolean isCollapsed(@Nullable N node) {
        return this.isCollapsed((N)this.getPathForNode(node));
    }

    @Nullable
    public Rectangle getSelectedNodeBounds() {
        return this.getNodeBounds(this.getSelectedNode());
    }

    @Nullable
    public Rectangle getNodeBounds(@Nullable N node) {
        return this.getPathBounds(this.getPathForNode(node));
    }

    @Nullable
    public Rectangle getNodeBounds(@Nullable List<N> nodes) {
        Rectangle bounds = null;
        if (CollectionUtils.notEmpty(nodes)) {
            for (MutableTreeNode node : nodes) {
                bounds = GeometryUtils.getContainingRect(bounds, (Rectangle)this.getNodeBounds(node));
            }
        }
        return bounds;
    }

    public int getRowForNode(@Nullable N node) {
        return this.getRowForPath(this.getPathForNode(node));
    }

    @Nullable
    public N getNodeForRow(int row) {
        return this.getNodeForPath(this.getPathForRow(row));
    }

    @Nullable
    public TreePath getPathForNode(@Nullable N node) {
        return TreeUtils.getTreePath(node);
    }

    @Nullable
    public N getNodeForPath(@Nullable TreePath path) {
        return (N)(path != null ? (MutableTreeNode)path.getLastPathComponent() : null);
    }

    @Nullable
    public N getNodeForLocation(@NotNull Point location) {
        return this.getNodeForLocation(location.x, location.y);
    }

    @Nullable
    public N getNodeForLocation(int x, int y) {
        return this.getNodeForPath(this.getPathForLocation(x, y));
    }

    @Nullable
    public TreePath getPathForLocation(@NotNull Point location) {
        return this.getPathForLocation(location.x, location.y);
    }

    @Nullable
    public N getClosestNodeForLocation(@NotNull Point location) {
        return this.getClosestNodeForLocation(location.x, location.y);
    }

    @Nullable
    public N getClosestNodeForLocation(int x, int y) {
        return this.getNodeForPath(this.getClosestPathForLocation(x, y));
    }

    @Nullable
    public TreePath getClosestPathForLocation(@NotNull Point location) {
        return this.getClosestPathForLocation(location.x, location.y);
    }

    public boolean isSelected(@Nullable N node) {
        return this.isPathSelected(this.getPathForNode(node));
    }

    @Nullable
    public N getSelectedNode() {
        return this.getNodeForPath(this.getSelectionPath());
    }

    @NotNull
    public List<N> getSelectedNodes() {
        return this.getSelectedNodes(NodesAcceptPolicy.all);
    }

    @NotNull
    public List<N> getSelectedNodes(@NotNull NodesAcceptPolicy policy) {
        ArrayList<N> selectedNodes;
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            selectedNodes = new ArrayList(selectionPaths.length);
            for (TreePath path : selectionPaths) {
                selectedNodes.add(this.getNodeForPath(path));
            }
            policy.filter(this, selectedNodes);
        } else {
            selectedNodes = new ArrayList<N>();
        }
        return selectedNodes;
    }

    @NotNull
    public List<N> getVisibleSelectedNodes() {
        List<N> selectedNodes = this.getSelectedNodes();
        Rectangle vr = this.getVisibleRect();
        Iterator<N> iterator = selectedNodes.iterator();
        while (iterator.hasNext()) {
            MutableTreeNode node = (MutableTreeNode)iterator.next();
            Rectangle bounds = this.getNodeBounds(node);
            if (bounds != null && vr.intersects(bounds)) continue;
            iterator.remove();
        }
        return selectedNodes;
    }

    @Nullable
    public <U> U getSelectedUserObject() {
        return this.getUserObject(this.getSelectedNode());
    }

    @NotNull
    public <U> List<U> getSelectedUserObjects() {
        return this.getSelectedUserObjects(NodesAcceptPolicy.all);
    }

    @NotNull
    public <U> List<U> getSelectedUserObjects(@NotNull NodesAcceptPolicy policy) {
        List<N> selectedNodes = this.getSelectedNodes(policy);
        ArrayList<U> selectedUserObjects = new ArrayList<U>(selectedNodes.size());
        for (MutableTreeNode selectedNode : selectedNodes) {
            selectedUserObjects.add(this.getUserObject(selectedNode));
        }
        return selectedUserObjects;
    }

    @Nullable
    protected <U> U getUserObject(@Nullable N node) {
        Object selectedUserObject = node instanceof WebTreeNode ? ((WebTreeNode)node).getUserObject() : (node instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)node).getUserObject() : null);
        return (U)selectedUserObject;
    }

    public void selectNodeUnderPoint(@NotNull Point point) {
        this.selectNodeUnderPoint(point.x, point.y);
    }

    public void selectNodeUnderPoint(int x, int y) {
        this.setSelectionPath(this.getPathForLocation(x, y));
    }

    public void setSelectedNode(@Nullable N node) {
        TreePath path = this.getPathForNode(node);
        if (path != null) {
            this.setSelectionPath(path);
        }
    }

    public void setSelectedNodes(@NotNull List<N> nodes) {
        TreePath[] paths = new TreePath[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            paths[i] = this.getPathForNode((MutableTreeNode)nodes.get(i));
        }
        this.setSelectionPaths(paths);
    }

    public void setSelectedNodes(@NotNull N[] nodes) {
        TreePath[] paths = new TreePath[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            paths[i] = this.getPathForNode(nodes[i]);
        }
        this.setSelectionPaths(paths);
    }

    public boolean isLeaf(@NotNull N node) {
        TreeModel model = this.getModel();
        return model != null && model.isLeaf(node);
    }

    @Nullable
    public N getFirstVisibleLeafNode() {
        N firstVisibleLeafNode = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            N node = this.getNodeForRow(i);
            if (node == null || !this.isLeaf(node)) continue;
            firstVisibleLeafNode = node;
            break;
        }
        return firstVisibleLeafNode;
    }

    public void selectFirstVisibleLeafNode() {
        N node = this.getFirstVisibleLeafNode();
        if (node != null) {
            this.setSelectedNode(node);
        }
    }

    public void selectNextRow() {
        this.selectNextRow(true);
    }

    public void selectNextRow(boolean cycle) {
        int row = this.getLeadSelectionRow();
        if (row != -1) {
            if (row < this.getRowCount() - 1) {
                this.setSelectionRow(row + 1);
            } else if (cycle) {
                this.setSelectionRow(0);
            }
        } else {
            this.setSelectionRow(0);
        }
    }

    public void selectPreviousRow() {
        this.selectPreviousRow(true);
    }

    public void selectPreviousRow(boolean cycle) {
        int row = this.getLeadSelectionRow();
        if (row != -1) {
            if (row > 0) {
                this.setSelectionRow(row - 1);
            } else if (cycle) {
                this.setSelectionRow(this.getRowCount() - 1);
            }
        } else {
            this.setSelectionRow(this.getRowCount() - 1);
        }
    }

    @NotNull
    public N getRootNode() {
        N rootNode = this.getNullableRootNode();
        if (rootNode == null) {
            throw new RuntimeException("Tree doesn't have a root");
        }
        return rootNode;
    }

    @Nullable
    public N getNullableRootNode() {
        TreeModel model = this.getModel();
        return (N)(model != null ? (MutableTreeNode)model.getRoot() : null);
    }

    @NotNull
    public List<N> getAvailableNodes() {
        return this.getAvailableNodes(this.getRootNode(), NodesAcceptPolicy.all);
    }

    @NotNull
    public List<N> getAvailableNodes(@NotNull NodesAcceptPolicy policy) {
        return this.getAvailableNodes(this.getRootNode(), policy);
    }

    @NotNull
    public List<N> getAvailableNodes(@Nullable N parent) {
        return this.getAvailableNodes(parent, NodesAcceptPolicy.all);
    }

    @NotNull
    public List<N> getAvailableNodes(@Nullable N parent, @NotNull NodesAcceptPolicy policy) {
        ArrayList nodes = new ArrayList();
        this.collectAllNodesImpl(parent, nodes);
        policy.filter(this, nodes);
        return nodes;
    }

    protected void collectAllNodesImpl(@Nullable N parent, @NotNull List<N> nodes) {
        if (parent != null) {
            nodes.add(parent);
            for (int i = 0; i < parent.getChildCount(); ++i) {
                this.collectAllNodesImpl((MutableTreeNode)parent.getChildAt(i), nodes);
            }
        }
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public void setSelectionMode(int mode) {
        this.getSelectionModel().setSelectionMode(mode);
    }

    public boolean isMultipleSelectionAllowed() {
        return Objects.equals((Object)this.getSelectionMode(), (Object[])new Object[]{2, 4});
    }

    public void setMultipleSelectionAllowed(boolean allowed) {
        this.setSelectionMode(allowed ? 4 : 1);
    }

    public boolean isScrollToSelection() {
        return this.scrollToSelectionListener != null;
    }

    public void setScrollToSelection(boolean scroll) {
        if (scroll) {
            if (!this.isScrollToSelection()) {
                this.scrollToSelectionListener = new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        WebTree.this.scrollToSelection();
                    }
                };
                this.addTreeSelectionListener(this.scrollToSelectionListener);
            }
        } else if (this.isScrollToSelection()) {
            this.removeTreeSelectionListener(this.scrollToSelectionListener);
            this.scrollToSelectionListener = null;
        }
    }

    public void scrollToStart() {
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    public void scrollToSelection() {
        Rectangle vr;
        Rectangle bounds = this.getPathBounds(this.getSelectionPath());
        if (bounds != null && !(vr = this.getVisibleRect()).contains(bounds)) {
            bounds.y = bounds.y + bounds.height / 2 - vr.height / 2;
            if (vr.width > bounds.width) {
                bounds.x = bounds.x + bounds.width / 2 - vr.width / 2;
            }
            bounds.width = vr.width;
            bounds.height = vr.height;
            this.scrollRectToVisible(bounds);
        }
    }

    public void scrollToNode(@Nullable N node) {
        this.scrollToNode(node, false);
    }

    public void scrollToNode(@Nullable N node, boolean centered) {
        Rectangle nodeBounds;
        if (node != null && (nodeBounds = this.getNodeBounds(node)) != null) {
            if (node.getParent() != null) {
                int indent = (this.getUI().getLeftChildIndent() + this.getUI().getRightChildIndent()) * 2;
                nodeBounds.x -= indent;
                nodeBounds.width += indent;
            }
            Dimension visibleBounds = this.getVisibleRect().getSize();
            if (nodeBounds.width > visibleBounds.width) {
                nodeBounds.width = visibleBounds.width;
            }
            if (centered) {
                nodeBounds.y = nodeBounds.y + nodeBounds.height / 2 - visibleBounds.height / 2;
                nodeBounds.height = visibleBounds.height;
            }
            this.scrollRectToVisible(nodeBounds);
        }
    }

    public void startEditingSelectedNode() {
        this.startEditingNode(this.getSelectedNode());
    }

    public void startEditingNode(@Nullable N node) {
        TreePath path;
        if (node != null && (path = this.getPathForNode(node)) != null) {
            if (!this.isVisible(path)) {
                this.expandPath(path);
            }
            this.startEditingAtPath(path);
        }
    }

    public void updateNode(@Nullable N node) {
        TreeModel model = this.getModel();
        if (model instanceof WebTreeModel) {
            ((WebTreeModel)this.getModel()).updateNode(node);
        }
    }

    public void updateNodes(N ... nodes) {
        TreeModel model = this.getModel();
        if (model instanceof WebTreeModel) {
            ((WebTreeModel)model).updateNodes((MutableTreeNode[])nodes);
        }
    }

    public void updateNodes(@Nullable List<N> nodes) {
        TreeModel model = this.getModel();
        if (model instanceof WebTreeModel) {
            ((WebTreeModel)model).updateNodes(nodes);
        }
    }

    public void updateVisibleNodes() {
        int rows = this.getRowCount();
        ArrayList<N> nodes = new ArrayList<N>(rows);
        for (int i = 0; i < rows; ++i) {
            nodes.add(this.getNodeForRow(i));
        }
        this.updateNodes((List<N>)nodes);
    }

    @NotNull
    public TreeState getTreeState() {
        return TreeUtils.getTreeState(this);
    }

    @NotNull
    public TreeState getTreeState(boolean saveSelection) {
        return TreeUtils.getTreeState((JTree)this, saveSelection);
    }

    @NotNull
    public TreeState getTreeState(@Nullable N node) {
        return TreeUtils.getTreeState((JTree)this, node);
    }

    @NotNull
    public TreeState getTreeState(@Nullable N node, boolean saveSelection) {
        return TreeUtils.getTreeState(this, node, saveSelection);
    }

    public void setTreeState(@Nullable TreeState treeState) {
        TreeUtils.setTreeState(this, treeState);
    }

    public void setTreeState(@Nullable TreeState treeState, boolean restoreSelection) {
        TreeUtils.setTreeState((JTree)this, treeState, restoreSelection);
    }

    public void setTreeState(@Nullable TreeState treeState, @Nullable N node) {
        TreeUtils.setTreeState((JTree)this, treeState, node);
    }

    public void setTreeState(@Nullable TreeState treeState, @Nullable N node, boolean restoreSelection) {
        TreeUtils.setTreeState(this, treeState, node, restoreSelection);
    }

    @NotNull
    public TreeSelectionStyle getSelectionStyle() {
        return this.getUI().getSelectionStyle();
    }

    public void setSelectionStyle(@NotNull TreeSelectionStyle style) {
        this.getUI().setSelectionStyle(style);
    }

    public boolean isExpandSelected() {
        return TreeSelectionExpandBehavior.isInstalled(this);
    }

    public void setExpandSelected(boolean expand) {
        if (expand) {
            if (!this.isExpandSelected()) {
                TreeSelectionExpandBehavior.install(this);
            }
        } else if (this.isExpandSelected()) {
            TreeSelectionExpandBehavior.uninstall(this);
        }
    }

    public boolean isAutoExpandSingleChildNode() {
        return TreeSingleChildExpandBehavior.isInstalled(this);
    }

    public void setAutoExpandSingleChildNode(boolean expand) {
        if (expand) {
            if (!this.isAutoExpandSingleChildNode()) {
                TreeSingleChildExpandBehavior.install(this);
            }
        } else if (this.isAutoExpandSingleChildNode()) {
            TreeSingleChildExpandBehavior.uninstall(this);
        }
    }

    public boolean isSelectOnHover() {
        return TreeHoverSelectionBehavior.isInstalled(this);
    }

    public void setSelectOnHover(boolean select) {
        if (select) {
            if (!this.isSelectOnHover()) {
                TreeHoverSelectionBehavior.install(this);
            }
        } else if (this.isSelectOnHover()) {
            TreeHoverSelectionBehavior.uninstall(this);
        }
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return StyleId.tree;
    }

    @Override
    @NotNull
    public StyleId getStyleId() {
        return StyleManager.getStyleId(this);
    }

    @Override
    @NotNull
    public StyleId setStyleId(@NotNull StyleId id) {
        return StyleManager.setStyleId(this, id);
    }

    @Override
    @NotNull
    public StyleId resetStyleId() {
        return StyleManager.resetStyleId(this);
    }

    @Override
    @NotNull
    public Skin getSkin() {
        return StyleManager.getSkin(this);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin) {
        return StyleManager.setSkin(this, skin);
    }

    @Override
    @Nullable
    public Skin setSkin(@NotNull Skin skin, boolean recursively) {
        return StyleManager.setSkin(this, skin, recursively);
    }

    @Override
    @Nullable
    public Skin resetSkin() {
        return StyleManager.resetSkin(this);
    }

    @Override
    public void addStyleListener(@NotNull StyleListener listener) {
        StyleManager.addStyleListener(this, listener);
    }

    @Override
    public void removeStyleListener(@NotNull StyleListener listener) {
        StyleManager.removeStyleListener(this, listener);
    }

    @Override
    @Nullable
    public Painter getCustomPainter() {
        return StyleManager.getCustomPainter(this);
    }

    @Override
    @Nullable
    public Painter setCustomPainter(@NotNull Painter painter) {
        return StyleManager.setCustomPainter(this, painter);
    }

    @Override
    public boolean resetCustomPainter() {
        return StyleManager.resetCustomPainter(this);
    }

    @Override
    @NotNull
    public Shape getPainterShape() {
        return PainterSupport.getShape(this);
    }

    @Override
    public boolean isShapeDetectionEnabled() {
        return PainterSupport.isShapeDetectionEnabled(this);
    }

    @Override
    public void setShapeDetectionEnabled(boolean enabled) {
        PainterSupport.setShapeDetectionEnabled(this, enabled);
    }

    @Override
    @Nullable
    public Insets getMargin() {
        return PainterSupport.getMargin(this);
    }

    @Override
    public void setMargin(int margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    public void setMargin(int top, int left, int bottom, int right) {
        PainterSupport.setMargin(this, top, left, bottom, right);
    }

    @Override
    public void setMargin(@Nullable Insets margin) {
        PainterSupport.setMargin((JComponent)this, margin);
    }

    @Override
    @Nullable
    public Insets getPadding() {
        return PainterSupport.getPadding(this);
    }

    @Override
    public void setPadding(int padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    @Override
    public void setPadding(int top, int left, int bottom, int right) {
        PainterSupport.setPadding(this, top, left, bottom, right);
    }

    @Override
    public void setPadding(@Nullable Insets padding) {
        PainterSupport.setPadding((JComponent)this, padding);
    }

    public void addHoverListener(@NotNull HoverListener<N> listener) {
        this.listenerList.add(HoverListener.class, listener);
    }

    public void removeHoverListener(@NotNull HoverListener<N> listener) {
        this.listenerList.remove(HoverListener.class, listener);
    }

    @NotNull
    public HoverListener[] getHoverListeners() {
        return (HoverListener[])this.listenerList.getListeners(HoverListener.class);
    }

    public void fireHoverChanged(@Nullable N previous, @Nullable N current) {
        for (HoverListener listener : this.getHoverListeners()) {
            listener.hoverChanged(previous, current);
        }
    }

    @Override
    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        int increment = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        if (orientation == 1 && direction < 0) {
            Insets i = this.getInsets();
            if (visibleRect.y - increment == i.top) {
                increment += i.top;
            }
        }
        return increment;
    }

    public void repaint(int row) {
        this.repaint((N)this.getUI().getRowBounds(row));
    }

    public void repaint(int from, int to) {
        Rectangle toBounds;
        WTreeUI ui = this.getUI();
        Rectangle fromBounds = ui.getRowBounds(from);
        Rectangle rect = GeometryUtils.getContainingRect((Rectangle)fromBounds, (Rectangle)(toBounds = ui.getRowBounds(to)));
        if (rect != null) {
            this.repaint((N)rect);
        }
    }

    public void repaint(@Nullable N node) {
        Rectangle bounds;
        if (node != null && (bounds = this.getNodeBounds(node)) != null) {
            this.repaint((N)bounds);
        }
    }

    public void repaint(@Nullable List<N> nodes) {
        if (CollectionUtils.notEmpty(nodes)) {
            Rectangle summ = null;
            for (MutableTreeNode node : nodes) {
                summ = GeometryUtils.getContainingRect(summ, (Rectangle)this.getNodeBounds(node));
            }
            if (summ != null) {
                this.repaint((N)summ);
            }
        }
    }

    @Override
    public MouseAdapter onNodeDoubleClick(@NotNull TreeNodeEventRunnable<N> runnable) {
        return TreeEventMethodsImpl.onNodeDoubleClick(this, runnable);
    }

    @Override
    public MouseAdapter onNodeDoubleClick(@Nullable Predicate<N> condition, @NotNull TreeNodeEventRunnable<N> runnable) {
        return TreeEventMethodsImpl.onNodeDoubleClick(this, condition, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMousePress(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseEnter(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseEnter(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseExit(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseExit(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseDrag(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMouseClick(@Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDoubleClick(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDoubleClick(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onMenuTrigger(@NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMenuTrigger(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyType(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyPress(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, runnable);
    }

    @Override
    @NotNull
    public KeyAdapter onKeyRelease(@Nullable HotkeyData hotkey, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusGain(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusGain(this, runnable);
    }

    @Override
    @NotNull
    public FocusAdapter onFocusLoss(@NotNull FocusEventRunnable runnable) {
        return EventMethodsImpl.onFocusLoss(this, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, runnable);
    }

    @Override
    @NotNull
    public MouseAdapter onDragStart(int shift, @Nullable MouseButton mouseButton, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(this, shift, mouseButton, runnable);
    }

    @Override
    public void addLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.addLanguageListener(this, listener);
    }

    @Override
    public void removeLanguageListener(@NotNull LanguageListener listener) {
        UILanguageManager.removeLanguageListener(this, listener);
    }

    @Override
    public void removeLanguageListeners() {
        UILanguageManager.removeLanguageListeners(this);
    }

    @Override
    public void addDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.addDictionaryListener(this, listener);
    }

    @Override
    public void removeDictionaryListener(@NotNull DictionaryListener listener) {
        UILanguageManager.removeDictionaryListener(this, listener);
    }

    @Override
    public void removeDictionaryListeners() {
        UILanguageManager.removeDictionaryListeners(this);
    }

    @Override
    public void registerSettings(Configuration configuration) {
        UISettingsManager.registerComponent((JComponent)this, configuration);
    }

    @Override
    public void registerSettings(SettingsProcessor processor) {
        UISettingsManager.registerComponent((JComponent)this, processor);
    }

    @Override
    public void unregisterSettings() {
        UISettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        UISettingsManager.loadSettings(this);
    }

    @Override
    public void saveSettings() {
        UISettingsManager.saveSettings(this);
    }

    @Override
    public WebTree<N> setPlainFont() {
        return (WebTree)FontMethodsImpl.setPlainFont(this);
    }

    @Override
    public WebTree<N> setPlainFont(boolean apply) {
        return (WebTree)FontMethodsImpl.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return FontMethodsImpl.isPlainFont(this);
    }

    @Override
    public WebTree<N> setBoldFont() {
        return (WebTree)FontMethodsImpl.setBoldFont(this);
    }

    @Override
    public WebTree<N> setBoldFont(boolean apply) {
        return (WebTree)FontMethodsImpl.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return FontMethodsImpl.isBoldFont(this);
    }

    @Override
    public WebTree<N> setItalicFont() {
        return (WebTree)FontMethodsImpl.setItalicFont(this);
    }

    @Override
    public WebTree<N> setItalicFont(boolean apply) {
        return (WebTree)FontMethodsImpl.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return FontMethodsImpl.isItalicFont(this);
    }

    @Override
    public WebTree<N> setFontStyle(boolean bold, boolean italic) {
        return (WebTree)FontMethodsImpl.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTree<N> setFontStyle(int style) {
        return (WebTree)FontMethodsImpl.setFontStyle(this, style);
    }

    @Override
    public WebTree<N> setFontSize(int fontSize) {
        return (WebTree)FontMethodsImpl.setFontSize(this, fontSize);
    }

    @Override
    public WebTree<N> changeFontSize(int change) {
        return (WebTree)FontMethodsImpl.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return FontMethodsImpl.getFontSize(this);
    }

    @Override
    public WebTree<N> setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return (WebTree)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTree<N> setFontSizeAndStyle(int fontSize, int style) {
        return (WebTree)FontMethodsImpl.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTree<N> setFontName(String fontName) {
        return (WebTree)FontMethodsImpl.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return FontMethodsImpl.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeMethodsImpl.getPreferredWidth(this);
    }

    @Override
    @NotNull
    public WebTree<N> setPreferredWidth(int preferredWidth) {
        return (WebTree)SizeMethodsImpl.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeMethodsImpl.getPreferredHeight(this);
    }

    @Override
    @NotNull
    public WebTree<N> setPreferredHeight(int preferredHeight) {
        return (WebTree)SizeMethodsImpl.setPreferredHeight(this, preferredHeight);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SizeMethodsImpl.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalPreferredSize() {
        return SizeMethodsImpl.getOriginalPreferredSize(this, super.getPreferredSize());
    }

    @Override
    @NotNull
    public WebTree<N> setPreferredSize(int width, int height) {
        return (WebTree)SizeMethodsImpl.setPreferredSize(this, width, height);
    }

    @Override
    public int getMaximumWidth() {
        return SizeMethodsImpl.getMaximumWidth(this);
    }

    @Override
    @NotNull
    public WebTree<N> setMaximumWidth(int maximumWidth) {
        return (WebTree)SizeMethodsImpl.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeMethodsImpl.getMaximumHeight(this);
    }

    @Override
    @NotNull
    public WebTree<N> setMaximumHeight(int maximumHeight) {
        return (WebTree)SizeMethodsImpl.setMaximumHeight(this, maximumHeight);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return SizeMethodsImpl.getMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMaximumSize() {
        return SizeMethodsImpl.getOriginalMaximumSize(this, super.getMaximumSize());
    }

    @Override
    @NotNull
    public WebTree<N> setMaximumSize(int width, int height) {
        return (WebTree)SizeMethodsImpl.setMaximumSize(this, width, height);
    }

    @Override
    public int getMinimumWidth() {
        return SizeMethodsImpl.getMinimumWidth(this);
    }

    @Override
    @NotNull
    public WebTree<N> setMinimumWidth(int minimumWidth) {
        return (WebTree)SizeMethodsImpl.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeMethodsImpl.getMinimumHeight(this);
    }

    @Override
    @NotNull
    public WebTree<N> setMinimumHeight(int minimumHeight) {
        return (WebTree)SizeMethodsImpl.setMinimumHeight(this, minimumHeight);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return SizeMethodsImpl.getMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public Dimension getOriginalMinimumSize() {
        return SizeMethodsImpl.getOriginalMinimumSize(this, super.getMinimumSize());
    }

    @Override
    @NotNull
    public WebTree<N> setMinimumSize(int width, int height) {
        return (WebTree)SizeMethodsImpl.setMinimumSize(this, width, height);
    }

    @Override
    public WTreeUI getUI() {
        return (WTreeUI)super.getUI();
    }

    public void setUI(WTreeUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        StyleManager.getDescriptor(this).updateUI(this);
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return StyleManager.getDescriptor(this).getUIClassId();
    }

    @NotNull
    protected static TreeModel createTreeModel(@NotNull Object data) {
        DefaultMutableTreeNode root;
        if (data instanceof Object[] || data instanceof Hashtable || data instanceof Vector) {
            root = new DefaultMutableTreeNode("root");
            JTree.DynamicUtilTreeNode.createChildren(root, data);
        } else {
            root = new JTree.DynamicUtilTreeNode((Object)"root", data);
        }
        return new WebTreeModel<DefaultMutableTreeNode>(root, false);
    }

    @NotNull
    public static TreeModel createDefaultTreeModel() {
        UniqueNode root = new UniqueNode("JTree");
        UniqueNode parent = new UniqueNode("colors");
        parent.add(new UniqueNode("blue"));
        parent.add(new UniqueNode("violet"));
        parent.add(new UniqueNode("red"));
        parent.add(new UniqueNode("yellow"));
        root.add(parent);
        parent = new UniqueNode("sports");
        parent.add(new UniqueNode("basketball"));
        parent.add(new UniqueNode("soccer"));
        parent.add(new UniqueNode("football"));
        parent.add(new UniqueNode("hockey"));
        root.add(parent);
        parent = new UniqueNode("food");
        parent.add(new UniqueNode("hot dogs"));
        parent.add(new UniqueNode("pizza"));
        parent.add(new UniqueNode("ravioli"));
        parent.add(new UniqueNode("bananas"));
        root.add(parent);
        return new WebTreeModel(root);
    }
}

