/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.tree.WebCheckBoxTree;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.ITreePainter;
import com.alee.laf.tree.TreeCellArea;
import com.alee.laf.tree.TreePaintParameters;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.TreeToolTipProvider;
import com.alee.laf.tree.WTreeUI;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.laf.tree.WebTreeCellRenderer;
import com.alee.laf.tree.behavior.TreePathHoverBehavior;
import com.alee.managers.icon.Icons;
import com.alee.managers.style.StyleManager;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class WebTreeUI
extends WTreeUI {
    protected TreeSelectionStyle selectionStyle;
    protected transient TreePathHoverBehavior hoverNodeTracker;
    protected transient int hoverRow = -1;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebTreeUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        if (!WebLookAndFeel.isInstalled()) {
            this.setRightChildIndent(12);
            this.setLeftChildIndent(12);
        }
        this.tree.setRowHeight(-1);
        this.tree.setDropMode(DropMode.ON);
        this.tree.setVisibleRowCount(10);
        this.tree.setInvokesStopCellEditing(true);
        this.hoverNodeTracker = new TreePathHoverBehavior<JTree>(this.tree, true){

            @Override
            public void hoverChanged(@Nullable TreePath previous, @Nullable TreePath current) {
                TreeToolTipProvider provider;
                int previousRow = WebTreeUI.this.hoverRow;
                WebTreeUI.this.hoverRow = current != null ? WebTreeUI.this.tree.getRowForPath(current) : -1;
                Painter painter = PainterSupport.getPainter(WebTreeUI.this.tree);
                if (painter instanceof ITreePainter && ((ITreePainter)painter).isRowHoverDecorationSupported()) {
                    this.repaintRow(previousRow);
                    this.repaintRow(WebTreeUI.this.hoverRow);
                }
                if ((provider = WebTreeUI.this.getToolTipProvider()) != null) {
                    provider.hoverAreaChanged(WebTreeUI.this.tree, previousRow != -1 ? new TreeCellArea(previousRow) : null, WebTreeUI.this.hoverRow != -1 ? new TreeCellArea(WebTreeUI.this.hoverRow) : null);
                }
                if (WebTreeUI.this.tree instanceof WebTree) {
                    MutableTreeNode p = previous != null ? (MutableTreeNode)previous.getLastPathComponent() : null;
                    MutableTreeNode c = current != null ? (MutableTreeNode)current.getLastPathComponent() : null;
                    ((WebTree)WebTreeUI.this.tree).fireHoverChanged(p, c);
                }
            }

            private void repaintRow(int row) {
                if (0 <= row && row < WebTreeUI.this.tree.getRowCount()) {
                    WebTreeUI.this.tree.repaint(WebTreeUI.this.getRowBounds(row, true));
                }
            }
        };
        this.hoverNodeTracker.install();
        StyleManager.installSkin(this.tree);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.tree);
        this.hoverNodeTracker.uninstall();
        this.hoverNodeTracker = null;
        super.uninstallUI(c);
    }

    @Override
    public int getHoverRow() {
        return this.hoverRow;
    }

    @Override
    public int getExactRowForLocation(@NotNull Point location) {
        return this.getExactRowForLocation(location, this.isFullLineSelection());
    }

    @Override
    public int getExactRowForLocation(@NotNull Point location, boolean fullRow) {
        Enumeration<TreePath> visiblePaths;
        int row = -1;
        if (this.tree != null && (visiblePaths = this.getVisiblePaths()) != null) {
            while (visiblePaths.hasMoreElements()) {
                TreePath treePath = visiblePaths.nextElement();
                Rectangle bounds = this.getPathBounds(treePath, fullRow);
                if (bounds == null || !bounds.contains(location)) continue;
                row = this.getRowForPath(this.tree, treePath);
                break;
            }
        }
        return row;
    }

    @Override
    @NotNull
    public Rectangle getRowBounds(int row) {
        return this.getRowBounds(row, this.isFullLineSelection());
    }

    @Override
    @NotNull
    public Rectangle getRowBounds(int row, boolean fullRow) {
        Rectangle rowBounds;
        TreePath path = this.getPathForRow(this.tree, row);
        Rectangle rectangle = rowBounds = fullRow ? this.getFullPathBounds(path) : this.getPathBounds(this.tree, path);
        if (rowBounds == null) {
            throw new RuntimeException("Unable to retrieve row bounds: " + row);
        }
        return rowBounds;
    }

    @Nullable
    public Rectangle getPathBounds(@Nullable TreePath path, boolean fullRow) {
        return fullRow ? this.getFullPathBounds(path) : this.getPathBounds(this.tree, path);
    }

    @Nullable
    private Rectangle getFullPathBounds(@Nullable TreePath path) {
        Rectangle b = this.getPathBounds(this.tree, path);
        if (b != null) {
            Insets insets = this.tree.getInsets();
            b.x = insets.left;
            b.width = this.tree.getWidth() - insets.left - insets.right;
        }
        return b;
    }

    @Nullable
    public Enumeration<TreePath> getVisiblePaths() {
        Enumeration<TreePath> result;
        if (this.tree.isShowing()) {
            Rectangle paintBounds = this.tree.getVisibleRect();
            TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
            result = initialPath != null ? this.treeState.getVisiblePathsFrom(initialPath) : null;
        } else {
            result = null;
        }
        return result;
    }

    @Override
    @NotNull
    protected TreeCellEditor createDefaultCellEditor() {
        return new WebTreeCellEditor();
    }

    @Override
    @NotNull
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new WebTreeCellRenderer.UIResource();
    }

    @Override
    protected void selectPathForEvent(@NotNull TreePath path, MouseEvent e) {
        if (!this.isLocationInCheckBoxControl(path, e.getX(), e.getY())) {
            super.selectPathForEvent(path, e);
        }
    }

    @Override
    public boolean isLocationInCheckBoxControl(@NotNull TreePath path, int x, int y) {
        Rectangle checkBoxBounds;
        MutableTreeNode node;
        WebCheckBoxTree checkBoxTree;
        boolean inCheckBox = this.tree instanceof WebCheckBoxTree ? ((checkBoxTree = (WebCheckBoxTree)this.tree).isCheckingByUserEnabled() ? (checkBoxTree.isCheckBoxVisible(node = (MutableTreeNode)path.getLastPathComponent()) && checkBoxTree.isCheckBoxEnabled(node) ? (checkBoxBounds = checkBoxTree.getCheckBoxBounds(path)) != null && checkBoxBounds.contains(x, y) : false) : false) : false;
        return inCheckBox;
    }

    @Override
    @NotNull
    public Icon getExpandedIcon() {
        return this.tree.isEnabled() ? Icons.squareMinus : Icons.squareMinusDisabled;
    }

    @Override
    @NotNull
    public Icon getCollapsedIcon() {
        return this.tree.isEnabled() ? Icons.squarePlus : Icons.squarePlusDisabled;
    }

    @Override
    @NotNull
    public CellRendererPane getCellRendererPane() {
        return this.rendererPane;
    }

    @Override
    @Nullable
    public AbstractLayoutCache getTreeLayoutCache() {
        return this.treeState;
    }

    @Override
    @NotNull
    public TreeSelectionStyle getSelectionStyle() {
        return this.selectionStyle;
    }

    @Override
    public void setSelectionStyle(@NotNull TreeSelectionStyle style) {
        this.selectionStyle = style;
    }

    protected boolean isFullLineSelection() {
        return this.selectionStyle == TreeSelectionStyle.line;
    }

    @Nullable
    protected TreeToolTipProvider getToolTipProvider() {
        return this.tree != null ? (TreeToolTipProvider)this.tree.getClientProperty("tooltipProvider") : null;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this, new TreePaintParameters(this.currentCellRenderer));
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c));
    }
}

