/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.easing;

import com.alee.managers.animation.easing.AbstractEasing;
import com.thoughtworks.xstream.annotations.XStreamAlias;

public abstract class Circular
extends AbstractEasing {
    @Override
    public String getTitle() {
        return "Circular";
    }

    @XStreamAlias(value="Circular$InOut")
    public static final class InOut
    extends Circular {
        @Override
        public String getTitle() {
            return super.getTitle() + " InOut";
        }

        @Override
        protected double calculateImpl(double start, double distance, double current, double total) {
            if ((current /= total / 2.0) < 1.0) {
                return -distance / 2.0 * (Math.sqrt(1.0 - current * current) - 1.0) + start;
            }
            return distance / 2.0 * (Math.sqrt(1.0 - (current -= 2.0) * current) + 1.0) + start;
        }
    }

    @XStreamAlias(value="Circular$Out")
    public static final class Out
    extends Circular {
        @Override
        public String getTitle() {
            return super.getTitle() + " Out";
        }

        @Override
        protected double calculateImpl(double start, double distance, double current, double total) {
            current /= total;
            return distance * Math.sqrt(1.0 - (current -= 1.0) * current) + start;
        }
    }

    @XStreamAlias(value="Circular$In")
    public static final class In
    extends Circular {
        @Override
        public String getTitle() {
            return super.getTitle() + " In";
        }

        @Override
        protected double calculateImpl(double start, double distance, double current, double total) {
            return -distance * (Math.sqrt(1.0 - (current /= total) * current) - 1.0) + start;
        }
    }
}

