/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.easing;

import com.alee.api.annotations.NotNull;
import com.alee.extended.canvas.WebCanvas;
import com.alee.graphics.data.Line;
import com.alee.managers.animation.easing.Easing;
import com.alee.managers.animation.easing.Linear;
import com.alee.managers.animation.transition.AbstractTransition;
import com.alee.managers.animation.transition.TimedTransition;
import com.alee.managers.animation.transition.Transition;
import com.alee.managers.animation.transition.TransitionAdapter;
import com.alee.managers.animation.transition.TransitionListener;
import com.alee.painter.decoration.content.TextRasterization;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EasingViewer
extends WebCanvas {
    protected final DecimalFormat progressFormat = new DecimalFormat("0.00");
    protected final Insets padding = new Insets(55, 55, 55, 55);
    protected final int steps;
    protected int progress = this.steps = 500;
    protected Easing easing = null;
    protected long duration = 0L;
    protected AbstractTransition<Integer> transition;
    protected List<TransitionListener<Integer>> listeners = new ArrayList<TransitionListener<Integer>>();

    public EasingViewer() {
        this.onMousePress(MouseButton.left, new MouseEventRunnable(){

            @Override
            public void run(@NotNull MouseEvent e) {
                EasingViewer.this.preview(EasingViewer.this.easing, EasingViewer.this.duration);
            }
        });
    }

    public int getSteps() {
        return this.steps;
    }

    public int getProgress() {
        return this.progress;
    }

    public double getEasedProgress() {
        return this.easing.calculate(0.0, 1.0, (double)this.progress / (double)this.steps, 1.0);
    }

    public void addListener(TransitionListener<Integer> listener) {
        this.listeners.add(listener);
    }

    public void preview(Easing easing, long duration) {
        this.easing = easing;
        this.duration = duration;
        this.restartTransition();
    }

    protected void restartTransition() {
        if (this.transition != null) {
            this.transition.stop();
            this.transition = null;
        }
        this.progress = 0;
        this.transition = new TimedTransition<Integer>(0, this.steps, new Linear(), this.duration);
        this.transition.addListener((TransitionListener<Integer>)new TransitionAdapter<Integer>(){

            @Override
            public void adjusted(Transition transition, Integer value) {
                EasingViewer.this.progress = value;
                EasingViewer.this.repaint();
                for (TransitionListener<Integer> listener : EasingViewer.this.listeners) {
                    listener.adjusted(transition, value);
                }
            }
        });
        this.transition.play();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.easing != null) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle graph = new Rectangle(this.padding.left, this.padding.top, this.getWidth() - this.padding.left - this.padding.right * 2, this.getHeight() - this.padding.top - this.padding.bottom * 2);
            double eased = this.getEasedProgress();
            int x = graph.width * this.progress / this.steps;
            int y = graph.y + graph.height - (int)Math.ceil((double)graph.height * eased);
            Point point = new Point(graph.x + x, y);
            this.paintGraph(g2d, graph, point);
            this.paintProgress(g2d, new Line(graph.x, graph.y + graph.height + this.padding.bottom, graph.x + graph.width, graph.y + graph.height + this.padding.bottom), point);
            this.paintValue(g2d, new Line(graph.x + graph.width + this.padding.right, graph.y, graph.x + graph.width + this.padding.right, graph.y + graph.height), point, eased);
        }
    }

    protected void paintGraph(Graphics2D g2d, Rectangle bounds, Point point) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        g2d.setPaint(new Color(240, 240, 240));
        g2d.fill(bounds);
        if (!(this.easing instanceof Linear)) {
            g2d.setPaint(Color.LIGHT_GRAY);
            g2d.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y);
        }
        if (this.progress < this.steps) {
            g2d.setPaint(Color.WHITE);
            g2d.drawLine(point.x, bounds.y, point.x, bounds.y + bounds.height);
            g2d.drawLine(bounds.x, point.y, bounds.x + bounds.width, point.y);
        }
        GeneralPath done = new GeneralPath(0);
        GeneralPath todo = new GeneralPath(0);
        for (int i = 0; i <= this.steps; ++i) {
            double current = (double)i / (double)this.steps;
            double eased = this.easing.calculate(0.0, 1.0, current, 1.0);
            double x = (double)bounds.x + (double)bounds.width * current;
            double y = (double)(bounds.y + bounds.height) - (double)bounds.height * eased;
            if (i < this.progress || this.progress == this.steps) {
                if (i == 0) {
                    done.moveTo(x, y);
                    continue;
                }
                done.lineTo(x, y);
                continue;
            }
            if (i == this.progress) {
                if (this.progress > 0) {
                    done.lineTo(x, y);
                }
                todo.moveTo(x, y);
                continue;
            }
            todo.lineTo(x, y);
        }
        Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)new BasicStroke(1.7f));
        if (this.progress < this.steps) {
            g2d.setPaint(Color.LIGHT_GRAY);
            g2d.draw(todo);
        }
        if (this.progress > 0) {
            g2d.setPaint(Color.BLACK);
            g2d.draw(done);
        }
        GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        if (this.progress == this.steps) {
            Map taa = SwingUtils.setupTextAntialias(g2d, TextRasterization.subpixel);
            FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
            String middleText = "Click to replay";
            g2d.setPaint(Color.LIGHT_GRAY);
            g2d.drawString("Click to replay", bounds.x + bounds.width / 2 - fm.stringWidth("Click to replay") / 2, bounds.y + bounds.height - 10);
            SwingUtils.restoreTextAntialias(g2d, taa);
        }
    }

    private void paintProgress(Graphics2D g2d, Line bounds, Point point) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)new BasicStroke(2.0f));
        g2d.setPaint(Color.LIGHT_GRAY);
        g2d.drawLine(bounds.x1, bounds.y1, bounds.x2, bounds.y2);
        g2d.setPaint(Color.BLACK);
        g2d.drawLine(bounds.x1, bounds.y1, point.x, bounds.y2);
        GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        Map taa = SwingUtils.setupTextAntialias(g2d, TextRasterization.subpixel);
        FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
        int th = fm.getAscent() - fm.getLeading() - fm.getDescent();
        int mid = (bounds.x1 + bounds.x2) / 2;
        g2d.setPaint(Color.BLACK);
        String overBar = "Progress";
        g2d.drawString("Progress", mid - fm.stringWidth("Progress") / 2, bounds.y1 - 10);
        String belowBar = this.progressFormat.format((double)this.progress / (double)this.steps);
        g2d.drawString(belowBar, mid - fm.stringWidth(belowBar) / 2, bounds.y1 + 10 + th);
        String afterBar = this.duration * (long)this.progress / (long)this.steps + " ms";
        g2d.setPaint(Color.BLACK);
        g2d.drawString(afterBar, bounds.x2 + this.padding.right - fm.stringWidth(afterBar) / 2, bounds.y1 + th / 2);
        SwingUtils.restoreTextAntialias(g2d, taa);
    }

    private void paintValue(Graphics2D g2d, Line bounds, Point point, double eased) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Stroke os = GraphicsUtils.setupStroke((Graphics2D)g2d, (Stroke)new BasicStroke(2.0f));
        g2d.setPaint(Color.LIGHT_GRAY);
        g2d.drawLine(bounds.x1, bounds.y2, bounds.x2, bounds.y1);
        g2d.setPaint(new Color(77, 135, 31));
        g2d.drawLine(bounds.x1, bounds.y2, bounds.x2, point.y);
        g2d.fillOval(bounds.x2 - 6, point.y - 6, 13, 13);
        GraphicsUtils.restoreStroke((Graphics2D)g2d, (Stroke)os);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
        Map taa = SwingUtils.setupTextAntialias(g2d, TextRasterization.subpixel);
        FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
        int th = fm.getAscent() - fm.getLeading() - fm.getDescent();
        String beforeBar = "Value";
        Point bbp = new Point(bounds.x1 - 10, (bounds.y1 + bounds.y2) / 2 + fm.stringWidth("Value") / 2);
        g2d.setPaint(Color.BLACK);
        g2d.rotate(-1.5707963267948966, bbp.x, bbp.y);
        g2d.drawString("Value", bbp.x, bbp.y);
        g2d.rotate(1.5707963267948966, bbp.x, bbp.y);
        String afterBar = this.progressFormat.format(eased);
        Point abp = new Point(bounds.x1 + 10 + th, (bounds.y1 + bounds.y2) / 2 + fm.stringWidth(afterBar) / 2);
        g2d.setPaint(Color.BLACK);
        g2d.rotate(-1.5707963267948966, abp.x, abp.y);
        g2d.drawString(afterBar, abp.x, abp.y);
        g2d.rotate(1.5707963267948966, abp.x, abp.y);
        SwingUtils.restoreTextAntialias(g2d, taa);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(450, 450);
    }
}

