/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.easing;

import com.alee.managers.animation.easing.AbstractEasing;
import com.thoughtworks.xstream.annotations.XStreamAlias;

public abstract class Elastic
extends AbstractEasing {
    @Override
    public String getTitle() {
        return "Elastic";
    }

    @XStreamAlias(value="Elastic$InOut")
    public static final class InOut
    extends Elastic {
        @Override
        public String getTitle() {
            return super.getTitle() + " InOut";
        }

        @Override
        protected double calculateImpl(double start, double distance, double current, double total) {
            double s;
            double a = distance;
            if (current == 0.0) {
                return start;
            }
            if ((current /= total / 2.0) == 2.0) {
                return start + distance;
            }
            double p = total * 0.44999999999999996;
            if (a < Math.abs(distance)) {
                a = distance;
                s = p / 4.0;
            } else {
                s = p / (Math.PI * 2) * Math.asin(distance / a);
            }
            if (current < 1.0) {
                return -0.5 * (a * Math.pow(2.0, 10.0 * (current -= 1.0)) * Math.sin((current * total - s) * (Math.PI * 2) / p)) + start;
            }
            return a * Math.pow(2.0, -10.0 * (current -= 1.0)) * Math.sin((current * total - s) * (Math.PI * 2) / p) * 0.5 + distance + start;
        }
    }

    @XStreamAlias(value="Elastic$Out")
    public static final class Out
    extends Elastic {
        @Override
        public String getTitle() {
            return super.getTitle() + " Out";
        }

        @Override
        protected double calculateImpl(double start, double distance, double current, double total) {
            double s;
            double a = distance;
            if (current == 0.0) {
                return start;
            }
            if ((current /= total) == 1.0) {
                return start + distance;
            }
            double p = total * 0.3;
            if (a < Math.abs(distance)) {
                a = distance;
                s = p / 4.0;
            } else {
                s = p / (Math.PI * 2) * Math.asin(distance / a);
            }
            return a * Math.pow(2.0, -10.0 * current) * Math.sin((current * total - s) * (Math.PI * 2) / p) + distance + start;
        }
    }

    @XStreamAlias(value="Elastic$In")
    public static final class In
    extends Elastic {
        @Override
        public String getTitle() {
            return super.getTitle() + " In";
        }

        @Override
        protected double calculateImpl(double start, double distance, double current, double total) {
            double s;
            double a = distance;
            if (current == 0.0) {
                return start;
            }
            if ((current /= total) == 1.0) {
                return start + distance;
            }
            double p = total * 0.3;
            if (a < Math.abs(distance)) {
                a = distance;
                s = p / 4.0;
            } else {
                s = p / (Math.PI * 2) * Math.asin(distance / a);
            }
            return -(a * Math.pow(2.0, 10.0 * (current -= 1.0)) * Math.sin((current * total - s) * (Math.PI * 2) / p)) + start;
        }
    }
}

