/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.easing;

import com.alee.managers.animation.easing.AbstractEasing;
import com.thoughtworks.xstream.annotations.XStreamAlias;

public abstract class Sinusoidal
extends AbstractEasing {
    @Override
    public String getTitle() {
        return "Sinusoidal";
    }

    @XStreamAlias(value="Sinusoidal$InOut")
    public static final class InOut
    extends Sinusoidal {
        @Override
        public String getTitle() {
            return super.getTitle() + " InOut";
        }

        @Override
        protected double calculateImpl(double start, double distance, double current, double total) {
            return -distance / 2.0 * (Math.cos(Math.PI * current / total) - 1.0) + start;
        }
    }

    @XStreamAlias(value="Sinusoidal$Out")
    public static final class Out
    extends Sinusoidal {
        @Override
        public String getTitle() {
            return super.getTitle() + " Out";
        }

        @Override
        protected double calculateImpl(double start, double distance, double current, double total) {
            return distance * Math.sin(current / total * 1.5707963267948966) + start;
        }
    }

    @XStreamAlias(value="Sinusoidal$In")
    public static final class In
    extends Sinusoidal {
        @Override
        public String getTitle() {
            return super.getTitle() + " In";
        }

        @Override
        protected double calculateImpl(double start, double distance, double current, double total) {
            return -distance * Math.cos(current / total * 1.5707963267948966) + distance + start;
        }
    }
}

