/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.transition;

import com.alee.api.annotations.NotNull;
import com.alee.managers.animation.AnimationException;
import com.alee.managers.animation.framerate.FrameRate;
import com.alee.managers.animation.transition.AbstractTransition;
import com.alee.managers.animation.transition.Transition;
import com.alee.managers.animation.transition.TransitionState;
import com.alee.utils.CollectionUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;

public class QueueTransition<V>
extends AbstractTransition<V> {
    protected boolean looped;
    protected final List<Transition<V>> elements;
    protected final Object elementsLock;
    protected Queue<Transition<V>> queue;

    public QueueTransition(Transition<V> ... transitions) {
        this(false, transitions);
    }

    public QueueTransition(List<Transition<V>> transitions) {
        this(false, transitions);
    }

    public QueueTransition(boolean looped, Transition<V> ... transitions) {
        this(looped, CollectionUtils.asList((Object[])transitions));
    }

    public QueueTransition(boolean looped, List<Transition<V>> transitions) {
        this.looped = looped;
        this.elements = new ArrayList<Transition<V>>(transitions.size());
        this.elementsLock = new Object();
        this.add(transitions);
    }

    @Override
    public void setFrameRate(FrameRate frameRate) {
        super.setFrameRate(new QueueFrameRate());
    }

    public boolean isLooped() {
        return this.looped;
    }

    public void setLooped(boolean looped) {
        this.looped = looped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Transition<V> ... transitions) {
        Object object = this.elementsLock;
        synchronized (object) {
            Collections.addAll(this.elements, transitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(List<Transition<V>> transitions) {
        Object object = this.elementsLock;
        synchronized (object) {
            this.elements.addAll(transitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.elementsLock;
        synchronized (object) {
            this.elements.clear();
        }
    }

    @Override
    public FrameRate getFrameRate() {
        return this.frameRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStartTime() {
        QueueTransition queueTransition = this;
        synchronized (queueTransition) {
            switch (this.getState()) {
                case playing: {
                    return this.queue.element().getStartTime();
                }
                case finished: {
                    return this.getLastTransition().getStartTime();
                }
            }
            return this.getFirstTransition().getStartTime();
        }
    }

    @Override
    public V getStart() {
        return this.getFirstTransition().getStart();
    }

    @Override
    public V getGoal() {
        return this.getLastTransition().getGoal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long start(long currentFrame) {
        QueueTransition queueTransition = this;
        synchronized (queueTransition) {
            this.reset();
            long untilNextFrame = this.queue.element().start(currentFrame);
            this.setState(TransitionState.playing);
            return untilNextFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long proceed(long previousFrame, long currentFrame) {
        QueueTransition queueTransition = this;
        synchronized (queueTransition) {
            if (this.getState() == TransitionState.playing) {
                Transition<V> current = this.queue.element();
                long untilNextFrame = current.proceed(previousFrame, currentFrame);
                this.fireAdjusted(this.getValue());
                if (untilNextFrame <= 0L) {
                    long adjustedFrame = currentFrame + untilNextFrame;
                    if (current.getState() == TransitionState.playing) {
                        return this.proceed(adjustedFrame, currentFrame);
                    }
                    Transition<V> done = this.queue.remove();
                    if (this.isLooped()) {
                        this.queue.add(done);
                    }
                    if (!this.queue.isEmpty()) {
                        long untilStartedNextFrame = this.queue.element().start(adjustedFrame);
                        this.fireAdjusted(this.getValue());
                        if (adjustedFrame + untilStartedNextFrame < currentFrame) {
                            return this.proceed(adjustedFrame, currentFrame);
                        }
                        return untilStartedNextFrame;
                    }
                    this.queue = null;
                    this.setState(TransitionState.finished);
                    return untilNextFrame;
                }
                return untilNextFrame;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        QueueTransition queueTransition = this;
        synchronized (queueTransition) {
            if (this.getState() == TransitionState.playing) {
                this.queue.element().abort();
                this.queue = null;
                this.setState(TransitionState.aborted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        QueueTransition queueTransition = this;
        synchronized (queueTransition) {
            if (this.getState() != TransitionState.ready) {
                this.checkConfiguration();
                this.queue = new ArrayDeque<Transition<V>>(this.elements);
                this.setState(TransitionState.ready);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getValue() {
        QueueTransition queueTransition = this;
        synchronized (queueTransition) {
            switch (this.getState()) {
                case playing: {
                    return this.queue.element().getValue();
                }
                case finished: {
                    return this.getGoal();
                }
                case aborted: {
                    return this.getLatest();
                }
            }
            return this.getStart();
        }
    }

    @Override
    public int compareTo(@NotNull Object object) {
        return this == object ? 0 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transition<V> getFirstTransition() {
        Object object = this.elementsLock;
        synchronized (object) {
            this.checkConfiguration();
            return this.elements.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transition<V> getLastTransition() {
        Object object = this.elementsLock;
        synchronized (object) {
            this.checkConfiguration();
            return this.elements.get(this.elements.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConfiguration() {
        Object object = this.elementsLock;
        synchronized (object) {
            if (CollectionUtils.isEmpty(this.elements)) {
                throw new AnimationException("QueueTransition must contain at least one Transition");
            }
        }
    }

    protected class QueueFrameRate
    implements FrameRate {
        protected QueueFrameRate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double value() {
            QueueTransition queueTransition = QueueTransition.this;
            synchronized (queueTransition) {
                Object object = QueueTransition.this.elementsLock;
                synchronized (object) {
                    switch (QueueTransition.this.getState()) {
                        case playing: {
                            return QueueTransition.this.queue.element().getFrameRate().value();
                        }
                        case finished: 
                        case aborted: {
                            return QueueTransition.this.elements.get(QueueTransition.this.elements.size() - 1).getFrameRate().value();
                        }
                    }
                    return QueueTransition.this.elements.get(0).getFrameRate().value();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixed() {
            Object object = QueueTransition.this.elementsLock;
            synchronized (object) {
                double frameRate = -1.0;
                for (Transition element : QueueTransition.this.elements) {
                    if (!element.getFrameRate().isFixed()) {
                        return false;
                    }
                    if (frameRate == -1.0) {
                        frameRate = element.getFrameRate().value();
                        continue;
                    }
                    if (frameRate == element.getFrameRate().value()) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

