/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag.transfer;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.CollectionUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.LoggerFactory;

public class FilesTransferable
implements Transferable {
    public static final String URI_LIST_MIME_TYPE = "text/uri-list;class=java.lang.String";
    public static final String uriListSeparator = "\r\n";
    public static DataFlavor uriListFlavor = null;
    public static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, FilesTransferable.getUriListDataFlavor()};
    @NotNull
    protected final List<File> files;

    public FilesTransferable(@NotNull File file) {
        this(CollectionUtils.asList((Object[])new File[]{file}));
    }

    public FilesTransferable(@NotNull List<File> files) {
        this.files = files;
    }

    @Override
    @NotNull
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
        boolean dataFlavorSupported = false;
        for (DataFlavor dataFlavor : flavors) {
            if (!dataFlavor.equals(flavor)) continue;
            dataFlavorSupported = true;
            break;
        }
        return dataFlavorSupported;
    }

    @Override
    @NotNull
    public Object getTransferData(@NotNull DataFlavor flavor) throws UnsupportedFlavorException {
        Object transferData;
        if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            transferData = this.files;
        } else if (flavor.equals(FilesTransferable.getUriListDataFlavor())) {
            transferData = FilesTransferable.fileListToTextURIList(this.files);
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
        return transferData;
    }

    public static boolean hasFilesList(@NotNull Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        return FilesTransferable.hasURIListFlavor(flavors) || FilesTransferable.hasFileListFlavor(flavors);
    }

    @Nullable
    public static List<File> getFilesList(@NotNull Transferable transferable) {
        List result = null;
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        try {
            if (FilesTransferable.hasURIListFlavor(flavors)) {
                result = FilesTransferable.textURIListToFileList((String)transferable.getTransferData(FilesTransferable.getUriListDataFlavor()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            try {
                if (FilesTransferable.hasURIListFlavor(flavors)) {
                    String url = (String)transferable.getTransferData(FilesTransferable.getUriListDataFlavor());
                    File file = new File(new URL(url).getPath());
                    result = CollectionUtils.asList((Object[])new File[]{file});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                if (FilesTransferable.hasFileListFlavor(flavors)) {
                    result = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @NotNull
    public static List<File> textURIListToFileList(@NotNull String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, uriListSeparator);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                list.add(new File(new URI(s)));
            }
            catch (Exception exception) {}
        }
        return list;
    }

    @NotNull
    public static String fileListToTextURIList(@NotNull List<File> files) {
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            sb.append(file.toURI().toASCIIString());
            sb.append(uriListSeparator);
        }
        return sb.toString();
    }

    public static boolean hasURIListFlavor(@NotNull DataFlavor[] flavors) {
        boolean hasURIListFlavor = false;
        for (DataFlavor flavor : flavors) {
            if (!FilesTransferable.getUriListDataFlavor().equals(flavor)) continue;
            hasURIListFlavor = true;
            break;
        }
        return hasURIListFlavor;
    }

    public static boolean hasFileListFlavor(@NotNull DataFlavor[] flavors) {
        boolean hasFileListFlavor = false;
        for (DataFlavor flavor : flavors) {
            if (!DataFlavor.javaFileListFlavor.equals(flavor)) continue;
            hasFileListFlavor = true;
            break;
        }
        return hasFileListFlavor;
    }

    @NotNull
    public static DataFlavor getUriListDataFlavor() {
        if (uriListFlavor == null) {
            try {
                uriListFlavor = new DataFlavor(URI_LIST_MIME_TYPE);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(FilesTransferable.class).error(e.toString(), (Throwable)e);
            }
        }
        return uriListFlavor;
    }
}

