/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag.transfer;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.drag.transfer.FilesTransferable;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class ImageTransferable
implements Transferable {
    public static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
    @NotNull
    protected final Image image;

    public ImageTransferable(@NotNull Image image) {
        this.image = image;
    }

    @Override
    @NotNull
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
        return flavor.equals(DataFlavor.imageFlavor);
    }

    @Override
    @NotNull
    public Object getTransferData(@NotNull DataFlavor flavor) throws UnsupportedFlavorException {
        if (!flavor.equals(DataFlavor.imageFlavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        Image transferData = this.image;
        return transferData;
    }

    public static boolean hasImagesList(@NotNull Transferable transferable) {
        DataFlavor[] df = transferable.getTransferDataFlavors();
        return ImageTransferable.hasImageFlavor(df) || FilesTransferable.hasURIListFlavor(df) || FilesTransferable.hasFileListFlavor(df);
    }

    @NotNull
    public static List<ImageIcon> getImagesList(@NotNull Transferable transferable) {
        Image image;
        ArrayList<ImageIcon> images = new ArrayList<ImageIcon>();
        List<File> files = FilesTransferable.getFilesList(transferable);
        if (files != null) {
            for (File file : files) {
                images.add(new ImageIcon(file.getAbsolutePath()));
            }
        }
        if ((image = ImageTransferable.getImage(transferable)) != null) {
            images.add(new ImageIcon(image));
        }
        return images;
    }

    public static boolean hasImageFlavor(@NotNull DataFlavor[] flavors) {
        boolean hasImageFlavor = false;
        for (DataFlavor flavor : flavors) {
            if (!DataFlavor.imageFlavor.equals(flavor)) continue;
            hasImageFlavor = true;
            break;
        }
        return hasImageFlavor;
    }

    @Nullable
    public static Image getImage(@NotNull Transferable transferable) {
        Image image = null;
        if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Object data = transferable.getTransferData(DataFlavor.imageFlavor);
                if (data instanceof Image) {
                    image = (Image)data;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return image;
    }
}

