/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag.view;

import com.alee.api.annotations.NotNull;
import com.alee.extended.tree.WebAsyncTree;
import com.alee.extended.tree.WebExTree;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.managers.drag.DragException;
import com.alee.managers.drag.view.DragViewHandler;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public abstract class NodesDragViewHandler<N extends MutableTreeNode>
implements DragViewHandler<List<N>> {
    public abstract int getNodesViewLimit();

    public Insets getMoreTextMargin() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    @NotNull
    public BufferedImage getView(@NotNull List<N> nodes, @NotNull DragSourceDragEvent dragSourceDragEvent) {
        WebTree tree;
        TreeModel model;
        DragSourceContext dsc;
        BufferedImage view = null;
        if (dragSourceDragEvent.getSource() instanceof DragSourceContext && (dsc = (DragSourceContext)dragSourceDragEvent.getSource()).getComponent() instanceof WebTree && (model = (tree = (WebTree)dsc.getComponent()).getModel()) != null) {
            List<N> realNodes;
            if (nodes.get(0) instanceof UniqueNode) {
                WebTree exTree;
                List<N> uniqueNodes = nodes;
                if (tree instanceof WebExTree) {
                    exTree = (WebExTree)tree;
                    realNodes = new ArrayList<N>();
                    for (UniqueNode node : uniqueNodes) {
                        realNodes.add(((WebExTree)exTree).findNode(node.getId()));
                    }
                } else if (tree instanceof WebAsyncTree) {
                    exTree = (WebAsyncTree)tree;
                    realNodes = new ArrayList<N>();
                    for (UniqueNode node : uniqueNodes) {
                        realNodes.add(((WebAsyncTree)exTree).findNode(node.getId()));
                    }
                } else {
                    realNodes = nodes;
                }
            } else {
                realNodes = nodes;
            }
            FontMetrics fm = tree.getFontMetrics(tree.getFont());
            int fmh = fm.getHeight();
            int limit = this.getNodesViewLimit();
            int amount = realNodes.size() - limit;
            String text = amount > 1 ? "And %s more elements" : "And one more element";
            String moreText = limit > 0 ? String.format(text, amount) : null;
            Insets moreTextOffset = this.getMoreTextMargin();
            int width = 0;
            int height = 0;
            int count = 0;
            for (MutableTreeNode node : realNodes) {
                if (limit <= 0 || limit > count) {
                    Rectangle bounds = tree.getNodeBounds(node);
                    if (bounds == null) continue;
                    width = Math.max(bounds.width, width);
                    height += bounds.height;
                    ++count;
                    continue;
                }
                width = Math.max(moreTextOffset.left + fm.stringWidth(moreText) + moreTextOffset.right, width);
                height += moreTextOffset.top + fmh + moreTextOffset.bottom;
                break;
            }
            BufferedImage image = ImageUtils.createCompatibleImage((int)width, (int)height, (int)3);
            Graphics2D g2d = image.createGraphics();
            int y = 0;
            count = 0;
            TreeCellRenderer cellRenderer = tree.getCellRenderer();
            CellRendererPane rendererPane = tree.getUI().getCellRendererPane();
            for (MutableTreeNode node : realNodes) {
                if (limit <= 0 || limit > count) {
                    Component renderer = cellRenderer.getTreeCellRendererComponent(tree, node, false, tree.isExpanded(node), model.isLeaf(node), tree.getRowForNode(node), false);
                    Dimension ps = renderer.getPreferredSize();
                    rendererPane.paintComponent(g2d, renderer, null, 0, y, ps.width, ps.height);
                    y += ps.height;
                    ++count;
                    continue;
                }
                SwingUtils.setupTextAntialias(g2d);
                g2d.setPaint(Color.BLACK);
                g2d.drawString(moreText, moreTextOffset.left, y + moreTextOffset.top + fmh / 2 + LafUtils.getTextCenterShiftY(fm));
                break;
            }
            g2d.dispose();
            view = image;
        }
        if (view == null) {
            throw new DragException("Unable to create nodes drag view: " + TextUtils.listToString(nodes));
        }
        return view;
    }

    @Override
    @NotNull
    public Point getViewRelativeLocation(@NotNull List<N> nodes, DragSourceDragEvent dragSourceDragEvent, @NotNull BufferedImage view) {
        return new Point(25, 5);
    }

    @Override
    public void dragEnded(@NotNull List<N> nodes, @NotNull DragSourceDropEvent event) {
    }
}

