/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.focus;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.extended.window.WebPopup;
import com.alee.managers.focus.FocusTracker;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.collection.WeakHashSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;

public abstract class DefaultFocusTracker
implements FocusTracker {
    @NotNull
    protected final JComponent component;
    protected boolean uniteWithChildren;
    @Nullable
    protected Set<Component> focusableChildren;
    protected boolean enabled;
    protected boolean focused;

    public DefaultFocusTracker(@NotNull JComponent component, boolean uniteWithChildren) {
        this.component = component;
        this.uniteWithChildren = uniteWithChildren;
        this.focusableChildren = null;
        this.enabled = true;
        this.focused = this.isInvolved(component, FocusManager.getCurrentManager().getFocusOwner());
    }

    public boolean isUniteWithChildren() {
        return this.uniteWithChildren;
    }

    public void setUniteWithChildren(boolean unite) {
        this.uniteWithChildren = unite;
    }

    @NotNull
    public List<Component> getFocusableChildren() {
        return new ImmutableList(this.focusableChildren != null ? this.focusableChildren : new ArrayList());
    }

    public void addFocusableChild(@NotNull Component child) {
        if (this.focusableChildren == null) {
            this.focusableChildren = new WeakHashSet(1);
        }
        this.focusableChildren.add(child);
    }

    public void removeFocusableChild(@NotNull Component child) {
        if (this.focusableChildren != null) {
            this.focusableChildren.remove(child);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.component.isShowing();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    @Override
    public boolean isInvolved(@NotNull JComponent tracked, @Nullable Component component) {
        if (component == null) {
            return false;
        }
        if (this.isChildInvolved(tracked, component)) {
            return true;
        }
        if (this.focusableChildren != null) {
            for (Component child : this.focusableChildren) {
                if (!this.isChildInvolved(child, component)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isChildInvolved(@NotNull Component tracked, @NotNull Component component) {
        return this.isUniteWithChildren() ? this.isRelated(tracked, component) : this.isEqual(tracked, component);
    }

    protected boolean isRelated(@NotNull Component tracked, @NotNull Component component) {
        boolean related = this.isEqualOrChild(tracked, component);
        if (!related && this.isTrackingWindow(tracked)) {
            Window trackedWindow = CoreSwingUtils.getWindowAncestor((Component)tracked);
            for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
                if (parent != trackedWindow) continue;
                related = true;
                break;
            }
        }
        if (!related) {
            for (JPopupMenu popup : CoreSwingUtils.getPopupMenus()) {
                Component invoker = popup.getInvoker();
                if (invoker == null || !this.isEqualOrChild(tracked, invoker)) continue;
                related = true;
                break;
            }
        }
        return related;
    }

    protected boolean isEqualOrChild(@NotNull Component tracked, @NotNull Component component) {
        Window window;
        boolean isEqualOrChild = SwingUtils.isEqualOrChild(tracked, component) ? true : (this.isTrackingWindow(tracked) ? (window = CoreSwingUtils.getWindowAncestor((Component)tracked)) != null && SwingUtils.isEqualOrChild(window, component) : false);
        return isEqualOrChild;
    }

    protected boolean isEqual(@NotNull Component tracked, @NotNull Component component) {
        Window window;
        boolean isEqual = tracked == component ? true : (this.isTrackingWindow(tracked) ? (window = CoreSwingUtils.getWindowAncestor((Component)tracked)) != null && window == component : false);
        return isEqual;
    }

    protected boolean isTrackingWindow(@NotNull Component tracked) {
        return tracked instanceof JRootPane || tracked instanceof WebPopup;
    }
}

