/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hover;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.BiConsumer;
import com.alee.managers.hover.GlobalHoverListener;
import com.alee.managers.hover.HoverTracker;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.swing.WeakComponentDataOrderedSet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public final class HoverManager {
    @NotNull
    private static final List<GlobalHoverListener> globalHoverListeners = new ArrayList<GlobalHoverListener>(5);
    @NotNull
    private static final WeakComponentDataOrderedSet<JComponent, GlobalHoverListener> globalComponentHoverListeners = new WeakComponentDataOrderedSet("HoverManager.GlobalHoverListener", 5);
    @NotNull
    private static final WeakComponentDataOrderedSet<JComponent, HoverTracker> trackers = new WeakComponentDataOrderedSet("HoverManager.HoverTracker", 200);
    private static WeakReference<Component> previousHoverOwner;
    private static WeakReference<Component> hoverOwner;
    private static WeakReference<Window> hoverOwnerWindow;
    private static final Map<Long, Component> hoverEventQueue;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            previousHoverOwner = new WeakReference<Object>(null);
            hoverOwner = new WeakReference<Object>(null);
            hoverOwnerWindow = new WeakReference<Object>(null);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    MouseEvent mouseEvent = (MouseEvent)event;
                    if (mouseEvent.getID() == 504) {
                        HoverManager.queueEvent(mouseEvent.getWhen(), HoverManager.findNearbyHoverOwner(mouseEvent.getComponent(), mouseEvent.getPoint()));
                    } else if (mouseEvent.getID() == 505) {
                        HoverManager.queueEvent(mouseEvent.getWhen(), null);
                    }
                }
            }, 16L);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    MouseEvent mouseEvent = (MouseEvent)event;
                    if (mouseEvent.getID() == 503 || mouseEvent.getID() == 506) {
                        HoverManager.queueEvent(mouseEvent.getWhen(), HoverManager.findNearbyHoverOwner(mouseEvent.getComponent(), mouseEvent.getPoint()));
                    }
                }
            }, 32L);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    HoverManager.queuePostLayoutUpdateEvent();
                }
            }, 1L);
        }
    }

    private static void queueEvent(final long time, @Nullable Component component) {
        if (!hoverEventQueue.containsKey(time)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (hoverEventQueue.containsKey(time)) {
                        HoverManager.fireHoverChanged((Component)hoverEventQueue.remove(time));
                    }
                }
            });
        }
        hoverEventQueue.put(time, component);
    }

    private static void queuePostLayoutUpdateEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HoverManager.fireHoverChanged(HoverManager.findPossibleHoverOwner());
                    }
                });
            }
        });
    }

    @Nullable
    private static Component findPossibleHoverOwner() {
        Window currentHoverWindow = (Window)hoverOwnerWindow.get();
        Component newHover = currentHoverWindow != null && currentHoverWindow.isShowing() ? HoverManager.findNearbyHoverOwner(currentHoverWindow, CoreSwingUtils.getMouseLocation((Component)currentHoverWindow)) : null;
        return newHover;
    }

    @Nullable
    private static Component findNearbyHoverOwner(@Nullable Component component, @NotNull Point point) {
        Component newHoverOwner;
        if (component != null) {
            JRootPane rootPane = CoreSwingUtils.getRootPane((Component)component);
            if (rootPane != null && rootPane.isShowing()) {
                if (rootPane == component) {
                    newHoverOwner = CoreSwingUtils.getTopComponentAt((Component)rootPane, (Point)point);
                } else if (rootPane.isAncestorOf(component)) {
                    Component parent;
                    Point relative = new Point(point);
                    for (parent = component; parent != rootPane && parent != null; parent = parent.getParent()) {
                        Point location = parent.getLocation();
                        relative.x += location.x;
                        relative.y += location.y;
                    }
                    newHoverOwner = parent != null ? CoreSwingUtils.getTopComponentAt((Component)rootPane, (Point)relative) : null;
                } else {
                    Container parent;
                    Point relative = new Point(point);
                    for (parent = rootPane; parent != component && parent != null; parent = parent.getParent()) {
                        Point location = parent.getLocation();
                        relative.x -= location.x;
                        relative.y -= location.y;
                    }
                    newHoverOwner = parent != null ? CoreSwingUtils.getTopComponentAt((Component)rootPane, (Point)relative) : null;
                }
            } else {
                newHoverOwner = null;
            }
        } else {
            newHoverOwner = null;
        }
        return newHoverOwner;
    }

    @Nullable
    public static Component getPreviousHoverOwner() {
        return (Component)previousHoverOwner.get();
    }

    @Nullable
    public static Component getHoverOwner() {
        return hoverOwner != null ? (Component)hoverOwner.get() : null;
    }

    @Nullable
    public static Window getHoverOwnerWindow() {
        return hoverOwnerWindow != null ? (Window)hoverOwnerWindow.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalHoverListener(@NotNull GlobalHoverListener listener) {
        List<GlobalHoverListener> list = globalHoverListeners;
        synchronized (list) {
            globalHoverListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterGlobalHoverListener(@NotNull GlobalHoverListener listener) {
        List<GlobalHoverListener> list = globalHoverListeners;
        synchronized (list) {
            globalHoverListeners.remove(listener);
        }
    }

    public static void registerGlobalHoverListener(@NotNull JComponent component, @NotNull GlobalHoverListener listener) {
        globalComponentHoverListeners.add(component, (Object)listener);
    }

    public static void unregisterGlobalHoverListener(@NotNull JComponent component, @NotNull GlobalHoverListener listener) {
        globalComponentHoverListeners.remove(component, (Object)listener);
    }

    public static void addHoverTracker(@NotNull JComponent component, @NotNull HoverTracker hoverTracker) {
        trackers.add(component, (Object)hoverTracker);
    }

    public static void removeHoverTracker(@NotNull JComponent component, @NotNull HoverTracker hoverTracker) {
        trackers.remove(component, (Object)hoverTracker);
    }

    public static void removeHoverTrackers(@NotNull JComponent component) {
        trackers.clear(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireHoverChanged(@Nullable Component hover) {
        Component oldHover;
        final Component newHover = hover == null || hover.isShowing() ? hover : null;
        if (newHover != (oldHover = (Component)hoverOwner.get())) {
            ImmutableList globalListenersCopy;
            previousHoverOwner = new WeakReference<Component>(oldHover);
            hoverOwner = new WeakReference<Component>(newHover);
            hoverOwnerWindow = new WeakReference<Window>(CoreSwingUtils.getWindowAncestor((Component)newHover));
            trackers.forEachData((BiConsumer)new BiConsumer<JComponent, HoverTracker>(){

                public void accept(JComponent tracked, HoverTracker hoverTracker) {
                    if (hoverTracker.isEnabled()) {
                        boolean isOldHovered = hoverTracker.isInvolved(tracked, oldHover);
                        boolean isNewHovered = hoverTracker.isInvolved(tracked, newHover);
                        if ((isOldHovered || isNewHovered) && hoverTracker.isHovered() != isNewHovered) {
                            hoverTracker.setHovered(isNewHovered);
                            hoverTracker.hoverChanged(isNewHovered);
                        }
                    }
                }
            });
            globalComponentHoverListeners.forEachData((BiConsumer)new BiConsumer<JComponent, GlobalHoverListener>(){

                public void accept(JComponent component, GlobalHoverListener listener) {
                    listener.hoverChanged(oldHover, newHover);
                }
            });
            List<GlobalHoverListener> list = globalHoverListeners;
            synchronized (list) {
                globalListenersCopy = new ImmutableList(globalHoverListeners);
            }
            for (GlobalHoverListener listener : globalListenersCopy) {
                listener.hoverChanged(oldHover, newHover);
            }
        }
    }

    static {
        hoverEventQueue = new HashMap<Long, Component>();
        initialized = false;
    }
}

