/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.icon.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.resource.Resource;
import com.alee.managers.icon.data.IconAdjustment;
import com.alee.utils.XmlUtils;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class AbstractIconSourceConverter<I extends Icon>
extends ReflectionConverter {
    public static final String ID_ATTRIBUTE = "id";

    public AbstractIconSourceConverter(@NotNull Mapper mapper, @NotNull ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    @NotNull
    protected String readId(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context) {
        return reader.getAttribute(ID_ATTRIBUTE);
    }

    @NotNull
    protected Resource readResource(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context) {
        return XmlUtils.readResource((HierarchicalStreamReader)reader, (UnmarshallingContext)context, (Mapper)this.mapper);
    }

    @NotNull
    protected List<IconAdjustment<I>> readAdjustments(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context) {
        ArrayList<IconAdjustment<I>> adjustments = new ArrayList<IconAdjustment<I>>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            Class iconSourceClass = this.mapper.realClass(nodeName);
            if (IconAdjustment.class.isAssignableFrom(iconSourceClass)) {
                adjustments.add((IconAdjustment)context.convertAnother(adjustments, iconSourceClass));
            }
            reader.moveUp();
        }
        return adjustments;
    }
}

