/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.Objects;
import com.alee.api.resource.ClassResource;
import com.alee.api.resource.Resource;
import com.alee.extended.collapsible.WebCollapsiblePaneLU;
import com.alee.extended.dock.WebDockableFrameLU;
import com.alee.extended.filechooser.WebFileDropLU;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.AbstractButtonLU;
import com.alee.laf.desktoppane.JInternalFrameLU;
import com.alee.laf.filechooser.JFileChooserLU;
import com.alee.laf.label.JLabelLU;
import com.alee.laf.progressbar.JProgressBarLU;
import com.alee.laf.rootpane.JRootPaneLU;
import com.alee.laf.tabbedpane.JTabbedPaneLU;
import com.alee.laf.text.JTextComponentLU;
import com.alee.laf.tooltip.SwingToolTipLanguage;
import com.alee.managers.language.AbstractToolTipLanguage;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.LM;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageException;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.LanguageUpdater;
import com.alee.managers.language.LanguageUpdaterComparator;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.ToolTipLU;
import com.alee.managers.language.TranslationKey;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.tooltip.CustomToolTipLanguage;
import com.alee.utils.ArrayUtils;
import com.alee.utils.swing.WeakComponentData;
import com.alee.utils.swing.WeakComponentDataOrderedSet;
import java.awt.ComponentOrientation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public final class UILanguageManager {
    private static final ImageIcon UNKNOWN_LANGUAGE = new ImageIcon(UILanguageManager.class.getResource("icons/unknown.png"));
    @NotNull
    private static final Map<String, Icon> localeIcons = new HashMap<String, Icon>();
    private static boolean checkComponentsTextForTranslations;
    @NotNull
    private static final WeakComponentData<JComponent, TranslationKey> components;
    @NotNull
    private static final LanguageUpdaterComparator languageUpdaterComparator;
    @NotNull
    private static final List<LanguageUpdater> updaters;
    @NotNull
    private static final WeakComponentData<JComponent, LanguageUpdater> customUpdaters;
    @NotNull
    private static final Map<Class, LanguageUpdater> updatersCache;
    @NotNull
    private static final WeakComponentDataOrderedSet<JComponent, LanguageListener> componentLanguageListeners;
    @NotNull
    private static final WeakComponentDataOrderedSet<JComponent, DictionaryListener> componentDictionaryListeners;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            LanguageManager.initialize();
            UILanguageManager.setCheckComponentsTextForTranslations(true);
            initialized = true;
            UILanguageManager.registerLanguageUpdater(new ToolTipLU());
            UILanguageManager.registerLanguageUpdater(new JLabelLU());
            UILanguageManager.registerLanguageUpdater(new AbstractButtonLU());
            UILanguageManager.registerLanguageUpdater(new JTextComponentLU());
            UILanguageManager.registerLanguageUpdater(new JTabbedPaneLU());
            UILanguageManager.registerLanguageUpdater(new JProgressBarLU());
            UILanguageManager.registerLanguageUpdater(new JFileChooserLU());
            UILanguageManager.registerLanguageUpdater(new JRootPaneLU());
            UILanguageManager.registerLanguageUpdater(new JInternalFrameLU());
            UILanguageManager.registerLanguageUpdater(new WebFileDropLU());
            UILanguageManager.registerLanguageUpdater(new WebCollapsiblePaneLU());
            UILanguageManager.registerLanguageUpdater(new WebDockableFrameLU());
            UILanguageManager.registerLanguageUpdater(new SwingToolTipLanguage());
            UILanguageManager.registerLanguageUpdater(new CustomToolTipLanguage());
            AbstractToolTipLanguage.setDefaultToolTipType("CUSTOM");
            LanguageManager.addLanguageListener((LanguageListener)new LanguageListener(){

                public void languageChanged(@NotNull Language oldLanguage, @NotNull Language newLanguage) {
                    ComponentOrientation oo = ComponentOrientation.getOrientation(oldLanguage.getLocale());
                    ComponentOrientation no = ComponentOrientation.getOrientation(newLanguage.getLocale());
                    if (oo.isLeftToRight() != no.isLeftToRight()) {
                        WebLookAndFeel.updateOrientation();
                    }
                    UILanguageManager.updateComponents();
                    UILanguageManager.fireLanguageChanged(oldLanguage, newLanguage);
                }
            });
            LanguageManager.addDictionaryListener((DictionaryListener)new DictionaryListener(){

                public void dictionaryAdded(@NotNull Dictionary dictionary) {
                    UILanguageManager.updateComponents(dictionary.getKeys());
                    UILanguageManager.fireDictionaryAdded(dictionary);
                }

                public void dictionaryRemoved(@NotNull Dictionary dictionary) {
                    UILanguageManager.updateComponents(dictionary.getKeys());
                    UILanguageManager.fireDictionaryRemoved(dictionary);
                }

                public void dictionariesCleared() {
                    UILanguageManager.updateComponents();
                    UILanguageManager.fireDictionariesCleared();
                }
            });
            LanguageManager.addDictionary((Dictionary)new Dictionary((Resource)new ClassResource(UILanguageManager.class, "resources/ui-language.xml")));
        }
    }

    private static void mustBeInitialized() throws LanguageException {
        if (!initialized) {
            throw new LanguageException("WebLanguageManager must be initialized first");
        }
    }

    public static boolean isCheckComponentsTextForTranslations() {
        return checkComponentsTextForTranslations;
    }

    public static void setCheckComponentsTextForTranslations(boolean check) {
        checkComponentsTextForTranslations = check;
    }

    @NotNull
    public static Icon getLanguageIcon(@NotNull Language language) {
        return UILanguageManager.getLocaleIcon(language.getLocale());
    }

    @NotNull
    public static Icon getLocaleIcon(@NotNull Locale locale) {
        Icon localeIcon;
        String key = LanguageUtils.toString((Locale)locale);
        if (localeIcons.containsKey(key)) {
            localeIcon = localeIcons.get(key);
        } else {
            ImageIcon icon;
            try {
                URL res = UILanguageManager.class.getResource("icons/" + key + ".png");
                if (res == null) {
                    res = UILanguageManager.class.getResource("icons/" + locale.getLanguage() + ".png");
                }
                icon = new ImageIcon(res);
            }
            catch (Exception e) {
                icon = UNKNOWN_LANGUAGE;
            }
            localeIcons.put(key, icon);
            localeIcon = icon;
        }
        return localeIcon;
    }

    @Nullable
    public static Icon setLanguageIcon(@NotNull Language language, @Nullable Icon icon) {
        return UILanguageManager.setLocaleIcon(language.getLocale(), icon);
    }

    @Nullable
    public static Icon setLocaleIcon(@NotNull Locale locale, @Nullable Icon icon) {
        String key = LanguageUtils.toString((Locale)locale);
        return localeIcons.put(key, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageUpdater(@NotNull LanguageUpdater updater) {
        List<LanguageUpdater> list = updaters;
        synchronized (list) {
            Iterator<LanguageUpdater> iterator = updaters.iterator();
            while (iterator.hasNext()) {
                if (updater.getComponentClass() != iterator.next().getComponentClass()) continue;
                iterator.remove();
            }
            updaters.add(updater);
            updatersCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageUpdater(@NotNull LanguageUpdater updater) {
        List<LanguageUpdater> list = updaters;
        synchronized (list) {
            updaters.remove(updater);
            updatersCache.clear();
        }
    }

    public static void registerLanguageUpdater(@NotNull JComponent component, @NotNull LanguageUpdater updater) {
        customUpdaters.set(component, (Object)updater);
    }

    public static void unregisterLanguageUpdater(@NotNull JComponent component) {
        customUpdaters.clear(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static LanguageUpdater getLanguageUpdater(@NotNull JComponent component) {
        LanguageUpdater updater;
        LanguageUpdater customUpdater = (LanguageUpdater)customUpdaters.get(component);
        if (customUpdater != null) {
            updater = customUpdater;
        } else {
            List<LanguageUpdater> list = updaters;
            synchronized (list) {
                LanguageUpdater cachedUpdater = updatersCache.get(component.getClass());
                if (cachedUpdater != null) {
                    updater = cachedUpdater;
                } else {
                    ArrayList<LanguageUpdater> foundUpdaters = new ArrayList<LanguageUpdater>();
                    for (LanguageUpdater lu : updaters) {
                        if (!lu.getComponentClass().isInstance(component)) continue;
                        foundUpdaters.add(lu);
                    }
                    if (foundUpdaters.size() == 1) {
                        updater = (LanguageUpdater)foundUpdaters.get(0);
                    } else if (foundUpdaters.size() > 1) {
                        Collections.sort(foundUpdaters, languageUpdaterComparator);
                        updater = (LanguageUpdater)foundUpdaters.get(0);
                    } else {
                        throw new RuntimeException("Unable to find LanguageUpdater for component: " + component);
                    }
                    updatersCache.put(component.getClass(), updater);
                }
            }
        }
        return updater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static LanguageUpdater getLanguageUpdater(@NotNull Class<? extends JComponent> clazz) {
        LanguageUpdater updater;
        List<LanguageUpdater> list = updaters;
        synchronized (list) {
            updater = updatersCache.get(clazz);
            if (updater == null) {
                ArrayList<LanguageUpdater> foundUpdaters = new ArrayList<LanguageUpdater>();
                for (LanguageUpdater lu : updaters) {
                    if (!lu.getComponentClass().isAssignableFrom(clazz)) continue;
                    foundUpdaters.add(lu);
                }
                if (foundUpdaters.size() == 1) {
                    updater = (LanguageUpdater)foundUpdaters.get(0);
                } else if (foundUpdaters.size() > 1) {
                    Collections.sort(foundUpdaters, languageUpdaterComparator);
                    updater = (LanguageUpdater)foundUpdaters.get(0);
                } else {
                    throw new RuntimeException("Unable to find LanguageUpdater for component class: " + clazz);
                }
                updatersCache.put(clazz, updater);
            }
        }
        return updater;
    }

    @Nullable
    public static String getInitialText(@Nullable String key, Object ... data) {
        UILanguageManager.mustBeInitialized();
        String text = UILanguageManager.isCheckComponentsTextForTranslations() && LM.contains((String)key) ? (LM.containsText((String)key) ? LM.get((String)key, (Object[])data) : null) : key;
        return text;
    }

    public static void registerInitialLanguage(@NotNull LanguageMethods component, @Nullable String key, Object ... data) {
        UILanguageManager.mustBeInitialized();
        if (UILanguageManager.isCheckComponentsTextForTranslations() && key != null && LM.contains((String)key)) {
            component.setLanguage(key, data);
        }
    }

    public static void registerComponent(@NotNull JComponent component, @NotNull String key, Object ... data) {
        UILanguageManager.mustBeInitialized();
        UILanguageManager.unregisterComponent(component);
        Object[] actualData = data != null && data.length == 0 ? null : data;
        components.set(component, (Object)new TranslationKey(key, actualData));
        UILanguageManager.updateComponent(component, new Object[0]);
    }

    public static void unregisterComponent(@NotNull JComponent component) {
        UILanguageManager.mustBeInitialized();
        components.clear(component);
    }

    public static boolean isRegisteredComponent(@NotNull JComponent component) {
        UILanguageManager.mustBeInitialized();
        return components.contains(component);
    }

    @Nullable
    public static String getComponentKey(@NotNull JComponent component) {
        UILanguageManager.mustBeInitialized();
        TranslationKey translationKey = (TranslationKey)components.get(component);
        return translationKey != null ? translationKey.getKey() : null;
    }

    public static void updateComponents() {
        UILanguageManager.mustBeInitialized();
        components.forEach((BiConsumer)new BiConsumer<JComponent, TranslationKey>(){

            public void accept(@NotNull JComponent component, @NotNull TranslationKey translationKey) {
                UILanguageManager.updateComponent(component, new Object[0]);
            }
        });
    }

    public static void updateComponents(final @NotNull Set<String> keys) {
        UILanguageManager.mustBeInitialized();
        components.forEach((BiConsumer)new BiConsumer<JComponent, TranslationKey>(){

            public void accept(@NotNull JComponent component, @NotNull TranslationKey translationKey) {
                if (keys.contains(translationKey.getKey())) {
                    UILanguageManager.updateComponent(component, new Object[0]);
                }
            }
        });
    }

    public static void updateComponent(@NotNull JComponent component, Object ... data) {
        UILanguageManager.mustBeInitialized();
        TranslationKey translationKey = (TranslationKey)components.get(component);
        if (translationKey == null) {
            throw new LanguageException("Component is not registered yet: " + component);
        }
        Object[] actualData = UILanguageManager.getActualData(component, translationKey.getKey(), data);
        translationKey.setData(actualData);
        LanguageUpdater updater = UILanguageManager.getLanguageUpdater(component);
        updater.update(component, LM.getLanguage(), translationKey.getKey(), translationKey.getData());
    }

    public static void updateComponent(@NotNull JComponent component, @NotNull String key, Object ... data) {
        UILanguageManager.mustBeInitialized();
        if (!UILanguageManager.isRegisteredComponent(component)) {
            throw new LanguageException("Component is not registered yet: " + component);
        }
        Object[] actualData = UILanguageManager.getActualData(component, key, data);
        TranslationKey translationKey = new TranslationKey(key, actualData);
        components.set(component, (Object)translationKey);
        LanguageUpdater updater = UILanguageManager.getLanguageUpdater(component);
        updater.update(component, LM.getLanguage(), translationKey.getKey(), translationKey.getData());
    }

    @Nullable
    private static Object[] getActualData(@NotNull JComponent component, @NotNull String key, @Nullable Object[] data) {
        Object[] actualData;
        TranslationKey oldKey = (TranslationKey)components.get(component);
        if (oldKey != null) {
            actualData = Objects.equals((Object)oldKey.getKey(), (Object)key) ? (ArrayUtils.notEmpty((Object[])data) ? data : oldKey.getData()) : data;
        } else {
            throw new LanguageException("Component is not registered yet: " + component);
        }
        return actualData;
    }

    public static void addLanguageListener(@NotNull JComponent component, @NotNull LanguageListener listener) {
        componentLanguageListeners.add(component, (Object)listener);
    }

    public static void removeLanguageListener(@NotNull JComponent component, @NotNull LanguageListener listener) {
        componentLanguageListeners.remove(component, (Object)listener);
    }

    public static void removeLanguageListeners(@NotNull JComponent component) {
        componentLanguageListeners.clear(component);
    }

    private static void fireLanguageChanged(final @NotNull Language oldLanguage, final @NotNull Language newLanguage) {
        componentLanguageListeners.forEachData((BiConsumer)new BiConsumer<JComponent, LanguageListener>(){

            public void accept(@NotNull JComponent component, @NotNull LanguageListener languageListener) {
                languageListener.languageChanged(oldLanguage, newLanguage);
            }
        });
    }

    public static void addDictionaryListener(@NotNull JComponent component, @NotNull DictionaryListener listener) {
        componentDictionaryListeners.add(component, (Object)listener);
    }

    public static void removeDictionaryListener(@NotNull JComponent component, @NotNull DictionaryListener listener) {
        componentDictionaryListeners.remove(component, (Object)listener);
    }

    public static void removeDictionaryListeners(@NotNull JComponent component) {
        componentDictionaryListeners.clear(component);
    }

    private static void fireDictionaryAdded(final @NotNull Dictionary dictionary) {
        componentDictionaryListeners.forEachData((BiConsumer)new BiConsumer<JComponent, DictionaryListener>(){

            public void accept(@NotNull JComponent component, @NotNull DictionaryListener languageListener) {
                languageListener.dictionaryAdded(dictionary);
            }
        });
    }

    private static void fireDictionaryRemoved(final @NotNull Dictionary dictionary) {
        componentDictionaryListeners.forEachData((BiConsumer)new BiConsumer<JComponent, DictionaryListener>(){

            public void accept(@NotNull JComponent component, @NotNull DictionaryListener languageListener) {
                languageListener.dictionaryRemoved(dictionary);
            }
        });
    }

    private static void fireDictionariesCleared() {
        componentDictionaryListeners.forEachData((BiConsumer)new BiConsumer<JComponent, DictionaryListener>(){

            public void accept(@NotNull JComponent component, @NotNull DictionaryListener languageListener) {
                languageListener.dictionariesCleared();
            }
        });
    }

    static {
        components = new WeakComponentData("WebLanguageManager.TranslationKey", 100);
        languageUpdaterComparator = new LanguageUpdaterComparator();
        updaters = new ArrayList<LanguageUpdater>(20);
        customUpdaters = new WeakComponentData("WebLanguageManager.LanguageUpdater", 2);
        updatersCache = new HashMap<Class, LanguageUpdater>();
        componentLanguageListeners = new WeakComponentDataOrderedSet("WebLanguageManager.LanguageListener", 50);
        componentDictionaryListeners = new WeakComponentDataOrderedSet("WebLanguageManager.DictionaryListener", 5);
        initialized = false;
    }
}

