/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.notification;

import com.alee.extended.image.WebImage;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.panel.AlignPanel;
import com.alee.extended.window.PopupAdapter;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.notification.NotificationIcon;
import com.alee.managers.notification.NotificationListener;
import com.alee.managers.notification.NotificationOption;
import com.alee.managers.popup.WebInnerPopup;
import com.alee.managers.style.StyleId;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.swing.WebTimer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class WebInnerNotification
extends WebInnerPopup {
    protected List<NotificationListener> listeners = new ArrayList<NotificationListener>(1);
    protected boolean clickToClose = true;
    protected boolean closeOnOptionSelection = true;
    protected boolean equalizeButtonWidths = true;
    protected long displayTime = 0L;
    protected WebTimer displayTimer;
    protected boolean accepted;
    protected Icon icon;
    protected Component content;
    protected List<NotificationOption> options;
    protected WebImage iconImage;
    protected WebPanel contentPanel;
    protected WebPanel optionsPanel;
    protected AlignPanel westPanel;
    protected AlignPanel centerPanel;
    protected AlignPanel southPanel;

    public WebInnerNotification() {
        this(StyleId.notification);
    }

    public WebInnerNotification(StyleId id) {
        super(id);
        this.initializeNotificationPopup();
    }

    protected void initializeNotificationPopup() {
        this.setLayout(new BorderLayout(15, 5));
        this.setAnimated(true);
        this.iconImage = new WebImage();
        this.westPanel = new AlignPanel(this.iconImage, 0, 0);
        this.updateIcon();
        this.contentPanel = new WebPanel(StyleId.panelTransparent);
        this.centerPanel = new AlignPanel(this.contentPanel, 0, 0);
        this.updateContent();
        this.optionsPanel = new WebPanel(StyleId.panelTransparent, new HorizontalFlowLayout(4, false), new Component[0]);
        this.southPanel = new AlignPanel(this.optionsPanel, 4, 0);
        this.updateOptionButtons();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (WebInnerNotification.this.clickToClose) {
                    if (SwingUtils.isLeftMouseButton(e)) {
                        WebInnerNotification.this.acceptAndHide();
                    } else {
                        WebInnerNotification.this.hidePopup();
                    }
                }
            }
        });
        this.addPopupListener(new PopupAdapter(){

            @Override
            public void popupWillBeOpened() {
                WebInnerNotification.this.accepted = false;
            }

            @Override
            public void popupOpened() {
                WebInnerNotification.this.startDelayedClose();
            }

            @Override
            public void popupWillBeClosed() {
                WebInnerNotification.this.stopDelayedClose();
                if (WebInnerNotification.this.accepted) {
                    WebInnerNotification.this.fireAccepted();
                } else {
                    WebInnerNotification.this.fireClosed();
                }
            }
        });
    }

    private void startDelayedClose() {
        if (!(this.displayTime <= 0L || this.displayTimer != null && this.displayTimer.isRunning())) {
            this.displayTimer = WebTimer.delay((long)this.displayTime, (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebInnerNotification.this.hidePopup();
                }
            });
        }
    }

    private void stopDelayedClose() {
        if (this.displayTimer != null && this.displayTimer.isRunning()) {
            this.displayTimer.stop();
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.updateIcon();
    }

    public void setIcon(NotificationIcon iconType) {
        this.setIcon(iconType.getIcon());
    }

    protected void updateIcon() {
        this.iconImage.setImage(this.icon);
        if (this.icon != null) {
            if (!this.contains(this.westPanel)) {
                this.add((Component)this.westPanel, (Object)"West");
            }
        } else if (this.contains(this.westPanel)) {
            this.remove((Component)this.westPanel);
        }
        this.revalidate();
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        this.content = content;
        this.updateContent();
    }

    public void setContent(String content) {
        this.setContent(new WebLabel(content));
    }

    protected void updateContent() {
        if (this.content != null) {
            this.contentPanel.removeAll();
            this.contentPanel.add(this.content);
            if (!this.contains(this.centerPanel)) {
                this.add((Component)this.centerPanel, (Object)"Center");
            }
        } else {
            this.contentPanel.removeAll();
            if (this.contains(this.centerPanel)) {
                this.remove((Component)this.centerPanel);
            }
        }
        this.revalidate();
    }

    public List<NotificationOption> getOptions() {
        return this.options;
    }

    public void setOptions(NotificationOption ... options) {
        this.setOptions(CollectionUtils.asList((Object[])options));
    }

    public void setOptions(List<NotificationOption> options) {
        this.options = options;
        this.updateOptionButtons();
    }

    protected void updateOptionButtons() {
        this.optionsPanel.removeAll();
        if (CollectionUtils.notEmpty(this.options)) {
            for (final NotificationOption option : this.options) {
                StyleId id = StyleId.notificationOption.at(this);
                WebButton optionButton = new WebButton(id, option.getLanguageKey(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebInnerNotification.this.fireOptionSelected(option);
                        if (WebInnerNotification.this.closeOnOptionSelection) {
                            WebInnerNotification.this.acceptAndHide();
                        }
                    }
                });
                this.optionsPanel.add((Component)optionButton);
            }
            if (this.equalizeButtonWidths) {
                ImmutableList properties = new ImmutableList((Object[])new String[]{"text"});
                SwingUtils.equalizeComponentsWidth((List<String>)properties, this.optionsPanel.getComponents());
            }
            if (!this.contains(this.southPanel)) {
                this.add((Component)this.southPanel, (Object)"South");
            }
        } else if (this.contains(this.southPanel)) {
            this.remove((Component)this.southPanel);
        }
        this.revalidate();
    }

    public void acceptAndHide() {
        this.accepted = true;
        this.hidePopup();
    }

    public boolean isClickToClose() {
        return this.clickToClose;
    }

    public void setClickToClose(boolean clickToClose) {
        this.clickToClose = clickToClose;
    }

    public boolean isCloseOnOptionSelection() {
        return this.closeOnOptionSelection;
    }

    public void setCloseOnOptionSelection(boolean closeOnOptionSelection) {
        this.closeOnOptionSelection = closeOnOptionSelection;
    }

    public boolean isEqualizeButtonWidths() {
        return this.equalizeButtonWidths;
    }

    public void setEqualizeButtonWidths(boolean equalizeButtonWidths) {
        this.equalizeButtonWidths = equalizeButtonWidths;
        this.updateOptionButtons();
    }

    public long getDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(long displayTime) {
        this.displayTime = displayTime;
        if (this.isShowing()) {
            if (displayTime > 0L) {
                this.startDelayedClose();
            } else {
                this.stopDelayedClose();
            }
        }
    }

    public void addNotificationListener(NotificationListener listener) {
        this.listeners.add(listener);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.listeners.remove(listener);
    }

    public void fireOptionSelected(NotificationOption option) {
        for (NotificationListener listener : CollectionUtils.copy(this.listeners)) {
            listener.optionSelected(option);
        }
    }

    public void fireAccepted() {
        for (NotificationListener listener : CollectionUtils.copy(this.listeners)) {
            listener.accepted();
        }
    }

    public void fireClosed() {
        for (NotificationListener listener : CollectionUtils.copy(this.listeners)) {
            listener.closed();
        }
    }
}

