/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsManager;
import java.io.Serializable;
import javax.swing.JComponent;
import org.slf4j.LoggerFactory;

public abstract class SettingsProcessor<C extends JComponent, V extends Serializable, K extends Configuration<V>>
implements Serializable {
    @NotNull
    protected C component;
    @NotNull
    protected K configuration;
    protected transient boolean loading = false;
    protected transient boolean saving = false;

    public SettingsProcessor(@NotNull C component, @NotNull K configuration) {
        WebLookAndFeel.checkEventDispatchThread();
        this.component = component;
        this.configuration = configuration;
        this.loadInitialSettings();
        this.initialize();
    }

    protected void loadInitialSettings() {
        if (((Configuration)this.configuration).isLoadInitialSettings()) {
            this.load();
        }
    }

    protected void initialize() {
        try {
            this.register(this.component());
        }
        catch (Exception e) {
            String msg = "Unable to initialize specific processor settings for component with group '%s' and key '%s' due to unexpected exception";
            String fmsg = String.format("Unable to initialize specific processor settings for component with group '%s' and key '%s' due to unexpected exception", ((Configuration)this.configuration).group(), ((Configuration)this.configuration).key());
            LoggerFactory.getLogger(SettingsProcessor.class).error(fmsg, (Throwable)e);
        }
    }

    protected abstract void register(@NotNull C var1);

    public final void destroy() {
        WebLookAndFeel.checkEventDispatchThread();
        try {
            this.unregister(this.component());
        }
        catch (Exception e) {
            String msg = "Unable to unregister specific processor settings for component with group '%s' and key '%s' due to unexpected exception";
            String fmsg = String.format("Unable to unregister specific processor settings for component with group '%s' and key '%s' due to unexpected exception", ((Configuration)this.configuration).group(), ((Configuration)this.configuration).key());
            LoggerFactory.getLogger(SettingsProcessor.class).error(fmsg, (Throwable)e);
        }
    }

    protected abstract void unregister(@NotNull C var1);

    @NotNull
    public C component() {
        return this.component;
    }

    @NotNull
    public K configuration() {
        return this.configuration;
    }

    @Nullable
    public final V defaultValue() {
        Object defaultValue = ((Configuration)this.configuration).defaultValue();
        if (defaultValue == null) {
            defaultValue = this.createDefaultValue();
        }
        return defaultValue;
    }

    @Nullable
    protected V createDefaultValue() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        WebLookAndFeel.checkEventDispatchThread();
        if (!this.loading && !this.saving) {
            try {
                this.loading = true;
                this.loadSettings(this.component());
            }
            catch (Exception e) {
                String msg = "Unable to load component settings for group '%s' and key '%s' due to unexpected exception";
                String fmsg = String.format("Unable to load component settings for group '%s' and key '%s' due to unexpected exception", ((Configuration)this.configuration).group(), ((Configuration)this.configuration).key());
                LoggerFactory.getLogger(SettingsProcessor.class).error(fmsg, (Throwable)e);
            }
            finally {
                this.loading = false;
            }
        }
    }

    protected abstract void loadSettings(@NotNull C var1);

    @Nullable
    protected V loadSettings() {
        K configuration = this.configuration();
        return (V)((Serializable)SettingsManager.get((String)((Configuration)configuration).group(), (String)((Configuration)configuration).key(), this.defaultValue()));
    }

    public final void save() {
        this.save(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(boolean onChange) {
        WebLookAndFeel.checkEventDispatchThread();
        if (!(onChange && !SettingsManager.isSaveOnChange() || this.loading || this.saving)) {
            try {
                this.saving = true;
                this.saveSettings((V)this.component());
            }
            catch (Exception e) {
                String msg = "Unable to save component settings for group '%s' and key '%s' due to unexpected exception";
                String fmsg = String.format("Unable to save component settings for group '%s' and key '%s' due to unexpected exception", ((Configuration)this.configuration).group(), ((Configuration)this.configuration).key());
                LoggerFactory.getLogger(SettingsProcessor.class).error(fmsg, (Throwable)e);
            }
            finally {
                this.saving = false;
            }
        }
    }

    protected abstract void saveSettings(@NotNull C var1);

    protected void saveSettings(@Nullable V value) {
        K configuration = this.configuration();
        SettingsManager.set((String)((Configuration)configuration).group(), (String)((Configuration)configuration).key(), value);
    }
}

