/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.StyleException;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.SwingUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public final class Bounds {
    @Nullable
    private final Bounds parent;
    @NotNull
    private final BoundsType type;
    @NotNull
    private final Rectangle bounds;

    public Bounds(@NotNull Dimension dimension) {
        this.parent = null;
        this.type = BoundsType.component;
        this.bounds = new Rectangle(0, 0, dimension.width, dimension.height);
    }

    public Bounds(@NotNull JComponent component) {
        this.parent = null;
        this.type = BoundsType.component;
        this.bounds = new Rectangle(0, 0, component.getWidth(), component.getHeight());
    }

    public Bounds(@NotNull JComponent component, int x, int y) {
        this.parent = null;
        this.type = BoundsType.component;
        this.bounds = new Rectangle(x, y, component.getWidth(), component.getHeight());
    }

    public Bounds(@NotNull Bounds parent, @NotNull Rectangle bounds) {
        this.parent = parent;
        this.type = BoundsType.section;
        this.bounds = new Rectangle(bounds);
    }

    public Bounds(@NotNull Bounds parent, @NotNull BoundsType type, @NotNull JComponent component, @NotNull IDecoration decoration) {
        this.parent = parent;
        this.type = type;
        Insets insets = decoration.isSection() ? type.insets(component, decoration) : type.insets(component);
        this.bounds = SwingUtils.shrink(parent.get(), insets);
    }

    @NotNull
    public BoundsType type() {
        return this.type;
    }

    @NotNull
    public Rectangle get() {
        return this.bounds;
    }

    @NotNull
    public Rectangle get(@NotNull BoundsType type) {
        Bounds bounds = this;
        while (bounds != null) {
            if (bounds.type == type) {
                return bounds.bounds;
            }
            bounds = bounds.parent;
        }
        throw new StyleException(String.format("Unknown bounds type '%s' requested", type.name()));
    }
}

