/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.managers.icon.IconManager;
import com.alee.managers.icon.set.IconSet;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.SkinExtension;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.XmlSkinExtension;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.SkinInfoConverter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="skin")
@XStreamConverter(value=SkinInfoConverter.class)
public final class SkinInfo
implements Serializable {
    private String id;
    private String skinClass;
    @Nullable
    private List<String> extendedSkins;
    private String supportedSystems;
    private Icon icon;
    private String title;
    private String description;
    private String author;
    private List<IconSet> iconSets;
    private List<ComponentStyle> styles;
    private transient Map<String, Map<String, ComponentStyle>> stylesCache;
    private transient Map<String, Boolean> processedExtensions;

    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(@NotNull String id) {
        this.id = id;
    }

    @NotNull
    public String getSkinClass() {
        if (this.skinClass == null) {
            throw new StyleException("Skin class is not specified");
        }
        return this.skinClass;
    }

    public void setSkinClass(@NotNull String skinClass) {
        this.skinClass = skinClass;
    }

    @Nullable
    public List<String> getExtendedSkins() {
        return this.extendedSkins;
    }

    public void setExtendedSkins(@NotNull List<String> extendedSkins) {
        this.extendedSkins = extendedSkins;
    }

    public boolean isSupported(@NotNull String skinId) {
        List<String> extendedSkins = this.getExtendedSkins();
        if (extendedSkins == null) {
            throw new StyleException("Extension must specify which skins it extends");
        }
        return extendedSkins.contains(skinId);
    }

    @NotNull
    public String getSupportedSystems() {
        return this.supportedSystems;
    }

    public void setSupportedSystems(@NotNull String supportedSystems) {
        this.supportedSystems = supportedSystems;
    }

    @NotNull
    public List<String> getSupportedSystemsList() {
        return TextUtils.stringToList((String)this.supportedSystems, (String)",");
    }

    public void setSupportedSystemsList(@NotNull List<String> supportedSystems) {
        this.supportedSystems = TextUtils.listToString(supportedSystems, (String)",");
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable Icon icon) {
        this.icon = icon;
    }

    @Nullable
    public String getTitle() {
        return this.title != null ? this.title : this.getId();
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(@Nullable String author) {
        this.author = author;
    }

    public void install() {
        this.ensureCacheInitialized();
        for (SkinExtension extension : StyleManager.getExtensions()) {
            this.applyExtension(extension);
        }
        this.clearIconsCache(this.iconSets);
    }

    public void uninstall() {
        this.clearIconsCache(this.iconSets);
    }

    @NotNull
    public List<IconSet> getIconSets() {
        return this.iconSets;
    }

    public void setIconSets(@NotNull List<IconSet> iconSets) {
        this.iconSets = iconSets;
    }

    @NotNull
    public List<ComponentStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(@NotNull List<ComponentStyle> styles) {
        this.styles = styles;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public ComponentStyle getStyle(@NotNull JComponent component) {
        this.ensureCacheInitialized();
        ComponentDescriptor descriptor = StyleManager.getDescriptor(component);
        Map<String, ComponentStyle> componentStyles = this.stylesCache.get(descriptor.getId());
        if (componentStyles != null) {
            String styleId = StyleId.getCompleteId(component);
            ComponentStyle style = componentStyles.get(styleId);
            if (style != null) {
                return style;
            }
            String warn = "Unable to find style '%s' for component: %s";
            LoggerFactory.getLogger(SkinInfo.class).warn(String.format("Unable to find style '%s' for component: %s", styleId, component));
            String defaultStyleId = StyleId.getDefault(component).getCompleteId();
            ComponentStyle defaultStyle = componentStyles.get(defaultStyleId);
            if (defaultStyle != null) {
                return defaultStyle;
            }
            String error = "Unable to find default style for ID '%s' for component: %s";
            throw new StyleException(String.format("Unable to find default style for ID '%s' for component: %s", defaultStyleId, component));
        }
        String error = "Skin '%s' doesn't have any styles for component type: %s";
        throw new StyleException(String.format("Skin '%s' doesn't have any styles for component type: %s", this.getId(), descriptor));
    }

    private void ensureCacheInitialized() {
        if (this.stylesCache == null) {
            this.stylesCache = new LinkedHashMap<String, Map<String, ComponentStyle>>(StyleManager.getDescriptorsCount());
            this.performOverride(this.styles, 0);
            this.buildStyles(this.styles, 0);
            this.gatherStyles(this.styles, this.stylesCache);
        }
    }

    public boolean applyExtension(@NotNull SkinExtension extension) {
        boolean applied;
        if (this.processedExtensions == null) {
            this.processedExtensions = new HashMap<String, Boolean>(1);
        }
        if (!this.processedExtensions.containsKey(extension.getId())) {
            if (extension.isSupported(this.getId())) {
                if (extension instanceof XmlSkinExtension) {
                    this.ensureCacheInitialized();
                    XmlSkinExtension xmlExtension = (XmlSkinExtension)extension;
                    SkinInfo extensionData = xmlExtension.getData(this.getSkinClass());
                    this.applyExtension(extensionData);
                    this.processedExtensions.put(extension.getId(), true);
                    applied = true;
                } else if (CollectionUtils.notEmpty(extension.getIconSets())) {
                    this.applyIconSets(extension.getIconSets());
                    this.processedExtensions.put(extension.getId(), true);
                    applied = true;
                } else {
                    this.processedExtensions.put(extension.getId(), false);
                    applied = false;
                }
            } else {
                this.processedExtensions.put(extension.getId(), false);
                applied = false;
            }
        } else {
            applied = this.processedExtensions.get(extension.getId());
        }
        return applied;
    }

    private void applyExtension(@NotNull SkinInfo extension) {
        this.applyIconSets(extension.getIconSets());
        int startIndex = this.styles.size();
        this.styles.addAll(extension.styles);
        this.performOverride(this.styles, startIndex);
        this.buildStyles(this.styles, startIndex);
        this.gatherStyles(this.styles.subList(startIndex, this.styles.size()), this.stylesCache);
    }

    private void applyIconSets(@NotNull List<IconSet> iconSets) {
        this.iconSets.addAll(iconSets);
        this.clearIconsCache(iconSets);
    }

    private void clearIconsCache(@Nullable List<IconSet> iconSets) {
        if (CollectionUtils.notEmpty(iconSets)) {
            for (IconSet iconSet : iconSets) {
                IconManager.clearIconSetCache(iconSet);
            }
        }
    }

    private void performOverride(@NotNull List<ComponentStyle> styles, int startIndex) {
        int i;
        for (i = startIndex; i < styles.size(); ++i) {
            ComponentStyle currentStyle = styles.get(i);
            for (int j = i + 1; j < styles.size(); ++j) {
                ComponentStyle style = styles.get(j);
                if (!Objects.equals((Object)style.getType(), (Object)currentStyle.getType()) || !Objects.equals((Object)style.getId(), (Object)currentStyle.getId())) continue;
                currentStyle = currentStyle.clone().merge(style);
                styles.set(i, currentStyle);
                styles.remove(j--);
            }
        }
        for (i = startIndex; i < styles.size(); ++i) {
            this.performOverride(styles, styles, i, i);
        }
    }

    private void performOverride(@NotNull List<ComponentStyle> globalStyles, @NotNull List<ComponentStyle> levelStyles, int index, int globalIndex) {
        ComponentStyle style = levelStyles.get(index);
        if (style.getStylesCount() > 0) {
            for (int i = 0; i < style.getStylesCount(); ++i) {
                this.performOverride(globalStyles, style.getNestedStyles(), i, globalIndex);
            }
        }
        String type = style.getType();
        String completeId = style.getCompleteId();
        ComponentDescriptor descriptor = StyleManager.getDescriptor(type);
        String defaultStyleId = descriptor.getDefaultStyleId().getCompleteId();
        ComponentStyle extendedStyle = null;
        if (TextUtils.notEmpty((String)style.getExtendsId())) {
            String extendsId = style.getExtendsId();
            if (extendsId.equals(completeId)) {
                String msg = "Style '%s' extends itself for type: %s";
                throw new StyleException(String.format("Style '%s' extends itself for type: %s", completeId, descriptor));
            }
            extendedStyle = this.findStyle(type, extendsId, style.getId(), levelStyles, globalStyles, index, globalIndex);
            if (extendedStyle == null) {
                String msg = "Style '%s' extends missing style '%s' for type: %s";
                throw new StyleException(String.format("Style '%s' extends missing style '%s' for type: %s", completeId, extendsId, descriptor));
            }
        }
        if (extendedStyle == null) {
            extendedStyle = this.findOverrideStyle(globalStyles, style);
        }
        if (extendedStyle == null && Objects.notEquals((Object)completeId, (Object)defaultStyleId) && (extendedStyle = this.findStyle(type, defaultStyleId, style.getId(), levelStyles, globalStyles, index, globalIndex)) == null) {
            String msg = "Style '%s' extends missing default style '%s' for type: %s";
            throw new StyleException(String.format("Style '%s' extends missing default style '%s' for type: %s", completeId, defaultStyleId, descriptor));
        }
        if (extendedStyle != null) {
            levelStyles.set(index, extendedStyle.clone().merge(style));
        }
    }

    private ComponentStyle findOverrideStyle(@NotNull List<ComponentStyle> globalStyles, @NotNull ComponentStyle style) {
        ArrayList<ComponentStyle> componentStyles = new ArrayList<ComponentStyle>();
        componentStyles.add(style);
        while (((ComponentStyle)componentStyles.get(0)).getParent() != null) {
            componentStyles.add(0, ((ComponentStyle)componentStyles.get(0)).getParent());
        }
        ComponentStyle oldStyle = null;
        while (!componentStyles.isEmpty()) {
            int maxIndex;
            ComponentStyle currentStyle = (ComponentStyle)componentStyles.remove(0);
            List<ComponentStyle> styles = oldStyle == null ? globalStyles : oldStyle.getNestedStyles();
            int n = maxIndex = oldStyle == null ? globalStyles.indexOf(currentStyle) : Integer.MAX_VALUE;
            oldStyle = this.findStyle(currentStyle.getType(), currentStyle.getId(), styles, maxIndex);
            if (oldStyle != null || (oldStyle = this.findStyle(currentStyle.getType(), currentStyle.getExtendsId(), styles, maxIndex)) != null || (oldStyle = this.findStyle(currentStyle.getType(), currentStyle.getType(), styles, maxIndex)) != null) continue;
            break;
        }
        return oldStyle;
    }

    private void gatherStyles(@NotNull List<ComponentStyle> styles, @NotNull Map<String, Map<String, ComponentStyle>> stylesCache) {
        for (ComponentStyle style : styles) {
            String type = style.getType();
            Map<String, ComponentStyle> componentStyles = stylesCache.get(type);
            if (componentStyles == null) {
                componentStyles = new LinkedHashMap<String, ComponentStyle>(1);
                stylesCache.put(type, componentStyles);
            }
            componentStyles.put(style.getCompleteId(), style);
            this.gatherStyles(style.getNestedStyles(), stylesCache);
        }
    }

    private void buildStyles(@NotNull List<ComponentStyle> styles, int startIndex) {
        HashMap<String, List<String>> builtStyles = new HashMap<String, List<String>>();
        for (ComponentDescriptor descriptor : StyleManager.getDescriptors()) {
            builtStyles.put(descriptor.getId(), new ArrayList(1));
        }
        ArrayList<String> building = new ArrayList<String>();
        for (int i = startIndex; i < styles.size(); ++i) {
            this.buildStyle(styles, i, building, builtStyles);
        }
    }

    @NotNull
    private ComponentStyle buildStyle(@NotNull List<ComponentStyle> levelStyles, int index, @NotNull List<String> building, @NotNull Map<String, List<String>> builtStyles) {
        ComponentStyle style = levelStyles.get(index);
        String type = style.getType();
        ComponentDescriptor descriptor = StyleManager.getDescriptor(type);
        String completeId = style.getCompleteId();
        String uniqueId = type + ":" + completeId;
        if (building.contains(uniqueId)) {
            String msg = "Style '%s' is used within cyclic references for type: %s";
            throw new StyleException(String.format("Style '%s' is used within cyclic references for type: %s", completeId, descriptor));
        }
        if (!builtStyles.get(type).contains(completeId)) {
            building.add(uniqueId);
            if (style.getStylesCount() > 0) {
                for (int i = 0; i < style.getStylesCount(); ++i) {
                    this.buildStyle(style.getNestedStyles(), i, building, builtStyles);
                }
            }
            builtStyles.get(type).add(completeId);
            building.remove(uniqueId);
        }
        return style;
    }

    @Nullable
    private ComponentStyle findStyle(@NotNull String type, @NotNull String id, @NotNull String excludeId, @NotNull List<ComponentStyle> levelStyles, @NotNull List<ComponentStyle> styles, int maxIndex, int globalIndex) {
        ComponentStyle style;
        ComponentStyle result = null;
        if (levelStyles != styles && (style = this.findStyle(type, id, levelStyles, maxIndex)) != null && Objects.notEquals((Object)style.getId(), (Object)excludeId)) {
            result = style;
        }
        if (result == null) {
            result = this.findStyle(type, id, styles, globalIndex);
        }
        return result;
    }

    @Nullable
    private ComponentStyle findStyle(@NotNull String type, @Nullable String id, @NotNull List<ComponentStyle> styles, int maxIndex) {
        ComponentStyle result = null;
        for (int i = 0; i < styles.size() && i < maxIndex; ++i) {
            ComponentStyle style = styles.get(i);
            if (!Objects.equals((Object)style.getType(), (Object)type) || !Objects.equals((Object)style.getId(), (Object)id)) continue;
            result = style;
        }
        return result;
    }

    @NotNull
    public String toString() {
        return this.getTitle() != null ? this.getTitle() : this.getId();
    }
}

