/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.BiConsumer;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.tooltip.TooltipAdapter;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.swing.WeakComponentData;
import com.alee.utils.swing.WeakComponentDataOrderedSet;
import com.alee.utils.swing.WebTimer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;

public final class TooltipManager {
    private static int defaultDelay = 400;
    private static boolean allowMultipleTooltips = true;
    private static boolean showHotkeysInTooltips = true;
    private static boolean showHotkeysInOneTimeTooltips = false;
    private static final WeakComponentDataOrderedSet<JComponent, WebCustomTooltip> webTooltips = new WeakComponentDataOrderedSet("TooltipManager.WebCustomTooltip", 50);
    private static final WeakComponentData<JComponent, MouseAdapter> adapters = new WeakComponentData("TooltipManager.MouseAdapter", 50);
    private static final WeakComponentData<JComponent, WebTimer> timers = new WeakComponentData("TooltipManager.WebTimer", 50);
    private static final List<WebCustomTooltip> oneTimeTooltips = new ArrayList<WebCustomTooltip>();
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event instanceof MouseWheelEvent) {
                        TooltipManager.hideAllTooltips();
                    }
                }
            }, 131072L);
        }
    }

    public static void hideAllTooltips() {
        timers.forEach((BiConsumer)new BiConsumer<JComponent, WebTimer>(){

            public void accept(JComponent component, WebTimer webTimer) {
                webTimer.stop();
            }
        });
        webTooltips.forEachData((BiConsumer)new BiConsumer<JComponent, WebCustomTooltip>(){

            public void accept(JComponent component, WebCustomTooltip webCustomTooltip) {
                webCustomTooltip.closeTooltip();
            }
        });
        for (WebCustomTooltip tooltip : CollectionUtils.copy(oneTimeTooltips)) {
            tooltip.closeTooltip();
        }
    }

    public static WebCustomTooltip setTooltip(JComponent component, String tooltip) {
        return TooltipManager.setTooltip(component, tooltip, null);
    }

    public static WebCustomTooltip setTooltip(JComponent component, String tooltip, int delay) {
        return TooltipManager.setTooltip(component, tooltip, null, delay);
    }

    public static WebCustomTooltip setTooltip(JComponent component, Icon icon, String tooltip) {
        return TooltipManager.setTooltip(component, icon, tooltip, null);
    }

    public static WebCustomTooltip setTooltip(JComponent component, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip(component, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip setTooltip(JComponent component, Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip(component, icon, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip setTooltip(JComponent component, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip(component, null, tooltip, tooltipWay, delay);
    }

    public static WebCustomTooltip setTooltip(JComponent component, Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip(component, WebCustomTooltip.createDefaultComponent(icon, tooltip), tooltipWay, delay);
    }

    public static WebCustomTooltip setTooltip(JComponent component, JComponent tooltip) {
        return TooltipManager.setTooltip(component, tooltip, null);
    }

    public static WebCustomTooltip setTooltip(JComponent component, JComponent tooltip, int delay) {
        return TooltipManager.setTooltip(component, tooltip, null, delay);
    }

    public static WebCustomTooltip setTooltip(JComponent component, JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip(component, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip setTooltip(JComponent component, JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip(component, tooltip, tooltipWay, delay, true);
    }

    public static WebCustomTooltip addTooltip(JComponent component, String tooltip) {
        return TooltipManager.addTooltip(component, tooltip, null);
    }

    public static WebCustomTooltip addTooltip(JComponent component, String tooltip, int delay) {
        return TooltipManager.addTooltip(component, tooltip, null, delay);
    }

    public static WebCustomTooltip addTooltip(JComponent component, Icon icon, String tooltip) {
        return TooltipManager.addTooltip(component, icon, tooltip, null);
    }

    public static WebCustomTooltip addTooltip(JComponent component, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip(component, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip addTooltip(JComponent component, Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip(component, icon, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip addTooltip(JComponent component, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip(component, null, tooltip, tooltipWay, delay);
    }

    public static WebCustomTooltip addTooltip(JComponent component, Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip(component, WebCustomTooltip.createDefaultComponent(icon, tooltip), tooltipWay, delay);
    }

    public static WebCustomTooltip addTooltip(JComponent component, JComponent tooltip) {
        return TooltipManager.addTooltip(component, tooltip, null);
    }

    public static WebCustomTooltip addTooltip(JComponent component, JComponent tooltip, int delay) {
        return TooltipManager.addTooltip(component, tooltip, null, delay);
    }

    public static WebCustomTooltip addTooltip(JComponent component, JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip(component, tooltip, tooltipWay, defaultDelay);
    }

    public static WebCustomTooltip addTooltip(JComponent component, JComponent tooltip, TooltipWay tooltipWay, int delay) {
        boolean clear = webTooltips.containsData(component) && !allowMultipleTooltips;
        return TooltipManager.addTooltip(component, tooltip, tooltipWay, delay, clear);
    }

    private static WebCustomTooltip addTooltip(final JComponent component, JComponent tooltip, TooltipWay tooltipWay, int delay, boolean clear) {
        if (clear) {
            TooltipManager.removeTooltips(component);
        }
        WebCustomTooltip customTooltip = new WebCustomTooltip((Component)component, tooltip, tooltipWay, showHotkeysInTooltips);
        webTooltips.add(component, (Object)customTooltip);
        if (!timers.contains(component)) {
            final WebTimer showTips = new WebTimer("TooltipManager.displayTimer", (long)delay);
            showTips.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Window window = CoreSwingUtils.getWindowAncestor((Component)component);
                    if (window != null && window.isShowing()) {
                        TooltipManager.showTooltips(component, false);
                    }
                }
            });
            showTips.setRepeats(false);
            timers.set(component, (Object)showTips);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.displayTooltips();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.cancelTooltips();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.cancelTooltips();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.cancelTooltips();
                }

                private void displayTooltips() {
                    Window window = CoreSwingUtils.getWindowAncestor((Component)component);
                    if (window != null && window.isShowing()) {
                        showTips.start();
                    }
                }

                private void cancelTooltips() {
                    showTips.stop();
                    TooltipManager.hideTooltips(component);
                }
            };
            component.addMouseListener(mouseAdapter);
            adapters.set(component, (Object)mouseAdapter);
        }
        return customTooltip;
    }

    private static void hideTooltips(JComponent component) {
        Set tips = (Set)webTooltips.get(component);
        if (tips != null) {
            ArrayList tooltips = new ArrayList();
            tooltips.addAll(tips);
            for (WebCustomTooltip tooltip : tooltips) {
                tooltip.closeTooltip();
            }
        }
    }

    public static boolean showTooltips(JComponent component) {
        return TooltipManager.showTooltips(component, false);
    }

    public static boolean showTooltips(JComponent component, boolean delayed) {
        if (webTooltips.contains(component) && component.isShowing()) {
            if (delayed) {
                ((WebTimer)timers.get(component)).restart();
            } else {
                final WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(component);
                if (webGlassPane != null) {
                    webTooltips.forEachData(component, (BiConsumer)new BiConsumer<JComponent, WebCustomTooltip>(){

                        public void accept(JComponent component, WebCustomTooltip webCustomTooltip) {
                            webGlassPane.showComponent(webCustomTooltip);
                        }
                    });
                }
            }
            return true;
        }
        return false;
    }

    public static void showAllTooltips(JComponent component) {
        TooltipManager.hideAllTooltips();
        TooltipManager.showAllTooltips(CoreSwingUtils.getNonNullWindowAncestor((Component)component));
    }

    private static void showAllTooltips(final Window window) {
        if (window.isShowing()) {
            webTooltips.forEachData((BiConsumer)new BiConsumer<JComponent, WebCustomTooltip>(){

                public void accept(JComponent component, WebCustomTooltip webCustomTooltip) {
                    if (CoreSwingUtils.getWindowAncestor((Component)component) == window && component.isShowing()) {
                        TooltipManager.showOneTimeTooltip(webCustomTooltip, false);
                    }
                }
            });
        }
    }

    public static void showAllTooltips() {
        webTooltips.forEachData((BiConsumer)new BiConsumer<JComponent, WebCustomTooltip>(){

            public void accept(JComponent component, WebCustomTooltip webCustomTooltip) {
                if (component.isShowing()) {
                    TooltipManager.showOneTimeTooltip(webCustomTooltip, false);
                }
            }
        });
    }

    public static void installShowAllTooltipsAction(JComponent topComponent) {
        TooltipManager.installShowAllTooltipsAction(topComponent, Hotkey.F2);
    }

    public static void installShowAllTooltipsAction(final JComponent topComponent, HotkeyData hotkeyData) {
        HotkeyManager.registerHotkey(topComponent, hotkeyData, new HotkeyRunnable(){

            @Override
            public void run(@NotNull KeyEvent e) {
                TooltipManager.showAllTooltips(topComponent);
            }
        }, true);
    }

    public static void removeTooltips(JComponent component) {
        Set tips = (Set)webTooltips.get(component);
        if (tips != null) {
            for (WebCustomTooltip tooltip : CollectionUtils.copy((Collection)tips)) {
                TooltipManager.removeTooltip(component, tooltip);
            }
        }
    }

    public static void removeTooltips(JComponent component, WebCustomTooltip ... tooltips) {
        for (WebCustomTooltip tooltip : tooltips) {
            TooltipManager.removeTooltip(component, tooltip);
        }
    }

    public static void removeTooltips(JComponent component, List<WebCustomTooltip> tooltips) {
        for (WebCustomTooltip tooltip : tooltips) {
            TooltipManager.removeTooltip(component, tooltip);
        }
    }

    public static void removeTooltip(JComponent component, WebCustomTooltip tooltip) {
        webTooltips.remove(component, (Object)tooltip, (BiConsumer)new BiConsumer<JComponent, WebCustomTooltip>(){

            public void accept(JComponent component, WebCustomTooltip webCustomTooltip) {
                if (webTooltips.size(component) == 0) {
                    adapters.clear(component, (BiConsumer)new BiConsumer<JComponent, MouseAdapter>(){

                        public void accept(JComponent component, MouseAdapter mouseAdapter) {
                            component.removeMouseListener(mouseAdapter);
                        }
                    });
                    timers.clear(component, (BiConsumer)new BiConsumer<JComponent, WebTimer>(){

                        public void accept(JComponent component, WebTimer webTimer) {
                            webTimer.stop();
                        }
                    });
                }
                webCustomTooltip.closeTooltip();
                webCustomTooltip.destroyTooltip();
            }
        });
    }

    public static WebCustomTooltip showOneTimeTooltip(JComponent component, Point point, String tooltip) {
        return TooltipManager.showOneTimeTooltip(component, point, tooltip, null);
    }

    public static WebCustomTooltip showOneTimeTooltip(JComponent component, Point point, Icon icon, String tooltip) {
        return TooltipManager.showOneTimeTooltip(component, point, icon, tooltip, null);
    }

    public static WebCustomTooltip showOneTimeTooltip(JComponent component, Point point, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.showOneTimeTooltip(component, point, null, tooltip, tooltipWay);
    }

    public static WebCustomTooltip showOneTimeTooltip(JComponent component, Point point, Icon icon, String tooltip, TooltipWay tooltipWay) {
        WebCustomTooltip customTooltip = new WebCustomTooltip(component, icon, tooltip, tooltipWay, showHotkeysInOneTimeTooltips);
        customTooltip.setDisplayLocation(point);
        return TooltipManager.showOneTimeTooltip(customTooltip, true);
    }

    public static WebCustomTooltip showOneTimeTooltip(JComponent component, Point point, JComponent tooltip) {
        return TooltipManager.showOneTimeTooltip(component, point, tooltip, null);
    }

    public static WebCustomTooltip showOneTimeTooltip(JComponent component, Point point, JComponent tooltip, TooltipWay tooltipWay) {
        WebCustomTooltip customTooltip = new WebCustomTooltip((Component)component, tooltip, tooltipWay, showHotkeysInOneTimeTooltips);
        customTooltip.setDisplayLocation(point);
        return TooltipManager.showOneTimeTooltip(customTooltip, true);
    }

    public static WebCustomTooltip showOneTimeTooltip(WebCustomTooltip customTooltip) {
        return TooltipManager.showOneTimeTooltip(customTooltip, true);
    }

    private static WebCustomTooltip showOneTimeTooltip(final WebCustomTooltip customTooltip, final boolean destroyOnClose) {
        if (customTooltip.getComponent() == null || !customTooltip.getComponent().isShowing()) {
            return null;
        }
        final WebGlassPane webGlassPane = GlassPaneManager.getGlassPane(customTooltip.getComponent());
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                customTooltip.updateLocation();
            }
        };
        webGlassPane.addComponentListener(componentAdapter);
        final AWTEventListener closeListener = customTooltip.isDefaultCloseBehavior() ? new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent && event.getID() == 501) {
                    customTooltip.closeTooltip();
                }
            }
        } : null;
        customTooltip.addTooltipListener(new TooltipAdapter(){

            @Override
            public void tooltipShowing() {
                if (customTooltip.isDefaultCloseBehavior()) {
                    Toolkit.getDefaultToolkit().addAWTEventListener(closeListener, 16L);
                }
            }

            @Override
            public void tooltipHidden() {
                customTooltip.removeTooltipListener(this);
                if (customTooltip.isDefaultCloseBehavior()) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(closeListener);
                }
                oneTimeTooltips.remove(customTooltip);
                webGlassPane.removeComponentListener(componentAdapter);
                if (destroyOnClose) {
                    customTooltip.destroyTooltip();
                }
            }
        });
        oneTimeTooltips.add(customTooltip);
        webGlassPane.showComponent(customTooltip);
        return customTooltip;
    }

    public static int getDefaultDelay() {
        return defaultDelay;
    }

    public static void setDefaultDelay(int delay) {
        defaultDelay = delay;
    }

    public static boolean isAllowMultipleTooltips() {
        return allowMultipleTooltips;
    }

    public static void setAllowMultipleTooltips(boolean allowMultipleTooltips) {
        TooltipManager.allowMultipleTooltips = allowMultipleTooltips;
    }

    public static boolean isShowHotkeysInTooltips() {
        return showHotkeysInTooltips;
    }

    public static void setShowHotkeysInTooltips(boolean showHotkeysInTooltips) {
        TooltipManager.showHotkeysInTooltips = showHotkeysInTooltips;
    }

    public static boolean isShowHotkeysInOneTimeTooltips() {
        return showHotkeysInOneTimeTooltips;
    }

    public static void setShowHotkeysInOneTimeTooltips(boolean showHotkeysInOneTimeTooltips) {
        TooltipManager.showHotkeysInOneTimeTooltips = showHotkeysInOneTimeTooltips;
    }
}

