/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.style.Bounds;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.painter.SectionPainter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.MapUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.laf.WebBorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public abstract class AbstractPainter<C extends JComponent, U extends ComponentUI>
implements Painter<C, U> {
    protected transient PropertyChangeListener propertyChangeListener;
    protected transient boolean installed;
    protected transient C component;
    protected transient U ui;
    protected transient Map<String, SectionPainter<C, U>> sectionPainters;
    protected transient boolean ltr;

    @Override
    public void install(@NotNull C c, @NotNull U ui) {
        WebLookAndFeel.installEventDispatchThreadCheckers(c);
        this.component = c;
        this.ui = ui;
        this.beforeInstall();
        this.installSectionPainters();
        this.installPropertiesAndListeners();
        this.afterInstall();
    }

    @Override
    public void uninstall(@NotNull C c, @NotNull U ui) {
        WebLookAndFeel.uninstallEventDispatchThreadCheckers(c);
        this.beforeUninstall();
        this.uninstallPropertiesAndListeners();
        this.uninstallSectionPainters();
        this.afterUninstall();
        this.component = null;
        this.ui = null;
    }

    protected void beforeInstall() {
        this.installed = true;
    }

    protected void afterInstall() {
        this.updateBorder();
    }

    protected void beforeUninstall() {
    }

    protected void afterUninstall() {
        this.installed = false;
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    @Override
    @Nullable
    public Boolean isOpaque() {
        return null;
    }

    protected boolean isSettingsUpdateAllowed() {
        WebLookAndFeel.checkEventDispatchThread();
        return this.isInstalled() && !this.isSectionPainter();
    }

    protected boolean isSectionPainter() {
        return this instanceof SectionPainter;
    }

    protected final void installSectionPainters() {
        List<SectionPainter<C, U>> sectionPainters = this.getSectionPainters();
        if (CollectionUtils.notEmpty(sectionPainters)) {
            for (SectionPainter<C, U> sectionPainter : sectionPainters) {
                this.installSectionPainter(sectionPainter);
            }
        }
    }

    protected final void uninstallSectionPainters() {
        List<SectionPainter<C, U>> sectionPainters = this.getInstalledSectionPainters();
        if (CollectionUtils.notEmpty(sectionPainters)) {
            for (SectionPainter<C, U> sectionPainter : sectionPainters) {
                this.uninstallSectionPainter(sectionPainter);
            }
        }
    }

    @Nullable
    protected List<SectionPainter<C, U>> getSectionPainters() {
        return null;
    }

    @Nullable
    protected final List<SectionPainter<C, U>> asList(SectionPainter<C, U> ... sections) {
        ArrayList<SectionPainter<C, U>> list = null;
        if (sections != null) {
            for (SectionPainter<C, U> section : sections) {
                if (section == null) continue;
                if (list == null) {
                    list = new ArrayList<SectionPainter<C, U>>(sections.length);
                }
                list.add(section);
            }
        }
        return list;
    }

    @Nullable
    protected final List<SectionPainter<C, U>> getInstalledSectionPainters() {
        return MapUtils.notEmpty(this.sectionPainters) ? new ArrayList<SectionPainter<C, U>>(this.sectionPainters.values()) : null;
    }

    protected final void installSectionPainter(@NotNull SectionPainter<C, U> painter) {
        String sectionId;
        SectionPainter<C, U> old;
        if (this.sectionPainters == null) {
            this.sectionPainters = new HashMap<String, SectionPainter<C, U>>(3);
        }
        if ((old = this.sectionPainters.get(sectionId = painter.getSectionId())) != null) {
            old.uninstall(this.component, this.ui, this);
        }
        painter.install(this.component, this.ui, this);
        this.sectionPainters.put(sectionId, painter);
    }

    protected final void uninstallSectionPainter(@NotNull SectionPainter<C, U> painter) {
        String sectionId = painter.getSectionId();
        this.sectionPainters.remove(sectionId);
        painter.uninstall(this.component, this.ui, this);
    }

    protected void paintSection(@NotNull SectionPainter painter, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        if (SystemUtils.isUnix()) {
            g2d.translate(bounds.x, bounds.y);
            Rectangle section = new Rectangle(0, 0, bounds.width, bounds.height);
            Shape oc = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)section);
            Bounds componentBounds = new Bounds((JComponent)this.component, -bounds.x, -bounds.y);
            Bounds sectionBounds = new Bounds(componentBounds, section);
            painter.paint(g2d, this.component, this.ui, sectionBounds);
            GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)oc);
            g2d.translate(-bounds.x, -bounds.y);
        } else {
            Shape oc = GraphicsUtils.intersectClip((Graphics2D)g2d, (Shape)bounds);
            Bounds componentBounds = new Bounds((JComponent)this.component);
            Bounds sectionBounds = new Bounds(componentBounds, bounds);
            painter.paint(g2d, this.component, this.ui, sectionBounds);
            GraphicsUtils.restoreClip((Graphics2D)g2d, (Shape)oc);
        }
    }

    protected void installPropertiesAndListeners() {
        this.updateOrientation();
        this.saveOrientation();
        this.installPropertyChangeListener();
    }

    protected void uninstallPropertiesAndListeners() {
        this.uninstallPropertyChangeListener();
    }

    protected void installPropertyChangeListener() {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebLookAndFeel.checkEventDispatchThread();
                if (AbstractPainter.this.component != null) {
                    AbstractPainter.this.propertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            }
        };
        ((Container)this.component).addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        if (Objects.equals((Object)property, (Object)"componentOrientation")) {
            this.orientationChange();
        }
        if (Objects.equals((Object)property, (Object)"border")) {
            this.borderChange((Border)newValue);
        }
        if (Objects.equals((Object)property, (Object[])new Object[]{"lafMargin", "lafPadding"})) {
            this.updateBorder();
        }
    }

    protected void uninstallPropertyChangeListener() {
        ((Component)this.component).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void orientationChange() {
        this.saveOrientation();
        this.revalidate();
        this.repaint();
    }

    protected void saveOrientation() {
        this.ltr = ((Component)this.component).getComponentOrientation().isLeftToRight();
    }

    protected void updateOrientation() {
        if (this.isSettingsUpdateAllowed()) {
            WebLookAndFeel.setOrientation(this.component);
        }
    }

    protected void borderChange(Border border) {
        boolean newHonor;
        boolean oldHonor = SwingUtils.getHonorUserBorders(this.component);
        boolean bl = newHonor = !SwingUtils.isUIResource(border);
        if (oldHonor != newHonor) {
            SwingUtils.setHonorUserBorders(this.component, newHonor);
        }
        if (!newHonor && !(border instanceof WebBorder)) {
            this.updateBorder();
        }
    }

    protected Insets getCompleteBorder() {
        Insets border;
        if (this.component != null && !SwingUtils.isPreserveBorders(this.component)) {
            Insets borders;
            border = new Insets(0, 0, 0, 0);
            if (!this.isSectionPainter()) {
                Insets margin = PainterSupport.getMargin(this.component, true);
                SwingUtils.increase(border, margin);
            }
            if ((borders = this.getBorder()) != null) {
                border.top += borders.top;
                border.left = border.left + (this.ltr ? borders.left : borders.right);
                border.bottom += borders.bottom;
                border.right = border.right + (this.ltr ? borders.right : borders.left);
            }
            if (!this.isSectionPainter()) {
                Insets padding = PainterSupport.getPadding(this.component, true);
                SwingUtils.increase(border, padding);
            }
        } else {
            border = null;
        }
        return border;
    }

    @Nullable
    protected Insets getBorder() {
        return null;
    }

    @Override
    public boolean contains(@NotNull C c, @NotNull U ui, @NotNull Bounds bounds, int x, int y) {
        return bounds.get().contains(x, y);
    }

    @Override
    public int getBaseline(@NotNull C c, @NotNull U ui, @NotNull Bounds bounds) {
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull C c, @NotNull U ui) {
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return SwingUtils.increase(new Dimension(0, 0), this.getCompleteBorder());
    }

    protected void updateBorder() {
        Border old;
        Insets border;
        if (this.isSettingsUpdateAllowed() && (border = this.getCompleteBorder()) != null && (!((old = ((JComponent)this.component).getBorder()) instanceof WebBorder) || Objects.notEquals((Object)((WebBorder)old).getBorderInsets(), (Object)border))) {
            ((JComponent)this.component).setBorder(new WebBorder(border));
        }
    }

    protected void repaint() {
        this.repaint(0, 0, ((JComponent)this.component).getWidth(), ((JComponent)this.component).getHeight());
    }

    protected void repaint(Rectangle bounds) {
        this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    protected void repaint(int x, int y, int width, int height) {
        if (this.isSettingsUpdateAllowed() && ((Component)this.component).isShowing()) {
            ((Component)this.component).repaint(x, y, width, height);
        }
    }

    protected void revalidate() {
        this.updateBorder();
        if (this.isSettingsUpdateAllowed()) {
            ((JComponent)this.component).revalidate();
        }
    }

    protected void updateOpacity() {
        Boolean opaque;
        if (this.isSettingsUpdateAllowed() && (opaque = this.isOpaque()) != null) {
            LookAndFeel.installProperty(this.component, "opaque", opaque != false ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void updateAll() {
        this.updateOpacity();
        this.revalidate();
        this.repaint();
    }
}

