/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.PainterShapeProvider;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PaintParameters;
import com.alee.painter.Painter;
import com.alee.painter.PainterException;
import com.alee.painter.ParameterizedPaint;
import com.alee.painter.SpecificPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WeakComponentData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public final class PainterSupport {
    @NotNull
    private static final WeakComponentData<JComponent, Painter> installedPainters = new WeakComponentData("PainterSupport.painter", 200);
    @NotNull
    private static final WeakComponentData<JComponent, Insets> margins = new WeakComponentData("PainterSupport.margin", 200);
    @NotNull
    private static final WeakComponentData<JComponent, Insets> paddings = new WeakComponentData("PainterSupport.padding", 200);
    @NotNull
    private static final WeakComponentData<JComponent, Boolean> shapeDetectionEnabled = new WeakComponentData("PainterSupport.shapeDetectionEnabled", 200);

    @Nullable
    public static Painter getPainter(@Nullable Component component) {
        return component instanceof JComponent ? (Painter)installedPainters.get((JComponent)component) : null;
    }

    public static void setPainter(@NotNull JComponent component, @NotNull ComponentUI componentUI, @Nullable Painter painter) {
        ComponentDescriptor descriptor = StyleManager.getDescriptor(component);
        Object newPainter = PainterSupport.getApplicablePainter(painter, descriptor.getPainterInterface(), descriptor.getPainterAdapterClass());
        Painter oldPainter = (Painter)installedPainters.get(component);
        if (oldPainter != null) {
            oldPainter.uninstall(component, componentUI);
            installedPainters.clear(component);
        }
        if (newPainter != null) {
            newPainter.install((JComponent)component, (ComponentUI)componentUI);
            installedPainters.set(component, newPainter);
            Boolean opaque = newPainter.isOpaque();
            if (opaque != null) {
                LookAndFeel.installProperty(component, "opaque", opaque != false ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        SwingUtils.firePropertyChanged(component, "painter", oldPainter, newPainter);
    }

    private static <P extends SpecificPainter> P getApplicablePainter(@Nullable Painter painter, @NotNull Class<P> requested, @NotNull Class<? extends P> adaptiveClass) {
        SpecificPainter result = painter != null ? (ReflectUtils.isAssignable(requested, painter.getClass()) ? (SpecificPainter)painter : (SpecificPainter)ReflectUtils.createInstanceSafely(adaptiveClass, (Object[])new Object[]{painter})) : null;
        return (P)result;
    }

    @Nullable
    public static Insets getInsets(@Nullable Component component) {
        Insets insets = component instanceof JComponent ? ((JComponent)component).getInsets() : null;
        return insets;
    }

    @Nullable
    public static Insets getMargin(@NotNull JComponent component) {
        return PainterSupport.getMargin(component, false);
    }

    @Nullable
    public static Insets getMargin(@NotNull JComponent component, boolean applyOrientation) {
        Insets result;
        Insets margin = (Insets)margins.get(component);
        if (margin != null) {
            if (applyOrientation) {
                boolean ltr = component.getComponentOrientation().isLeftToRight();
                result = new Insets(margin.top, ltr ? margin.left : margin.right, margin.bottom, ltr ? margin.right : margin.left);
            } else {
                result = new Insets(margin.top, margin.left, margin.bottom, margin.right);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static void setMargin(@NotNull JComponent component, int margin) {
        PainterSupport.setMargin(component, margin, margin, margin, margin);
    }

    public static void setMargin(@NotNull JComponent component, int top, int left, int bottom, int right) {
        PainterSupport.setMargin(component, new Insets(top, left, bottom, right));
    }

    public static void setMargin(@NotNull JComponent component, @Nullable Insets margin) {
        Insets oldMargin = (Insets)margins.get(component);
        if (oldMargin == null || oldMargin instanceof UIResource || !(margin instanceof UIResource)) {
            margins.set(component, (Object)margin);
            SwingUtils.firePropertyChanged(component, "lafMargin", oldMargin, margin);
        }
    }

    @Nullable
    public static Insets getPadding(@NotNull JComponent component) {
        return PainterSupport.getPadding(component, false);
    }

    @Nullable
    public static Insets getPadding(@NotNull JComponent component, boolean applyOrientation) {
        Insets result;
        Insets padding = (Insets)paddings.get(component);
        if (padding != null) {
            if (applyOrientation) {
                boolean ltr = component.getComponentOrientation().isLeftToRight();
                result = new Insets(padding.top, ltr ? padding.left : padding.right, padding.bottom, ltr ? padding.right : padding.left);
            } else {
                result = new Insets(padding.top, padding.left, padding.bottom, padding.right);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static void setPadding(@NotNull JComponent component, int padding) {
        PainterSupport.setPadding(component, padding, padding, padding, padding);
    }

    public static void setPadding(@NotNull JComponent component, int top, int left, int bottom, int right) {
        PainterSupport.setPadding(component, new Insets(top, left, bottom, right));
    }

    public static void setPadding(@NotNull JComponent component, @Nullable Insets padding) {
        Insets oldPadding = (Insets)paddings.get(component);
        if (oldPadding == null || oldPadding instanceof UIResource || !(padding instanceof UIResource)) {
            paddings.set(component, (Object)padding);
            SwingUtils.firePropertyChanged(component, "lafPadding", oldPadding, padding);
        }
    }

    @NotNull
    public static Shape getShape(@NotNull JComponent component) {
        Painter painter = PainterSupport.getPainter(component);
        Shape shape = painter instanceof PainterShapeProvider ? ((PainterShapeProvider)((Object)painter)).provideShape(component, BoundsType.margin.bounds(component)) : BoundsType.margin.bounds(component);
        return shape;
    }

    public static boolean isShapeDetectionEnabled(@NotNull JComponent component) {
        Boolean enabled = (Boolean)shapeDetectionEnabled.get(component);
        return enabled != null ? enabled : WebLookAndFeel.isShapeDetectionEnabled();
    }

    public static void setShapeDetectionEnabled(@NotNull JComponent component, boolean enabled) {
        shapeDetectionEnabled.set(component, (Object)enabled);
    }

    public static boolean contains(@NotNull JComponent component, @NotNull ComponentUI componentUI, int x, int y) {
        Painter painter = PainterSupport.getPainter(component);
        boolean contains = painter != null && PainterSupport.isShapeDetectionEnabled(component) ? painter.contains(component, componentUI, new Bounds(component), x, y) : 0 <= x && x < component.getWidth() && 0 <= y && y < component.getHeight();
        return contains;
    }

    public static int getBaseline(@NotNull JComponent component, @NotNull ComponentUI componentUI, int width, int height) {
        Border border;
        int baseline = -1;
        Painter painter = PainterSupport.getPainter(component);
        if (painter != null) {
            Bounds componentBounds = new Bounds(new Dimension(width, height));
            baseline = painter.getBaseline(component, componentUI, componentBounds);
        }
        if (baseline == -1 && (border = component.getBorder()) instanceof AbstractBorder) {
            baseline = ((AbstractBorder)border).getBaseline(component, width, height);
        }
        return baseline;
    }

    @NotNull
    public static Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent component, @NotNull ComponentUI componentUI) {
        Component.BaselineResizeBehavior behavior;
        Painter painter = PainterSupport.getPainter(component);
        if (painter != null) {
            behavior = painter.getBaselineResizeBehavior(component, componentUI);
        } else {
            Border border = component.getBorder();
            if (border instanceof AbstractBorder) {
                AbstractBorder abstractBorder = (AbstractBorder)border;
                behavior = abstractBorder.getBaselineResizeBehavior(component);
            } else {
                behavior = Component.BaselineResizeBehavior.OTHER;
            }
        }
        return behavior;
    }

    public static void paint(@NotNull Graphics g, @NotNull JComponent component, @NotNull ComponentUI ui) {
        Painter painter = PainterSupport.getPainter(component);
        if (painter != null) {
            painter.paint((Graphics2D)g, component, ui, new Bounds(component));
        }
    }

    public static void paint(@NotNull Graphics g, @NotNull JComponent component, @NotNull ComponentUI ui, @NotNull PaintParameters parameters) {
        Painter painter = PainterSupport.getPainter(component);
        if (painter != null) {
            if (painter instanceof ParameterizedPaint) {
                ParameterizedPaint parameterizedPaint = (ParameterizedPaint)((Object)painter);
                parameterizedPaint.prepareToPaint(parameters);
                painter.paint((Graphics2D)g, component, ui, new Bounds(component));
            } else {
                throw new PainterException("Painter doesn't support parameters: " + painter);
            }
        }
    }

    @Nullable
    public static Dimension getPreferredSize(@NotNull JComponent component) {
        return PainterSupport.getPreferredSize(component, null, false);
    }

    @Nullable
    public static Dimension getPreferredSize(@NotNull JComponent component, @Nullable Dimension preferred) {
        return PainterSupport.getPreferredSize(component, preferred, false);
    }

    @Nullable
    public static Dimension getPreferredSize(@NotNull JComponent component, @Nullable Dimension preferred, boolean ignoreLayoutSize) {
        LayoutManager layout;
        WebLookAndFeel.checkEventDispatchThread();
        Painter painter = PainterSupport.getPainter(component);
        Dimension ps = SwingUtils.max(preferred, painter != null ? painter.getPreferredSize() : null);
        if (!ignoreLayoutSize && (layout = component.getLayout()) != null) {
            ps = SwingUtils.max(ps, layout.preferredLayoutSize(component));
        }
        return ps;
    }

    public static boolean isDecoratable(@Nullable Component component) {
        return PainterSupport.getPainter(component) instanceof AbstractDecorationPainter;
    }
}

