/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.api.annotations.NotNull;
import com.alee.managers.style.Bounds;
import com.alee.painter.decoration.ContentDecoration;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

@XStreamAlias(value="ninepatch")
public class NinePatchDecoration<C extends JComponent, I extends NinePatchDecoration<C, I>>
extends ContentDecoration<C, I> {
    protected NinePatchIcon icon;

    public NinePatchIcon getIcon() {
        return this.icon;
    }

    @Override
    public Insets getBorderInsets(C c) {
        NinePatchIcon icon;
        Insets insets = super.getBorderInsets(c);
        if (this.isVisible() && (icon = this.getIcon()) != null) {
            SwingUtils.increase(insets, icon.getMargin());
        }
        return insets;
    }

    @Override
    @NotNull
    public Shape provideShape(@NotNull C component, @NotNull Rectangle bounds) {
        return bounds;
    }

    @Override
    public void paint(Graphics2D g2d, C c, Bounds bounds) {
        NinePatchIcon icon;
        if (this.isVisible() && (icon = this.getIcon()) != null) {
            icon.paintIcon(g2d, bounds.get());
        }
        this.paintContent(g2d, bounds, c);
    }
}

