/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.content;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AbstractIconContent<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractIconContent<C, D, I>>
extends AbstractContent<C, D, I> {
    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "icon";
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d) {
        return this.getIcon(c, d) == null;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        Icon icon = this.getIcon(c, d);
        if (icon != null) {
            int x = bounds.x + bounds.width / 2 - icon.getIconWidth() / 2;
            int y = bounds.y + bounds.height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon((Component)c, g2d, x, y);
        }
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        Icon icon = this.getIcon(c, d);
        return icon != null ? new Dimension(icon.getIconWidth(), icon.getIconHeight()) : new Dimension(0, 0);
    }

    @Nullable
    protected abstract Icon getIcon(@NotNull C var1, @NotNull D var2);
}

