/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.content;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.painter.decoration.content.TextRasterization;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.BasicHTML;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.text.View;

public abstract class AbstractTextContent<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractTextContent<C, D, I>>
extends AbstractContent<C, D, I>
implements SwingConstants {
    @XStreamAsAttribute
    @Nullable
    protected TextRasterization rasterization;
    @XStreamAsAttribute
    @Nullable
    protected Color color;
    @XStreamAsAttribute
    @Nullable
    protected Boolean ignoreCustomColor;
    @XStreamAsAttribute
    @Nullable
    protected Integer halign;
    @XStreamAsAttribute
    @Nullable
    protected Integer valign;
    @XStreamAsAttribute
    @Nullable
    protected Boolean truncate;
    @XStreamAsAttribute
    @Nullable
    protected Boolean shadow;
    @XStreamAsAttribute
    @Nullable
    protected Color shadowColor;
    @XStreamAsAttribute
    @Nullable
    protected Integer shadowSize;
    @XStreamAsAttribute
    @Nullable
    protected Float shadowOpacity;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient String htmlSettings;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient View htmlView;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "text";
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d) {
        return TextUtils.isEmpty((String)this.getText(c, d));
    }

    @Override
    public void deactivate(@NotNull C c, @NotNull D d) {
        super.deactivate(c, d);
        this.cleanupHtml(c, d);
    }

    @NotNull
    public TextRasterization getRasterization(@NotNull C c, @NotNull D d) {
        return this.rasterization != null ? this.rasterization : TextRasterization.subpixel;
    }

    @NotNull
    protected Font getFont(@NotNull C c, @NotNull D d) {
        return ((Component)c).getFont();
    }

    @NotNull
    protected FontMetrics getFontMetrics(@NotNull C c, @NotNull D d) {
        return ((JComponent)c).getFontMetrics(this.getFont(c, d));
    }

    @NotNull
    protected Color getColor(@NotNull C c, @NotNull D d) {
        return this.color != null && (this.isIgnoreCustomColor(c, d) || SwingUtils.isUIResource(this.getCustomColor(c, d))) ? this.color : this.getCustomColor(c, d);
    }

    @NotNull
    protected Color getCustomColor(@NotNull C c, @NotNull D d) {
        return ((Component)c).getForeground();
    }

    public boolean isIgnoreCustomColor(@NotNull C c, @NotNull D d) {
        return this.ignoreCustomColor != null && this.ignoreCustomColor != false;
    }

    protected int getHorizontalAlignment(@NotNull C c, @NotNull D d) {
        return this.halign != null ? this.halign : 10;
    }

    protected int getAdjustedHorizontalAlignment(@NotNull C c, @NotNull D d) {
        int adjusted;
        int alignment = this.getHorizontalAlignment(c, d);
        switch (alignment) {
            case 10: {
                adjusted = this.isLeftToRight(c, d) ? 2 : 4;
                break;
            }
            case 11: {
                adjusted = this.isLeftToRight(c, d) ? 4 : 2;
                break;
            }
            default: {
                adjusted = alignment;
            }
        }
        return adjusted;
    }

    protected int getVerticalAlignment(@NotNull C c, @NotNull D d) {
        return this.valign != null ? this.valign : 0;
    }

    protected boolean isTruncate(@NotNull C c, @NotNull D d) {
        return this.truncate == null || this.truncate != false;
    }

    protected boolean isShadow(@NotNull C c, @NotNull D d) {
        return this.shadow != null && this.shadow != false;
    }

    @NotNull
    protected Color getShadowColor(@NotNull C c, @NotNull D d) {
        if (this.shadowColor == null) {
            throw new DecorationException("Shadow color must be specified");
        }
        return this.shadowColor;
    }

    protected int getShadowSize(@NotNull C c, @NotNull D d) {
        return this.shadowSize != null ? this.shadowSize : 2;
    }

    public float getShadowOpacity(@NotNull C c, @NotNull D d) {
        return this.shadowOpacity != null ? this.shadowOpacity.floatValue() : 0.8f;
    }

    protected boolean isHtmlText(@NotNull C c, @NotNull D d) {
        String text = this.getText(c, d);
        boolean html = BasicHTML.isHTMLString(c, text);
        if (!html) {
            this.cleanupHtml(c, d);
        }
        return html;
    }

    @NotNull
    protected View getHtml(@NotNull C c, @NotNull D d) {
        String text = this.getText(c, d);
        Font font = this.getFont(c, d);
        Color foreground = this.getColor(c, d);
        String settings = text + ";" + font + ";" + foreground;
        if (this.htmlView == null || Objects.notEquals((Object)this.htmlSettings, (Object)settings)) {
            this.htmlSettings = settings;
            this.htmlView = BasicHTML.createHTMLView(c, text, font, foreground);
        }
        return this.htmlView;
    }

    protected void cleanupHtml(@NotNull C c, @NotNull D d) {
        this.htmlSettings = null;
        this.htmlView = null;
    }

    @Nullable
    protected abstract String getText(@NotNull C var1, @NotNull D var2);

    protected abstract int getMnemonicIndex(@NotNull C var1, @NotNull D var2);

    @Override
    public boolean hasContentBaseline(@NotNull C c, @NotNull D d) {
        return !this.isHtmlText(c, d);
    }

    @Override
    public int getContentBaseline(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        int baseline;
        if (!this.isHtmlText(c, d)) {
            FontMetrics fm = this.getFontMetrics(c, d);
            baseline = this.getTextY(c, d, bounds, fm);
        } else {
            baseline = -1;
        }
        return baseline;
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getContentBaselineResizeBehavior(@NotNull C c, @NotNull D d) {
        Component.BaselineResizeBehavior result;
        if (!this.isHtmlText(c, d)) {
            switch (this.getVerticalAlignment(c, d)) {
                case 1: {
                    result = Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                    break;
                }
                case 3: {
                    result = Component.BaselineResizeBehavior.CONSTANT_DESCENT;
                    break;
                }
                case 0: {
                    result = Component.BaselineResizeBehavior.CENTER_OFFSET;
                    break;
                }
                default: {
                    result = Component.BaselineResizeBehavior.OTHER;
                    break;
                }
            }
        } else {
            result = Component.BaselineResizeBehavior.OTHER;
        }
        return result;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        if (!this.isEmpty(c, d)) {
            Font oldFont = GraphicsUtils.setupFont((Graphics)g2d, (Font)this.getFont(c, d));
            TextRasterization rasterization = this.getRasterization(c, d);
            Map oldHints = SwingUtils.setupTextAntialias(g2d, rasterization);
            Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)this.getColor(c, d));
            if (this.isHtmlText(c, d)) {
                this.paintHtml(g2d, c, d, bounds);
            } else {
                int shadowWidth = this.isShadow(c, d) ? this.getShadowSize(c, d) : 0;
                bounds.x += shadowWidth;
                bounds.width -= shadowWidth * 2;
                this.paintText(g2d, c, d, bounds);
            }
            GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
            SwingUtils.restoreTextAntialias(g2d, oldHints);
            GraphicsUtils.restoreFont((Graphics)g2d, (Font)oldFont);
        }
    }

    protected void paintHtml(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        this.getHtml(c, d).paint(g2d, bounds);
    }

    protected void paintText(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        String text = this.getText(c, d);
        if (TextUtils.notEmpty((String)text)) {
            FontMetrics fontMetrics = this.getFontMetrics(c, d);
            int textWidth = fontMetrics.stringWidth(text);
            int horizontalAlignment = this.getAdjustedHorizontalAlignment(c, d);
            int mnemonicIndex = this.getMnemonicIndex(c, d);
            int textX = this.getTextX(c, d, bounds, textWidth, horizontalAlignment);
            int textY = this.getTextY(c, d, bounds, fontMetrics);
            String paintedText = this.getPaintedText(c, d, bounds, text, fontMetrics, textWidth, horizontalAlignment);
            this.paintTextFragment(c, d, g2d, paintedText, textX, textY, mnemonicIndex);
        }
    }

    protected int getTextX(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds, int width, int alignment) {
        int textX = bounds.x;
        if (width < bounds.width) {
            switch (alignment) {
                case 2: {
                    break;
                }
                case 0: {
                    textX = (int)((double)textX + Math.floor((double)(bounds.width - width) / 2.0));
                    break;
                }
                case 4: {
                    textX += bounds.width - width;
                    break;
                }
                default: {
                    throw new DecorationException("Incorrect horizontal alignment provided: " + alignment);
                }
            }
        }
        return textX;
    }

    protected int getTextY(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds, @NotNull FontMetrics fm) {
        int textY = bounds.y;
        int va = this.getVerticalAlignment(c, d);
        switch (va) {
            case 1: {
                textY += fm.getAscent();
                break;
            }
            case 0: {
                textY = (int)((double)textY + Math.ceil((double)(bounds.height + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2.0));
                break;
            }
            case 3: {
                textY += bounds.height - fm.getHeight();
                break;
            }
            default: {
                throw new DecorationException("Incorrect vertical alignment provided: " + va);
            }
        }
        return textY;
    }

    @NotNull
    protected String getPaintedText(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds, @NotNull String text, @NotNull FontMetrics fm, int width, int alignment) {
        String paintedText = this.isTruncate(c, d) && bounds.width < width ? SwingUtilities.layoutCompoundLabel(fm, text, null, 0, alignment, 0, 0, bounds, new Rectangle(), new Rectangle(), 0) : text;
        return paintedText;
    }

    protected void paintTextFragment(@NotNull C c, @NotNull D d, @NotNull Graphics2D g2d, @NotNull String text, int textX, int textY, int mnemonicIndex) {
        this.paintTextShadow(c, d, g2d, text, textX, textY);
        this.paintTextString(c, d, g2d, text, textX, textY);
        this.paintMnemonic(c, d, g2d, text, mnemonicIndex, textX, textY);
    }

    protected void paintTextShadow(@NotNull C c, @NotNull D d, @NotNull Graphics2D g2d, @NotNull String text, int textX, int textY) {
        if (this.isShadow(c, d)) {
            AlphaComposite alphaComposite;
            RenderingHints rh = g2d.getRenderingHints();
            float opacity = this.getShadowOpacity(c, d);
            int size = this.getShadowSize(c, d);
            Color color = this.getShadowColor(c, d);
            double tx = -size;
            double ty = 1 - size;
            Composite oldComposite = g2d.getComposite();
            Color oldColor = g2d.getColor();
            g2d.translate((double)textX + tx, (double)textY + ty);
            float preAlpha = 0.4f;
            if (oldComposite instanceof AlphaComposite && (alphaComposite = (AlphaComposite)oldComposite).getRule() == 3) {
                preAlpha = alphaComposite.getAlpha() * preAlpha;
            }
            g2d.setPaint(ColorUtils.opaque((Color)color));
            int maxSize = size - 1;
            for (int i = -size; i <= maxSize; ++i) {
                for (int j = -size; j <= maxSize; ++j) {
                    double distance = i * i + j * j;
                    float alpha = distance > 0.0 ? (float)(1.0 / (distance * (double)size * (double)opacity)) : opacity;
                    if ((alpha *= preAlpha) > 1.0f) {
                        alpha = 1.0f;
                    }
                    g2d.setComposite(AlphaComposite.getInstance(3, alpha));
                    g2d.drawString(text, i + size, j + size);
                }
            }
            g2d.translate((double)(-textX) - tx, (double)(-textY) - ty);
            g2d.setComposite(oldComposite);
            g2d.setPaint(oldColor);
            g2d.setRenderingHints(rh);
        }
    }

    protected void paintTextString(@NotNull C c, @NotNull D d, @NotNull Graphics2D g2d, @NotNull String text, int textX, int textY) {
        g2d.drawString(text, textX, textY);
    }

    protected void paintMnemonic(@NotNull C c, @NotNull D d, @NotNull Graphics2D g2d, @NotNull String text, int mnemonicIndex, int textX, int textY) {
        if (mnemonicIndex >= 0 && mnemonicIndex < text.length()) {
            FontMetrics fm = this.getFontMetrics(c, d);
            g2d.fillRect(textX + fm.stringWidth(text.substring(0, mnemonicIndex)), textY + fm.getDescent() - 1, fm.charWidth(text.charAt(mnemonicIndex)), 1);
        }
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        Dimension ps;
        if (!this.isEmpty(c, d)) {
            if (this.isHtmlText(c, d)) {
                View html = this.getHtml(c, d);
                int w = (int)html.getPreferredSpan(0);
                int h = (int)html.getPreferredSpan(1);
                ps = new Dimension(w, h);
            } else {
                Dimension pts = this.getPreferredTextSize(c, d, available);
                pts.width = pts.width + (this.isShadow(c, d) ? this.getShadowSize(c, d) * 2 : 0);
                ps = pts;
            }
        } else {
            ps = new Dimension(0, 0);
        }
        return ps;
    }

    @NotNull
    protected Dimension getPreferredTextSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        String text = this.getText(c, d);
        FontMetrics fm = this.getFontMetrics(c, d);
        int w = SwingUtils.stringWidth(fm, text);
        int h = fm.getHeight();
        return new Dimension(w, h);
    }
}

